/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.javafx.internal;

import com.sun.javafx.scene.traversal.Direction;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.javafx.internal.FXUtil;
import com.teamdev.jxbrowser.chromium.javafx.internal.ad;
import com.teamdev.jxbrowser.chromium.javafx.internal.ae;
import com.teamdev.jxbrowser.chromium.javafx.internal.af;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.Node;
import javafx.stage.Window;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class Native {
    private static final Logger a = LoggerProvider.getIPCLogger();
    private static Native b = null;

    public static Native getInstance() {
        if (b == null) {
            if (Environment.isWindows()) {
                b = new af();
            } else if (Environment.isMac()) {
                b = new ae();
            } else if (Environment.isLinux()) {
                b = new ad();
            } else {
                throw new IllegalStateException("Unsupported operating system.");
            }
        }
        return b;
    }

    /*
     * WARNING - void declaration
     */
    public final long getWindowHandle(Window window) {
        try {
            void var1_1;
            Class<?> clazz;
            Object object = FXUtil.getJFXPanel(window);
            if (object != null) {
                return com.teamdev.jxbrowser.chromium.swing.internal.Native.getInstance().getWindowHandle((Component)object);
            }
            object = FXUtil.getEmbeddedOuter(window);
            if (object != null && (clazz = Class.forName("org.eclipse.swt.widgets.Control")).isInstance(object)) {
                window = clazz.getDeclaredField("handle");
                window = (Number)window.get(object);
                return window.longValue();
            }
            return this.getPlatformWindowHandle((Window)var1_1);
        }
        catch (Throwable throwable) {
            a.log(Level.WARNING, "Failed to get native window handle.", throwable);
            return 0L;
        }
    }

    protected abstract long getPlatformWindowHandle(Window var1);

    /*
     * WARNING - void declaration
     */
    public final void traverseFocus(Node node, Direction direction) {
        void var2_2;
        node.impl_traverse((Direction)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isDpiAware(double deviceScaleFactor) {
        void var1_1;
        return Environment.isMac() || Environment.isWindows() && Math.abs(1.25 - var1_1) >= 1.0E-6;
    }
}

