/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.ChromiumLocale;
import com.teamdev.jxbrowser.chromium.internal.ChromiumLocaleFactory;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.FileUtil;
import com.teamdev.jxbrowser.chromium.internal.SharedMemoryLibrary;
import com.teamdev.jxbrowser.chromium.internal.ipc.ProcessDpiAwareness;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChromiumProcessListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ChromiumProcess {
    private static final Logger a = LoggerProvider.getChromiumProcessLogger();
    private final File b;
    private final List<ChromiumProcessListener> c;
    private double d;
    private boolean e;

    /*
     * WARNING - void declaration
     */
    protected ChromiumProcess(String workingDir) {
        void var1_1;
        this.b = new File((String)var1_1);
        this.c = new CopyOnWriteArrayList<ChromiumProcessListener>();
    }

    private static String a() {
        String string = System.getenv("LOCALAPPDATA");
        string = System.getProperty("jxbrowser.dmp.dir", string != null ? string + "\\JxBrowser" : "");
        try {
            FileUtil.validateDirectory(string);
        }
        catch (IOException iOException) {
            a.log(Level.WARNING, "Failed to access dump folder: " + iOException.getMessage());
            return "";
        }
        return string;
    }

    private static void a(List<String> object, List<String> object2, ChromiumLocale object3) {
        String string;
        List<String> list = ((ChromiumLocale)object3).getSupportedLanguages();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            string = (String)object2.next();
            if (!string.startsWith("--lang=")) continue;
            object2 = string.substring(7);
            if (!list.contains(object2)) {
                object2 = new StringBuilder();
                object = list.iterator();
                while (object.hasNext()) {
                    object3 = (String)object.next();
                    ((StringBuilder)object2).append((String)object3);
                    if (!object.hasNext()) continue;
                    ((StringBuilder)object2).append(", ");
                }
                throw new IllegalArgumentException("The '" + string + "' Chromium switcher contains unsupported language value. Use one of the following language values: " + object2 + '.');
            }
            return;
        }
        object2 = Locale.getDefault();
        string = ((Locale)object2).getLanguage();
        object2 = ((Locale)object2).getCountry();
        if ((object2 = ((ChromiumLocale)object3).findSupportedLanguage(string, (String)object2)) != null) {
            object.add((String)("--lang=" + (String)object2));
        }
    }

    public String getWorkingDir() {
        return this.b.getAbsolutePath();
    }

    /*
     * WARNING - void declaration
     */
    public void addChromiumProcessListener(ChromiumProcessListener listener) {
        if (!this.c.contains(listener)) {
            void var1_1;
            this.c.add((ChromiumProcessListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeChromiumProcessListener(ChromiumProcessListener listener) {
        void var1_1;
        this.c.remove(var1_1);
    }

    public List<ChromiumProcessListener> getChromiumProcessListeners() {
        return new ArrayList<ChromiumProcessListener>(this.c);
    }

    public boolean hasForceScaleFactor() {
        return this.e;
    }

    public double getForceDeviceScaleFactor() {
        return this.d;
    }

    public int start(int socketPort) {
        Iterator iterator;
        String string;
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("--port=" + n2);
        arrayList.add("--pid=" + SharedMemoryLibrary.getInstance().getCurrentProcessId());
        if (Environment.isWindows()) {
            try {
                n2 = SharedMemoryLibrary.getInstance().getProcessDpiAwareness();
                ProcessDpiAwareness processDpiAwareness = ProcessDpiAwareness.from(n2);
                if (processDpiAwareness != null) {
                    arrayList.add("--dpi-awareness=" + processDpiAwareness.getStringRepresentation());
                }
            }
            catch (RuntimeException runtimeException) {
                a.log(Level.WARNING, runtimeException.getMessage());
            }
        }
        if (Environment.isWindows() && !(string = ChromiumProcess.a()).isEmpty()) {
            arrayList.add("--crash-dump-dir=" + string);
        }
        if ((iterator = BrowserPreferences.getUserAgent()) != null && !((String)((Object)iterator)).isEmpty()) {
            arrayList.add("--user-agent=" + (String)((Object)iterator));
        }
        iterator = ChromiumLocaleFactory.create(this.getWorkingDir());
        ChromiumProcess.a(arrayList, BrowserPreferences.getChromiumSwitches(), (ChromiumLocale)((Object)iterator));
        if (Environment.isMac()) {
            arrayList.add("--disable-remote-core-animation");
        }
        iterator = System.getProperty("jxbrowser.chromium.sandbox", "false");
        if (Environment.isWindows() && !Boolean.valueOf((String)((Object)iterator)).booleanValue()) {
            arrayList.add("--no-sandbox");
        }
        if ((iterator = System.getProperty("jxbrowser.chromium.switches")) != null) {
            iterator = new StringTokenizer((String)((Object)iterator), " ");
            while (((StringTokenizer)((Object)iterator)).hasMoreTokens()) {
                arrayList.add(((StringTokenizer)((Object)iterator)).nextToken());
            }
        }
        iterator = BrowserPreferences.getChromiumSwitches();
        arrayList.addAll((Collection<String>)((Object)iterator));
        for (String numberFormatException : arrayList) {
            if (!numberFormatException.startsWith("--force-device-scale-factor=")) continue;
            String string2 = numberFormatException.substring(28);
            try {
                this.d = Double.valueOf(string2);
                this.e = true;
            }
            catch (NumberFormatException numberFormatException2) {
                a.log(Level.WARNING, "Failed to parse force device scale factor.", numberFormatException2);
            }
        }
        int n3 = this.doStart(arrayList);
        a.info("Chromium process exit code " + n3);
        for (ChromiumProcessListener chromiumProcessListener : this.getChromiumProcessListeners()) {
            chromiumProcessListener.onExit(n3);
        }
        return n3;
    }

    protected abstract int doStart(List<String> var1);

    public abstract boolean isStarted();
}

