/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.ChromiumArchive;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.FileUtil;
import com.teamdev.jxbrowser.chromium.internal.XZUtilName;
import com.teamdev.jxbrowser.chromium.internal.xz.XZ;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class XZExtractor {
    public static void extract(File destDir, ChromiumArchive chromiumArchive) {
        String string = chromiumArchive.getArchiveName();
        Object object = destDir;
        if (((File)object).exists() && !((File)object).isDirectory()) {
            throw new IllegalArgumentException("Cannot create directory to extract Chromium. File with the same name already exists: " + ((File)object).getAbsolutePath());
        }
        FileUtil.createDirs(destDir);
        object = XZUtilName.get();
        File file = new File(destDir, string);
        File file2 = new File(destDir, (String)object);
        try {
            File file3;
            XZExtractor.a(string, file);
            XZExtractor.a((String)object, file2);
            if (!Environment.isWindows()) {
                FileUtil.restorePermissionsForFile(file2);
            }
            XZ.decompress(file2, file, file3);
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        finally {
            FileUtil.deleteFile(file);
            FileUtil.deleteFile(file2);
        }
    }

    static URL a(String string) {
        Serializable serializable = XZExtractor.class.getResource(string);
        if (serializable == null) {
            String string2;
            StringBuilder stringBuilder = new StringBuilder("com.teamdev.jxbrowser.chromium.internal.res.IDEAJARAnalyzerFix");
            if (Environment.isWindows()) {
                string2 = "Win32";
            } else if (Environment.isMac()) {
                string2 = "Mac";
            } else if (Environment.isLinux() && Environment.is64Bit()) {
                string2 = "Linux64";
            } else {
                throw new IllegalStateException("Unsupported operating system");
            }
            serializable = stringBuilder.append(string2).toString();
            try {
                serializable = Class.forName((String)((Object)serializable));
                serializable = serializable.getResource(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException("The " + string + " resource cannot be found in JAR files", classNotFoundException);
            }
        }
        if (serializable != null) {
            return serializable;
        }
        throw new IllegalArgumentException("The " + string + " resource cannot be found in JAR files");
    }

    private static void a(String object, File object2) {
        if (((File)object2).exists()) {
            FileUtil.deleteFile((File)object2);
        }
        if (!((File)object2).createNewFile()) {
            throw new RuntimeException("Cannot create file: " + ((File)object2).getAbsolutePath());
        }
        object = XZExtractor.a((String)object);
        object = ((URL)object).openStream();
        object2 = new FileOutputStream((File)object2).getChannel();
        try {
            Object object3 = object2;
            Object object4 = object;
            ReadableByteChannel readableByteChannel = Channels.newChannel((InputStream)object4);
            ((FileChannel)object3).transferFrom(readableByteChannel, 0L, ((InputStream)object4).available());
            return;
        }
        finally {
            ((InputStream)object).close();
            ((AbstractInterruptibleChannel)object2).close();
        }
    }

    static {
        LoggerProvider.getBrowserLogger();
    }
}

