/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.javafx.internal;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.stage.Window;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class WindowScreenWatcher {
    private final Observer observer;
    private final ChangeListener<Number> scaleFactorListener;
    private final WindowShowingListener windowShowingListener;

    public WindowScreenWatcher(Observer observer) {
        this.observer = observer;
        this.scaleFactorListener = new ScaleFactorListener();
        this.windowShowingListener = new WindowShowingListener();
    }

    public void attach(Window window) {
        window.renderScaleXProperty().addListener(this.scaleFactorListener);
        window.renderScaleYProperty().addListener(this.scaleFactorListener);
        window.showingProperty().addListener((ChangeListener)this.windowShowingListener);
    }

    public void detach(Window window) {
        window.renderScaleXProperty().removeListener(this.scaleFactorListener);
        window.renderScaleYProperty().removeListener(this.scaleFactorListener);
        window.showingProperty().removeListener((ChangeListener)this.windowShowingListener);
    }

    private class WindowShowingListener
    implements ChangeListener<Boolean> {
        private WindowShowingListener() {
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                WindowScreenWatcher.this.observer.onScreenUpdated();
            }
        }
    }

    private class ScaleFactorListener
    implements ChangeListener<Number> {
        private ScaleFactorListener() {
        }

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            WindowScreenWatcher.this.observer.onScreenUpdated(newValue.doubleValue());
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface Observer {
        public void onScreenUpdated();

        public void onScreenUpdated(double var1);
    }
}

