/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.z80.math;

import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.math.MathConverter;
import com.ti.eps.calc.math.MathNumber;
import com.ti.eps.calc.ti73.Ti73Constants;
import com.ti.eps.calc.z80.math.Operand;
import com.ti.eps.calc.z80.math.Z80Number;

public class Z80MathConverter
implements MathConverter {
    private static MathConverter INSTANCE = new Z80MathConverter();

    @Override
    public MathNumber mathNumberFromDevice(byte[] byArray, int n) {
        return new Z80Number(byArray, n);
    }

    @Override
    public byte[] deviceFromMathNumber(MathNumber mathNumber, DBUSDeviceCode dBUSDeviceCode) {
        return Z80MathConverter.to83fp(mathNumber, dBUSDeviceCode);
    }

    @Override
    public byte[] deviceFromMathNumber(MathNumber mathNumber, byte[] byArray, int n, DBUSDeviceCode dBUSDeviceCode) {
        return Z80MathConverter.to83fp(mathNumber, byArray, n, dBUSDeviceCode);
    }

    private Z80MathConverter() {
    }

    public static MathConverter getInstance() {
        return INSTANCE;
    }

    private static byte[] to83fp(MathNumber mathNumber, DBUSDeviceCode dBUSDeviceCode) {
        return Z80MathConverter.mathNumberTo83fp(mathNumber, dBUSDeviceCode);
    }

    private static byte[] mathNumberTo83fp(MathNumber mathNumber, DBUSDeviceCode dBUSDeviceCode) {
        String string;
        if (!(mathNumber instanceof Z80Number)) {
            mathNumber = new Z80Number(mathNumber.toString());
        }
        Z80Number z80Number = (Z80Number)mathNumber;
        Operand operand = new Operand(z80Number.getOperand());
        byte[] byArray = new byte[9];
        byArray[0] = (byte)(operand.sign + operand.type);
        if (operand.isFrac() && dBUSDeviceCode == Ti73Constants.UNIT_CODE) {
            byArray[1] = 0;
            string = Z80MathConverter.fracMakeStr(operand.denominator, 4) + "00";
            string = operand.wholenum == 0 ? Z80MathConverter.fracMakeStr(operand.numerator, 6) + "00" + string : Z80MathConverter.fracMakeStr(operand.wholenum, 3) + "0" + Z80MathConverter.fracMakeStr(operand.numerator, 3) + "0" + string;
        } else {
            operand.fracToDec();
            byArray[0] = (byte)(operand.sign + operand.type);
            byArray[1] = (byte)(128 + (byte)operand.exp);
            long l = operand.mant;
            string = Long.toString(l);
        }
        char[] cArray = string.toCharArray();
        Z80MathConverter.fillMantissa(cArray, byArray);
        return byArray;
    }

    private static String fracMakeStr(int n, int n2) {
        String string = Integer.toString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    private static byte[] to83fp(MathNumber mathNumber, byte[] byArray, int n, DBUSDeviceCode dBUSDeviceCode) {
        return Z80MathConverter.mathNumberTo83fp(mathNumber, byArray, n, dBUSDeviceCode);
    }

    private static byte[] mathNumberTo83fp(MathNumber mathNumber, byte[] byArray, int n, DBUSDeviceCode dBUSDeviceCode) {
        byte[] byArray2 = Z80MathConverter.mathNumberTo83fp(mathNumber, dBUSDeviceCode);
        for (int i = 0; i < byArray2.length; ++i) {
            byArray[n + i] = byArray2[i];
        }
        return byArray;
    }

    private static void fillMantissa(char[] cArray, byte[] byArray) {
        int n;
        int n2;
        char[] cArray2 = new char[15];
        for (n2 = 0; n2 < 15; ++n2) {
            cArray2[n2] = 48;
        }
        n2 = 0;
        for (n = 0; n < cArray.length && n2 < 15; ++n) {
            if (cArray[n] == '.') continue;
            cArray2[n2++] = cArray[n];
        }
        n = 0;
        for (int i = 2; i < 9; ++i) {
            byte by = (byte)(16.0 * (double)Character.digit(cArray2[n++], 10));
            byArray[i] = by = (byte)(by + (byte)Character.digit(cArray2[n++], 10));
        }
    }
}

