/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.z80.math;

import com.ti.eps.calc.math.MathContext;
import com.ti.eps.calc.math.MathEngine;
import com.ti.eps.calc.math.MathNumber;
import com.ti.eps.calc.z80.math.Z80MathEngine;
import com.ti.eps.calc.z80.math.Z80Number;

public class Z80MathContext
implements MathContext {
    private double errorTolerance = 1.0E-7;
    private static final Z80MathContext instance = new Z80MathContext();
    private static final MathEngine mathEngine = Z80MathEngine.getInstance();

    public static MathContext getInstance() {
        return instance;
    }

    @Override
    public MathEngine getMathEngine() {
        return mathEngine;
    }

    @Override
    public MathNumber parseMathNumber(String string) {
        return this.getNumberFromString(string);
    }

    public MathNumber getNumberFromString(String string) {
        return new Z80Number(string);
    }

    @Override
    public double getErrorTolerance() {
        return this.errorTolerance;
    }

    @Override
    public boolean isRemainderTolerance(double d, double d2) {
        long l = Math.round(d / d2);
        return Math.abs((double)l * d2 - d) < this.getErrorTolerance();
    }

    @Override
    public boolean isInErrorTolerance(double d, double d2) {
        return Math.abs(d - d2) < this.getErrorTolerance();
    }
}

