/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.z80.assessment;

import com.ti.eps.calc.z80.assessment.Z80AssessmentObj;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObjAssessmentAutoDelete;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObjAssessmentFilename;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObjAssessmentGUID;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObjAssessmentType;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObjDeviceSerialNumber;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObjEndHeader;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObjEndResponses;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObjExplanatoryResponse;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObjFIBResponse;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObjItemResponse;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObjMultipleResponseLabel;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObjNumericResponse;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObjRevision;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObjStudentID;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObjTextResponse;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObjUsefileAppvarVersion;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObjVersion;
import com.ti.eps.calc.z80.assessment.Z80AssessmentTag;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Z80AssessmentObjStreamReader {
    private static final Logger logger = Logger.getLogger(Z80AssessmentObjStreamReader.class.getName());
    private static final int MAX_GUID_LEN = 256;
    private static final int MAX_FILENAME_LEN = 64;
    private static final int MAX_SERIAL_LEN = 64;
    private static final int MAX_VERSION_LEN = 64;

    public static Z80AssessmentObj readObj(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        Z80AssessmentTag z80AssessmentTag = Z80AssessmentTag.find(n);
        if (z80AssessmentTag == null) {
            logger.log(Level.FINE, "Unrecognized tag: " + n);
            throw new IOException("Unrecognized tag: " + n);
        }
        if (z80AssessmentTag.getValue() == Z80AssessmentTag.USEFILE_APPVAR_VERSION.getValue()) {
            return Z80AssessmentObjStreamReader.readUsefileAppvarVersion(inputStream);
        }
        if (z80AssessmentTag.getValue() == Z80AssessmentTag.ASSESSMENT_GUID.getValue()) {
            return Z80AssessmentObjStreamReader.readAssessmentGUID(inputStream);
        }
        if (z80AssessmentTag.getValue() == Z80AssessmentTag.REVISION.getValue()) {
            return Z80AssessmentObjStreamReader.readRevision(inputStream);
        }
        if (z80AssessmentTag.getValue() == Z80AssessmentTag.ASSESSMENT_FILENAME.getValue()) {
            return Z80AssessmentObjStreamReader.readAssessmentFilename(inputStream);
        }
        if (z80AssessmentTag.getValue() == Z80AssessmentTag.DEVICE_SERIAL_NUM.getValue()) {
            return Z80AssessmentObjStreamReader.readDeviceSerialNumber(inputStream);
        }
        if (z80AssessmentTag.getValue() == Z80AssessmentTag.STUDENT_ID.getValue()) {
            return Z80AssessmentObjStreamReader.readStudentID(inputStream);
        }
        if (z80AssessmentTag.getValue() == Z80AssessmentTag.ASSESSMENT_TYPE.getValue()) {
            return Z80AssessmentObjStreamReader.readAssessmentType(inputStream);
        }
        if (z80AssessmentTag.getValue() == Z80AssessmentTag.VERSION.getValue()) {
            return Z80AssessmentObjStreamReader.readVersion(inputStream);
        }
        if (z80AssessmentTag.getValue() == Z80AssessmentTag.ASSESSMENT_AUTO_DELETE.getValue()) {
            return Z80AssessmentObjStreamReader.readAssessmentAutoDelete(inputStream);
        }
        if (z80AssessmentTag.getValue() == Z80AssessmentTag.END_HEADER.getValue()) {
            return Z80AssessmentObjStreamReader.readEndHeader(inputStream);
        }
        if (z80AssessmentTag.getValue() == Z80AssessmentTag.ITEM_RESPONSE.getValue()) {
            return Z80AssessmentObjStreamReader.readItemResponse(inputStream);
        }
        if (z80AssessmentTag.getValue() == Z80AssessmentTag.END_RESPONSES.getValue()) {
            return Z80AssessmentObjStreamReader.readEndResponses(inputStream);
        }
        if (z80AssessmentTag.getValue() == Z80AssessmentTag.MULTIPLE_RESPONSE_LABEL.getValue()) {
            return Z80AssessmentObjStreamReader.readMultipleResponseLabel(inputStream);
        }
        if (z80AssessmentTag.getValue() == Z80AssessmentTag.FIB_RESPONSE.getValue()) {
            return Z80AssessmentObjStreamReader.readFIBResponse(inputStream);
        }
        if (z80AssessmentTag.getValue() == Z80AssessmentTag.TEXT_RESPONSE.getValue()) {
            return Z80AssessmentObjStreamReader.readTextResponse(inputStream);
        }
        if (z80AssessmentTag.getValue() == Z80AssessmentTag.NUMERIC_RESPONSE.getValue()) {
            return Z80AssessmentObjStreamReader.readNumericResponse(inputStream);
        }
        if (z80AssessmentTag.getValue() == Z80AssessmentTag.EXPLANATORY_RESPONSE.getValue()) {
            return Z80AssessmentObjStreamReader.readExplanatoryResponse(inputStream);
        }
        logger.log(Level.FINE, "Unsupported tag: " + n);
        throw new IOException("Unsupported tag: " + z80AssessmentTag);
    }

    public static Z80AssessmentObj readUsefileAppvarVersion(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        return new Z80AssessmentObjUsefileAppvarVersion(n);
    }

    public static Z80AssessmentObj readAssessmentGUID(InputStream inputStream) throws IOException {
        int n = Z80AssessmentObjStreamReader.read2Int(inputStream);
        if (n > 256) {
            logger.log(Level.FINE, "GUID length too long: " + n);
            throw new IOException("GUID length too long: " + n);
        }
        byte[] byArray = Z80AssessmentObjStreamReader.readBytes(inputStream, "GUID", n);
        return new Z80AssessmentObjAssessmentGUID(byArray);
    }

    public static Z80AssessmentObj readRevision(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[2];
        inputStream.read(byArray);
        return new Z80AssessmentObjRevision(byArray);
    }

    public static Z80AssessmentObj readAssessmentFilename(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n > 64) {
            logger.log(Level.FINE, "Filename length too long: " + n);
            throw new IOException("Filename length too long: " + n);
        }
        byte[] byArray = Z80AssessmentObjStreamReader.readBytes(inputStream, "filename", n);
        return new Z80AssessmentObjAssessmentFilename(byArray);
    }

    public static Z80AssessmentObj readDeviceSerialNumber(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n > 64) {
            logger.log(Level.FINE, "Device serial number length too long: " + n);
            throw new IOException("Device serial number length too long: " + n);
        }
        byte[] byArray = Z80AssessmentObjStreamReader.readBytes(inputStream, "device serial number", n);
        return new Z80AssessmentObjDeviceSerialNumber(byArray);
    }

    public static Z80AssessmentObj readStudentID(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n > 64) {
            logger.log(Level.FINE, "Student ID too long: " + n);
            throw new IOException("Student ID too long: " + n);
        }
        byte[] byArray = Z80AssessmentObjStreamReader.readBytes(inputStream, "student ID", n);
        return new Z80AssessmentObjStudentID(byArray);
    }

    public static Z80AssessmentObj readAssessmentType(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        return new Z80AssessmentObjAssessmentType(n);
    }

    public static Z80AssessmentObj readVersion(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n > 64) {
            logger.log(Level.FINE, "Version too long: " + n);
            throw new IOException("Version too long: " + n);
        }
        byte[] byArray = Z80AssessmentObjStreamReader.readBytes(inputStream, "version", n);
        return new Z80AssessmentObjVersion(byArray);
    }

    public static Z80AssessmentObj readAssessmentAutoDelete(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        return new Z80AssessmentObjAssessmentAutoDelete(n);
    }

    public static Z80AssessmentObj readEndHeader(InputStream inputStream) throws IOException {
        return new Z80AssessmentObjEndHeader();
    }

    public static Z80AssessmentObj readItemResponse(InputStream inputStream) throws IOException {
        int n = Z80AssessmentObjStreamReader.read2Int(inputStream);
        int n2 = Z80AssessmentObjStreamReader.read2Int(inputStream);
        inputStream.mark(1);
        int n3 = inputStream.read();
        Z80AssessmentTag z80AssessmentTag = Z80AssessmentTag.find(n3);
        if (z80AssessmentTag == null) {
            logger.log(Level.FINE, "Unrecognized tag as response: " + n3);
            throw new IOException("Unrecognized tag as response: " + n3);
        }
        Z80AssessmentObj[] z80AssessmentObjArray = new Z80AssessmentObj[1];
        if (z80AssessmentTag.getValue() == Z80AssessmentTag.FIB_RESPONSE.getValue()) {
            ArrayList<Z80AssessmentObjFIBResponse> arrayList = new ArrayList<Z80AssessmentObjFIBResponse>();
            arrayList.add(Z80AssessmentObjStreamReader.readFIBResponse(inputStream));
            while (true) {
                inputStream.mark(1);
                n3 = inputStream.read();
                z80AssessmentTag = Z80AssessmentTag.find(n3);
                if (z80AssessmentTag == null) {
                    logger.log(Level.FINE, "Unrecognized tag as response: " + n3);
                    throw new IOException("Unrecognized tag as response: " + n3);
                }
                if (z80AssessmentTag.getValue() != Z80AssessmentTag.FIB_RESPONSE.getValue()) break;
                arrayList.add(Z80AssessmentObjStreamReader.readFIBResponse(inputStream));
            }
            if (z80AssessmentTag.getValue() != Z80AssessmentTag.ITEM_RESPONSE.getValue() && z80AssessmentTag.getValue() != Z80AssessmentTag.END_RESPONSES.getValue()) {
                logger.log(Level.FINE, "Unsupported response tag (expected FIB response): " + z80AssessmentTag);
                throw new IOException("Unsupported response tag (expected FIB response): " + z80AssessmentTag);
            }
            inputStream.reset();
            z80AssessmentObjArray = new Z80AssessmentObj[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                z80AssessmentObjArray[i] = (Z80AssessmentObj)arrayList.get(i);
            }
        } else if (z80AssessmentTag.getValue() == Z80AssessmentTag.MULTIPLE_RESPONSE_LABEL.getValue()) {
            z80AssessmentObjArray[0] = Z80AssessmentObjStreamReader.readMultipleResponseLabel(inputStream);
        } else if (z80AssessmentTag.getValue() == Z80AssessmentTag.TEXT_RESPONSE.getValue()) {
            z80AssessmentObjArray[0] = Z80AssessmentObjStreamReader.readTextResponse(inputStream);
        } else if (z80AssessmentTag.getValue() == Z80AssessmentTag.EXPLANATORY_RESPONSE.getValue()) {
            z80AssessmentObjArray[0] = Z80AssessmentObjStreamReader.readExplanatoryResponse(inputStream);
        } else if (z80AssessmentTag.getValue() == Z80AssessmentTag.ITEM_RESPONSE.getValue() || z80AssessmentTag.getValue() == Z80AssessmentTag.END_RESPONSES.getValue()) {
            inputStream.reset();
            z80AssessmentObjArray = null;
        } else {
            logger.log(Level.FINE, "Unsupported response tag: " + z80AssessmentTag);
            throw new IOException("Unsupported response tag: " + z80AssessmentTag);
        }
        return new Z80AssessmentObjItemResponse(n, n2, z80AssessmentObjArray);
    }

    public static Z80AssessmentObj readEndResponses(InputStream inputStream) throws IOException {
        return new Z80AssessmentObjEndResponses();
    }

    public static Z80AssessmentObj readMultipleResponseLabel(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        byte[] byArray = Z80AssessmentObjStreamReader.readBytes(inputStream, "response IDs", n);
        return new Z80AssessmentObjMultipleResponseLabel(byArray);
    }

    public static Z80AssessmentObjFIBResponse readFIBResponse(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        Z80AssessmentTag z80AssessmentTag = Z80AssessmentTag.find(n2);
        if (z80AssessmentTag == null) {
            logger.log(Level.FINE, "Unrecognized tag as FIB response: " + n2);
            throw new IOException("Unrecognized tag as FIB response: " + n2);
        }
        Z80AssessmentObj z80AssessmentObj = null;
        if (z80AssessmentTag.getValue() == Z80AssessmentTag.MULTIPLE_RESPONSE_LABEL.getValue()) {
            z80AssessmentObj = Z80AssessmentObjStreamReader.readMultipleResponseLabel(inputStream);
        } else if (z80AssessmentTag.getValue() == Z80AssessmentTag.TEXT_RESPONSE.getValue()) {
            z80AssessmentObj = Z80AssessmentObjStreamReader.readTextResponse(inputStream);
        } else if (z80AssessmentTag.getValue() == Z80AssessmentTag.NUMERIC_RESPONSE.getValue()) {
            z80AssessmentObj = Z80AssessmentObjStreamReader.readNumericResponse(inputStream);
        } else {
            logger.log(Level.FINE, "Unsupported FIB response tag: " + z80AssessmentTag);
            throw new IOException("Unsupported FIB response tag: " + z80AssessmentTag);
        }
        return new Z80AssessmentObjFIBResponse(n, z80AssessmentObj);
    }

    public static Z80AssessmentObj readTextResponse(InputStream inputStream) throws IOException {
        int n = Z80AssessmentObjStreamReader.read2Int(inputStream);
        byte[] byArray = Z80AssessmentObjStreamReader.readBytes(inputStream, "text response", n);
        return new Z80AssessmentObjTextResponse(byArray);
    }

    public static Z80AssessmentObj readNumericResponse(InputStream inputStream) throws IOException {
        byte[] byArray = Z80AssessmentObjStreamReader.readBytes(inputStream, "BCD number", 9);
        if ((byArray[0] & 0x7F) != 0) {
            logger.log(Level.FINE, "Unhandled BCD number format: " + (byArray[0] & 0x7F));
            throw new IOException("Unhandled BCD number format: " + (byArray[0] & 0x7F));
        }
        return new Z80AssessmentObjNumericResponse(byArray);
    }

    public static Z80AssessmentObj readExplanatoryResponse(InputStream inputStream) throws IOException {
        return new Z80AssessmentObjExplanatoryResponse();
    }

    private static int read2Int(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[2];
        inputStream.read(byArray);
        return (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
    }

    private static byte[] readBytes(InputStream inputStream, String string, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray);
        if (n2 != n) {
            logger.log(Level.FINE, "Error reading" + string + ": read " + n2 + " out of " + n + " bytes expected");
            throw new IOException("Error reading" + string + ": read " + n2 + " out of " + n + " bytes expected");
        }
        return byArray;
    }
}

