/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.z80.assessment;

import com.ti.eps.calc.z80.assessment.Z80AssessmentFile;
import com.ti.eps.calc.z80.assessment.Z80AssessmentFileAnswer;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObj;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObjStreamReader;
import com.ti.eps.calc.z80.assessment.Z80AssessmentTag;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Z80AssessmentFileReader {
    private static final Logger logger = Logger.getLogger(Z80AssessmentFileReader.class.getName());

    public static Z80AssessmentFile readFile(InputStream inputStream) throws IOException {
        int n = Z80AssessmentFileReader.read2Int(inputStream);
        byte[] byArray = Z80AssessmentFileReader.readBytes(inputStream, "file ID", 4);
        int n2 = Z80AssessmentFileReader.idToInt(byArray);
        ArrayList<Z80AssessmentObj> arrayList = new ArrayList<Z80AssessmentObj>();
        logger.log(Level.FINE, "Assessment size = " + n);
        logger.log(Level.FINE, "Assessment ID: 0x" + Integer.toHexString(n2));
        if (n2 != 1851880965) {
            logger.log(Level.FINE, "Unsupported assessment file type: " + Integer.toHexString(n2));
            throw new IOException("Unsupported assessment file type: " + Integer.toHexString(n2));
        }
        int n3 = Z80AssessmentFileReader.read2Int(inputStream);
        int n4 = inputStream.read();
        int n5 = Z80AssessmentFileReader.read2Int(inputStream);
        int n6 = Z80AssessmentFileReader.read2Int(inputStream);
        inputStream.skip(n3 - 5);
        logger.log(Level.FINE, "Player specific header size: " + n3);
        logger.log(Level.FINE, "Assessment status: " + n4);
        logger.log(Level.FINE, "Current entry: " + n5);
        logger.log(Level.FINE, "Top entry: " + n6);
        Z80AssessmentObj z80AssessmentObj = null;
        do {
            z80AssessmentObj = Z80AssessmentObjStreamReader.readObj(inputStream);
            arrayList.add(z80AssessmentObj);
            logger.log(Level.FINE, "Read assessment object: " + z80AssessmentObj.getTag());
        } while (z80AssessmentObj.getTag() != Z80AssessmentTag.END_RESPONSES);
        Z80AssessmentObj[] z80AssessmentObjArray = new Z80AssessmentObj[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            z80AssessmentObjArray[i] = (Z80AssessmentObj)arrayList.get(i);
        }
        return new Z80AssessmentFileAnswer(n4, n5, n6, z80AssessmentObjArray);
    }

    private static int read2Int(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[2];
        inputStream.read(byArray);
        return (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
    }

    private static byte[] readBytes(InputStream inputStream, String string, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray);
        if (n2 != n) {
            throw new IOException("Error reading" + string + ": read " + n2 + " out of " + n + " bytes expected");
        }
        return byArray;
    }

    private static int idToInt(byte[] byArray) {
        int n = 0;
        n = byArray[0] & 0xFF;
        n <<= 8;
        n |= byArray[1] & 0xFF;
        n <<= 8;
        n |= byArray[2] & 0xFF;
        n <<= 8;
        return n |= byArray[3] & 0xFF;
    }
}

