/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.z80;

public class Z80Utils {
    public static byte[] toByteArray(int n, byte[] byArray) {
        if (byArray == null || byArray.length < 1) {
            throw new IllegalArgumentException("the byte array is not valid");
        }
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(n & 0xFF);
            n >>>= 8;
        }
        return byArray;
    }

    public static int toInt(byte[] byArray) {
        int n = 0;
        int n2 = Math.min(4, byArray.length);
        while (n2-- > 0) {
            n <<= 8;
            n += byArray[n2] & 0xFF;
        }
        return n;
    }

    private Z80Utils() {
    }

    public static String byteArrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            if (i % 8 == 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(" 0x");
            int n = byArray[i] & 0xFF;
            if (n < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString().toUpperCase();
    }
}

