/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.util;

public class StringUtil {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String encodeString(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 16);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    continue block8;
                }
                case '\"': 
                case '\'': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue block8;
                }
                default: {
                    if (c >= ' ' && c <= '~') {
                        stringBuffer.append(c);
                        continue block8;
                    }
                    stringBuffer.append('\\');
                    stringBuffer.append('u');
                    stringBuffer.append(StringUtil.toHexDigit(c >> 12));
                    stringBuffer.append(StringUtil.toHexDigit(c >> 8));
                    stringBuffer.append(StringUtil.toHexDigit(c >> 4));
                    stringBuffer.append(StringUtil.toHexDigit(c));
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String decodeString(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        block12: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '\\' || i == n - 1) {
                stringBuffer.append(c);
                continue;
            }
            c = string.charAt(++i);
            switch (c) {
                case 't': {
                    stringBuffer.append('\t');
                    continue block12;
                }
                case 'r': {
                    stringBuffer.append('\r');
                    continue block12;
                }
                case 'n': {
                    stringBuffer.append('\n');
                    continue block12;
                }
                case 'f': {
                    stringBuffer.append('\f');
                    continue block12;
                }
                case 'u': {
                    int n2;
                    if (++i >= n) {
                        stringBuffer.append(c);
                        continue block12;
                    }
                    int n3 = 0;
                    int n4 = n2 = n - i > 4 ? i + 4 : n;
                    while (i < n2) {
                        c = string.charAt(i);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                n3 = (n3 << 4) + c - 48;
                                break;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                n3 = (n3 << 4) + 10 + c - 97;
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                n3 = (n3 << 4) + 10 + c - 65;
                                break;
                            }
                        }
                        ++i;
                    }
                    --i;
                    stringBuffer.append((char)n3);
                    continue block12;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static char toHexDigit(int n) {
        return HEX_DIGITS[n & 0xF];
    }

    private StringUtil() {
    }
}

