/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.util;

import java.io.PrintStream;

public class IntHashMap
implements Cloneable {
    private static final int HASH_MASK = Integer.MAX_VALUE;
    private Entry[] table;
    private int size;
    private float loadFactor;
    private int threshold;

    public IntHashMap() {
        this(101, 0.75f);
    }

    public IntHashMap(int n) {
        this(n, 0.75f);
    }

    public IntHashMap(int n, float f) {
        if (n <= 0) {
            throw new IllegalArgumentException("Non-positive capacity: " + n);
        }
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Invalid loadFactor" + f);
        }
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
        this.loadFactor = f;
    }

    public boolean containsKey(int n) {
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (n == entry.key) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean containsValue(Object object) {
        Entry[] entryArray = this.table;
        if (object == null) {
            for (int i = 0; i < entryArray.length; ++i) {
                Entry entry = entryArray[i];
                while (entry != null) {
                    if (entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            for (int i = 0; i < entryArray.length; ++i) {
                Entry entry = entryArray[i];
                while (entry != null) {
                    if (object.equals(entry)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    public Object get(int n) {
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (n == entry.key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object put(int n, Object object) {
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Object object2 = null;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (n == entry.key) {
                object2 = entry.value;
                entry.value = object;
                return object2;
            }
            entry = entry.next;
        }
        if (this.size > this.threshold) {
            entryArray = this.rehash();
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entry = new Entry(n, object);
        entry.next = entryArray[n2];
        entryArray[n2] = entry;
        ++this.size;
        return object2;
    }

    public Object remove(int n) {
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Object object = null;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (n == entry.key) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                entry.next = null;
                object = entry.value;
                --this.size;
                break;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return object;
    }

    public void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
        this.size = 0;
    }

    public int[] keys() {
        if (this.size == 0) {
            return new int[0];
        }
        Entry[] entryArray = this.table;
        int[] nArray = new int[this.size];
        int n = 0;
        try {
            for (int i = 0; i < entryArray.length; ++i) {
                Entry entry = entryArray[i];
                while (entry != null) {
                    nArray[n++] = entry.key;
                    entry = entry.next;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (n < this.size) {
            int[] nArray2 = new int[n];
            if (n > 0) {
                System.arraycopy(nArray, 0, nArray2, 0, n);
            }
            return nArray2;
        }
        return nArray;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.table.length;
    }

    public Object clone() {
        try {
            IntHashMap intHashMap = (IntHashMap)super.clone();
            Entry[] entryArray = this.table;
            intHashMap.table = new Entry[entryArray.length];
            for (int i = 0; i < entryArray.length; ++i) {
                intHashMap.table[i] = entryArray[i] != null ? (Entry)entryArray[i].clone() : null;
            }
            return intHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void dump(PrintStream printStream) {
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                printStream.println(entry);
                entry = entry.next;
            }
        }
    }

    public void dumpBucketSizes(PrintStream printStream) {
        Entry[] entryArray = this.table;
        System.out.println("Table size = " + entryArray.length);
        for (int i = 0; i < entryArray.length; ++i) {
            int n = 0;
            Entry entry = entryArray[i];
            while (entry != null) {
                ++n;
                entry = entry.next;
            }
            if (n <= 0) continue;
            System.out.println("Bucket " + i + ": size = " + n);
        }
    }

    private Entry[] rehash() {
        int n = this.table.length;
        int n2 = n * 2 + 1;
        Entry[] entryArray = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        for (int i = 0; i < n; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n3 = (entry2.key & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray[n3];
                entryArray[n3] = entry2;
            }
        }
        this.table = entryArray;
        return entryArray;
    }

    private static class Entry
    implements Cloneable {
        int key;
        Object value;
        Entry next;

        Entry(int n, Object object) {
            this.key = n;
            this.value = object;
            this.next = null;
        }

        public Object clone() {
            Entry entry = new Entry(this.key, this.value);
            if (this.next != null) {
                entry.next = (Entry)this.next.clone();
            }
            return entry;
        }

        public String toString() {
            return this.key + " => " + this.value;
        }
    }
}

