/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.ti83Plus;

import com.ti.eps.calc.dbus.DBUSCommand;
import com.ti.eps.calc.dbus.DBUSPacket;
import com.ti.eps.calc.dbus.DeviceFileDescriptor;
import com.ti.eps.calc.dbus.DeviceMessageImpl;
import com.ti.eps.calc.dbus.DeviceString;
import com.ti.eps.calc.ti83Plus.Ti83PlusConstants;
import com.ti.eps.calc.ti83Plus.Ti83PlusFontString;
import com.ti.eps.calc.ti83Plus.Ti83PlusTokenString;
import java.nio.ByteBuffer;

public class Ti83PlusFileDescriptor
extends DeviceMessageImpl
implements DeviceFileDescriptor {
    public static final byte FLAG_ARCHIVE = -128;
    private static final int SIZE_POS = 0;
    private static final int DATA_TYPE_POS = 2;
    private static final int NAME_POS = 3;
    private static final int NAME_LEN = 8;
    private static final int VERSION_POS = 11;
    private static final int DATA_TYPE_TWO_POS = 12;

    protected Ti83PlusFileDescriptor(DBUSPacket dBUSPacket) {
        super(dBUSPacket, Ti83PlusConstants.BYTE_ORDER);
        if (!DBUSCommand.RTS.equals(this.packet.getCommand())) {
            throw new IllegalArgumentException("Packet must be a RTS packet");
        }
        if (this.dataBlock.limit() < 11) {
            throw new IllegalArgumentException("Packet is not big enough to be a RTS packet");
        }
    }

    @Override
    public long getSize() {
        if (this.getType() == 36) {
            return (this.dataBlock.get(0) & 0xFF) * 16384;
        }
        return this.dataBlock.getShort(0) & 0xFFFF;
    }

    @Override
    public int getType() {
        return this.dataBlock.get(2) & 0xFF;
    }

    @Override
    public DeviceString getName() {
        DeviceString deviceString = null;
        ByteBuffer byteBuffer = this.dataBlock.duplicate();
        byteBuffer.limit(11);
        byteBuffer.position(3);
        deviceString = this.getType() == 36 || this.getType() == 21 ? new Ti83PlusFontString(byteBuffer) : new Ti83PlusTokenString(byteBuffer);
        return deviceString;
    }

    @Override
    public boolean isArchived() {
        byte by = this.dataBlock.get(12);
        return (by & 0xFFFFFF80) != 0;
    }

    public String toString() {
        return "name=" + this.getName() + " size=" + this.getSize() + " type=" + this.getType() + " isArchived=" + this.isArchived();
    }

    @Override
    public byte getVersion() {
        return this.dataBlock.get(11);
    }
}

