/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.ti83Plus;

import com.ti.eps.calc.dbus.DBUSCommand;
import com.ti.eps.calc.dbus.DBUSDataType;
import com.ti.eps.calc.dbus.DBUSPacket;
import com.ti.eps.calc.dbus.DBUSPacketFactory;
import com.ti.eps.calc.dbus.DBUSPacketRTS;
import com.ti.eps.calc.dbus.DeviceFile;
import com.ti.eps.calc.dbus.DeviceString;
import com.ti.eps.calc.ti83Plus.Ti83PlusConstants;
import com.ti.eps.calc.ti83Plus.Ti83PlusDBUSPacketRTS;
import com.ti.eps.calc.ti83Plus.Ti83PlusDBUSPacketSEND;
import com.ti.eps.calc.ti83Plus.Ti83PlusDeviceFile;
import java.util.logging.Logger;

public class Ti83PlusDBUSPacketFactory
extends DBUSPacketFactory {
    private static final Logger LOGGER = Logger.getLogger("Ti83PlusDBUSPacketFactory");
    private static final int MAX_PROGRAM_NAME_LEN = 8;
    public final DBUSPacket GETDIRPacket = new DBUSPacket(Ti83PlusConstants.PC_CODE, DBUSCommand.GET, new byte[]{0, 0, 25, 0, 0, 0, 0, 0, 0, 0, 0});

    public Ti83PlusDBUSPacketFactory() {
        super(Ti83PlusConstants.PC_CODE);
    }

    @Override
    public DBUSPacket getGetDirectoryPacket() {
        return this.GETDIRPacket;
    }

    @Override
    public DBUSPacket getSendDataObjectPacket(DeviceFile deviceFile) {
        if (!(deviceFile instanceof Ti83PlusDeviceFile)) {
            throw new IllegalArgumentException("file must be a TI-83Plus family file");
        }
        return new Ti83PlusDBUSPacketSEND((Ti83PlusDeviceFile)deviceFile);
    }

    @Override
    public DBUSPacket getGetDataObjectPacket(DBUSDataType dBUSDataType, DeviceString deviceString) {
        byte[] byArray = new byte[11];
        byArray[2] = dBUSDataType.getValue();
        byte[] byArray2 = deviceString.toBytes();
        System.arraycopy(byArray2, 0, byArray, 3, Math.min(byArray2.length, 8));
        return new DBUSPacket(Ti83PlusConstants.PC_CODE, DBUSCommand.GET, byArray);
    }

    @Override
    public DBUSPacket getGetFlashObjectPacket(DBUSDataType dBUSDataType, DeviceString deviceString) {
        byte[] byArray = new byte[13];
        byArray[2] = dBUSDataType.getValue();
        byte[] byArray2 = deviceString.toBytes();
        System.arraycopy(byArray2, 0, byArray, 3, Math.min(byArray2.length, 8));
        return new DBUSPacket(Ti83PlusConstants.PC_CODE, DBUSCommand.GET, byArray);
    }

    @Override
    public DBUSPacket getDeleteVariablePacket(DBUSDataType dBUSDataType, DeviceString deviceString) {
        byte[] byArray = deviceString.toBytes();
        byte[] byArray2 = new byte[byArray.length + 4];
        byArray2[0] = 0;
        byArray2[1] = 0;
        byArray2[2] = dBUSDataType.getValue();
        System.arraycopy(byArray, 0, byArray2, 3, byArray.length);
        byArray2[byArray2.length - 1] = 0;
        DBUSPacket dBUSPacket = new DBUSPacket(Ti83PlusConstants.PC_CODE, DBUSCommand.DVL, byArray2);
        return dBUSPacket;
    }

    @Override
    public DBUSPacket getExecuteProgramLinkPacket(DBUSDataType dBUSDataType, DeviceString deviceString) {
        byte[] byArray = deviceString.toBytes();
        if (byArray.length > 8) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("programName = ");
            for (byte by : byArray) {
                stringBuffer.append("0x");
                stringBuffer.append(Integer.toHexString(by & 0xFF));
                stringBuffer.append(" ");
            }
            LOGGER.warning(stringBuffer.toString());
            throw new IllegalArgumentException("A TI-83 Plus program name cannot be longer than 8 tokens progName='" + deviceString + "' length=" + deviceString.toBytes().length);
        }
        byte[] byArray2 = new byte[11];
        byArray2[2] = dBUSDataType.getValue();
        System.arraycopy(byArray, 0, byArray2, 3, Math.min(8, byArray.length));
        DBUSPacket dBUSPacket = new DBUSPacket(Ti83PlusConstants.PC_CODE, DBUSCommand.EPL, byArray2);
        return dBUSPacket;
    }

    @Override
    public DBUSPacketRTS getRequestToSendFlashApp(short s, byte by, short s2, byte by2) {
        if (s2 < 16384 || s2 >= 32768) {
            throw new IllegalArgumentException("pageLoadAddress out of range " + s2);
        }
        return new Ti83PlusDBUSPacketRTS(36, s, by, s2, by2);
    }

    @Override
    public DBUSPacketRTS getRequestToSendBaseCode(short s, byte by, short s2, byte by2) {
        return new Ti83PlusDBUSPacketRTS(35, s, by, s2, by2);
    }

    @Override
    public DBUSPacket getTransmitDataPacket(byte[] byArray) {
        return new DBUSPacket(Ti83PlusConstants.PC_CODE, DBUSCommand.XDP, byArray);
    }

    @Override
    public DBUSPacket getSetIOAddressPacket(byte[] byArray) {
        return new DBUSPacket(Ti83PlusConstants.PC_CODE, DBUSCommand.SIOA, byArray);
    }

    @Override
    public DBUSPacket getSendKeyPacket(byte by) {
        return new DBUSPacket(Ti83PlusConstants.PC_CODE, DBUSCommand.SKY, new byte[]{by, 0});
    }
}

