/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.ti83Plus;

import com.ti.eps.calc.dbus.DBUSCommand;
import com.ti.eps.calc.dbus.DBUSController;
import com.ti.eps.calc.dbus.DBUSDataType;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.DBUSPacketFactory;
import com.ti.eps.calc.dbus.DBUSPacketIOStream;
import com.ti.eps.calc.dbus.DeviceFile;
import com.ti.eps.calc.dbus.DeviceFileImpl;
import com.ti.eps.calc.dbus.FontString;
import com.ti.eps.calc.dbus.TokenString;
import com.ti.eps.calc.dbus.exceptions.InvalidDeviceFileException;
import com.ti.eps.calc.ti83Plus.Ti83PlusConstants;
import com.ti.eps.calc.ti83Plus.Ti83PlusDBUSController;
import com.ti.eps.calc.ti83Plus.Ti83PlusDBUSPacketFactory;
import com.ti.eps.calc.ti83Plus.Ti83PlusDeviceFile;
import com.ti.eps.calc.ti83Plus.Ti83PlusFontString;
import com.ti.eps.calc.ti83Plus.Ti83PlusTokenString;
import com.ti.eps.calc.z80.Z80DBUSDeviceHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class Ti83PlusDBUSDeviceHandler
extends Z80DBUSDeviceHandler {
    private Ti83PlusDBUSPacketFactory packetFactory = new Ti83PlusDBUSPacketFactory();
    private final int SpaceToken = 41;

    @Override
    public DBUSDeviceCode getDeviceCode() {
        return Ti83PlusConstants.UNIT_CODE;
    }

    @Override
    public DBUSPacketFactory getPacketFactory() {
        return this.packetFactory;
    }

    @Override
    protected boolean lengthIsPayload(DBUSCommand dBUSCommand) {
        return DBUSCommand.ACK.equals(dBUSCommand) || DBUSCommand.DONE.equals(dBUSCommand) || DBUSCommand.CHK.equals(dBUSCommand) || DBUSCommand.RDY.equals(dBUSCommand);
    }

    @Override
    public DBUSController getDBUSController(DBUSPacketIOStream dBUSPacketIOStream) {
        return new Ti83PlusDBUSController(dBUSPacketIOStream, this);
    }

    @Override
    public TokenString newTokenString(byte[] byArray) {
        return new Ti83PlusTokenString(byArray);
    }

    @Override
    public byte[] removeLeadingTrailingSpaceTokens(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        if (n2 < 2) {
            return byArray;
        }
        for (n = 0; n < n2 && byArray[n] == 41; ++n) {
        }
        if (n == n2 || n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2 - n];
        int n3 = n2 - n;
        for (int i = 0; i < n3; ++i) {
            byArray2[i] = byArray[n++];
        }
        return byArray2;
    }

    @Override
    public TokenString newTokenString(ByteBuffer byteBuffer) {
        return new Ti83PlusTokenString(byteBuffer);
    }

    @Override
    public FontString newFontString(byte[] byArray) {
        return new Ti83PlusFontString(byArray);
    }

    @Override
    public FontString newFontString(ByteBuffer byteBuffer) {
        return new Ti83PlusFontString(byteBuffer);
    }

    @Override
    public DeviceFile newDeviceFile(DBUSDataType dBUSDataType) {
        return new Ti83PlusDeviceFile(dBUSDataType);
    }

    @Override
    public DeviceFile parseDeviceFile(File file) throws IOException, InvalidDeviceFileException {
        return new Ti83PlusDeviceFile(file);
    }

    @Override
    public DeviceFile parseDeviceFile(InputStream inputStream) throws IOException, InvalidDeviceFileException {
        return new Ti83PlusDeviceFile(inputStream);
    }

    @Override
    public boolean isValidHeader(ByteBuffer byteBuffer) {
        return DeviceFileImpl.isValidHeader(byteBuffer, Ti83PlusDeviceFile.validHeader83P);
    }

    @Override
    public TokenString newTokenString(String string) {
        return new Ti83PlusTokenString(string);
    }

    @Override
    public FontString newFontString(String string) {
        return new Ti83PlusFontString(string);
    }
}

