/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.ti73;

import com.ti.eps.calc.dbus.DBUSCommand;
import com.ti.eps.calc.dbus.DBUSController;
import com.ti.eps.calc.dbus.DBUSDataType;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.DBUSPacketFactory;
import com.ti.eps.calc.dbus.DBUSPacketIOStream;
import com.ti.eps.calc.dbus.DeviceFile;
import com.ti.eps.calc.dbus.DeviceFileImpl;
import com.ti.eps.calc.dbus.FontString;
import com.ti.eps.calc.dbus.TokenString;
import com.ti.eps.calc.dbus.exceptions.InvalidDeviceFileException;
import com.ti.eps.calc.math.equation.EquationHandler;
import com.ti.eps.calc.ti73.Ti73Constants;
import com.ti.eps.calc.ti73.Ti73DBUSController;
import com.ti.eps.calc.ti73.Ti73DBUSPacketFactory;
import com.ti.eps.calc.ti73.Ti73DeviceFile;
import com.ti.eps.calc.ti73.Ti73LFontString;
import com.ti.eps.calc.ti73.Ti73TokenString;
import com.ti.eps.calc.ti73.math.equation.Equation;
import com.ti.eps.calc.z80.Z80DBUSDeviceHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class Ti73DBUSDeviceHandler
extends Z80DBUSDeviceHandler {
    private DBUSPacketFactory packetFactory = new Ti73DBUSPacketFactory();
    private final int SpaceToken = 41;
    private static final byte TVARLST = 93;

    @Override
    public DBUSDeviceCode getDeviceCode() {
        return Ti73Constants.UNIT_CODE;
    }

    @Override
    public DBUSPacketFactory getPacketFactory() {
        return this.packetFactory;
    }

    @Override
    protected boolean lengthIsPayload(DBUSCommand dBUSCommand) {
        return DBUSCommand.ACK.equals(dBUSCommand) || DBUSCommand.DONE.equals(dBUSCommand) || DBUSCommand.CHK.equals(dBUSCommand) || DBUSCommand.RDY.equals(dBUSCommand);
    }

    @Override
    public DBUSController getDBUSController(DBUSPacketIOStream dBUSPacketIOStream) {
        return new Ti73DBUSController(dBUSPacketIOStream, this);
    }

    @Override
    public TokenString newTokenString(DBUSDataType dBUSDataType, String string) {
        if (dBUSDataType.getName().equals("Real List")) {
            return this.newTokenString(Ti73DBUSDeviceHandler.tokenizeListName(string));
        }
        if (dBUSDataType.getName().equals("String")) {
            return this.newTokenString(string);
        }
        return super.newTokenString(dBUSDataType, string);
    }

    @Override
    public TokenString newTokenString(byte[] byArray) {
        return new Ti73TokenString(byArray);
    }

    @Override
    public TokenString newTokenString(ByteBuffer byteBuffer) {
        return new Ti73TokenString(byteBuffer);
    }

    @Override
    public byte[] removeLeadingTrailingSpaceTokens(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        if (n2 < 2) {
            return byArray;
        }
        for (n = 0; n < n2 && byArray[n] == 41; ++n) {
        }
        if (n == n2 || n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2 - n];
        int n3 = n2 - n;
        for (int i = 0; i < n3; ++i) {
            byArray2[i] = byArray[n++];
        }
        return byArray2;
    }

    @Override
    public TokenString newTokenString(String string) {
        return new Ti73TokenString(string);
    }

    @Override
    public FontString newFontString(byte[] byArray) {
        return new Ti73LFontString(byArray);
    }

    @Override
    public FontString newFontString(ByteBuffer byteBuffer) {
        return new Ti73LFontString(byteBuffer);
    }

    @Override
    public FontString newFontString(String string) {
        return new Ti73LFontString(string);
    }

    @Override
    public DeviceFile newDeviceFile(DBUSDataType dBUSDataType) {
        return new Ti73DeviceFile(dBUSDataType);
    }

    @Override
    public DeviceFile parseDeviceFile(File file) throws IOException, InvalidDeviceFileException {
        return new Ti73DeviceFile(file);
    }

    @Override
    public DeviceFile parseDeviceFile(InputStream inputStream) throws IOException, InvalidDeviceFileException {
        return new Ti73DeviceFile(inputStream);
    }

    @Override
    public boolean isValidHeader(ByteBuffer byteBuffer) {
        return DeviceFileImpl.isValidHeader(byteBuffer, Ti73DeviceFile.validHeader73);
    }

    @Override
    public EquationHandler newEquationHandler(InputStream inputStream) {
        return new Equation(inputStream);
    }

    private static byte[] tokenizeListName(String string) {
        Ti73DBUSDeviceHandler.validateListName(string);
        if (string.equals("")) {
            return new byte[]{0};
        }
        if (string.equals("L1") || string.equals("L_1_")) {
            return new byte[]{93, 1};
        }
        if (string.equals("L2") || string.equals("L_2_")) {
            return new byte[]{93, 2};
        }
        if (string.equals("L3") || string.equals("L_3_")) {
            return new byte[]{93, 3};
        }
        if (string.equals("L4") || string.equals("L_4_")) {
            return new byte[]{93, 4};
        }
        if (string.equals("L5") || string.equals("L_5_")) {
            return new byte[]{93, 5};
        }
        if (string.equals("L6") || string.equals("L_6_")) {
            return new byte[]{93, 6};
        }
        byte[] byArray = new byte[string.length() + 1];
        byArray[0] = 93;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) {
                byArray[i + 1] = (byte)((byte)string.charAt(i) - (byte)"0".charAt(0) + 48);
                continue;
            }
            if (Character.isLetter(string.charAt(i))) {
                byArray[i + 1] = (byte)((byte)string.toUpperCase().charAt(i) - (byte)"A".charAt(0) + 65);
                continue;
            }
            throw new RuntimeException("Unsupported character:" + Integer.toHexString(string.charAt(i)));
        }
        return byArray;
    }
}

