/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.math.equation;

import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.math.MathContext;
import com.ti.eps.calc.math.equation.FractionEquationIterator;
import com.ti.eps.calc.math.equation.UnsupportedTokenException;
import java.util.Map;

public abstract class EquationHandler {
    protected Boolean isContinuous;
    protected boolean parseError = false;
    protected char errorChar;
    protected int errorIndex;

    public char getErrorChar() {
        return this.errorChar;
    }

    public int getErrorIndex() {
        return this.errorIndex;
    }

    public boolean isValid() {
        return this.isEmpty() || !this.parseError;
    }

    public Boolean isContinuous() {
        return this.isContinuous;
    }

    public abstract boolean isEmpty();

    public abstract String getAsString();

    public abstract FractionEquationIterator fractionIterator();

    public String getAsFractionReducedString() {
        return this.getAsString();
    }

    public byte[] toBytes(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }

    public abstract Number evaluate(Map<String, Object> var1, MathContext var2);

    public abstract byte[] getAsNative(DBUSDeviceCode var1) throws IllegalArgumentException, UnsupportedTokenException;
}

