/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.java.math.equation;

import com.ti.eps.calc.java.math.equation.EquationParser;
import com.ti.eps.calc.java.math.equation.EquationParserVisitor;
import com.ti.eps.calc.java.math.equation.SimpleNode;
import com.ti.eps.calc.math.MathContext;
import com.ti.eps.calc.math.MathNumber;
import java.util.HashMap;
import java.util.Map;

public class ASTNumber
extends SimpleNode {
    private Map<MathContext, MathNumber> numberValMap = new HashMap<MathContext, MathNumber>(2);
    private String stringVal;
    private double val;

    public ASTNumber(int n) {
        super(n);
    }

    public ASTNumber(EquationParser equationParser, int n) {
        super(equationParser, n);
    }

    public double getVal() {
        return this.val;
    }

    public Number getValAsNumber(MathContext mathContext) {
        if (this.numberValMap.get(mathContext) == null) {
            this.numberValMap.put(mathContext, mathContext.getMathEngine().getNumberFromString(this.getValAsString()));
        }
        return this.numberValMap.get(mathContext);
    }

    public String getValAsString() {
        return this.stringVal;
    }

    public void setVal(String string) {
        if (string.startsWith("E")) {
            string = "1.0" + string;
        }
        this.stringVal = string;
        this.val = Double.parseDouble(this.stringVal);
    }

    @Override
    public Object jjtAccept(EquationParserVisitor equationParserVisitor, Object object) {
        return equationParserVisitor.visit(this, object);
    }

    @Override
    public String toString() {
        return "Number: " + this.stringVal;
    }
}

