/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.java.math;

import com.ti.eps.calc.java.math.DoubleMathNumber;
import com.ti.eps.calc.math.Fraction;
import com.ti.eps.calc.math.MathContext;
import com.ti.eps.calc.math.MathEngine;
import com.ti.eps.calc.math.MathNumber;

public class JavaMathEngine
extends MathEngine {
    private static final JavaMathEngine instance = new JavaMathEngine();

    public static MathEngine getInstance() {
        return instance;
    }

    @Override
    public MathNumber getNumberFromString(String string) {
        return new DoubleMathNumber(string);
    }

    @Override
    public Number finishEvaluation(Number number, MathContext mathContext) {
        return number;
    }

    @Override
    public Number add(Number number, Number number2, MathContext mathContext) {
        return new Double(number.doubleValue() + number2.doubleValue());
    }

    @Override
    public Number subtract(Number number, Number number2, MathContext mathContext) {
        return new Double(number.doubleValue() - number2.doubleValue());
    }

    @Override
    public Number mult(Number number, Number number2, MathContext mathContext) {
        return new Double(number.doubleValue() * number2.doubleValue());
    }

    @Override
    public Number divide(Number number, Number number2, MathContext mathContext) {
        if (mathContext.isInErrorTolerance(number2.doubleValue(), 0.0)) {
            return new Double(Double.NaN);
        }
        return new Double(number.doubleValue() / number2.doubleValue());
    }

    @Override
    public Number sin(Number number, MathContext mathContext) {
        return new Double(Math.sin(number.doubleValue()));
    }

    @Override
    public Number cos(Number number, MathContext mathContext) {
        return new Double(Math.cos(number.doubleValue()));
    }

    @Override
    public Number tan(Number number, MathContext mathContext) {
        double d = number.doubleValue();
        if (mathContext.isRemainderTolerance(d + 1.5707963267948966, Math.PI)) {
            return new Double(Double.NaN);
        }
        return new Double(Math.tan(d));
    }

    @Override
    public Number asin(Number number, MathContext mathContext) {
        return new Double(Math.asin(number.doubleValue()));
    }

    @Override
    public Number acos(Number number, MathContext mathContext) {
        return new Double(Math.acos(number.doubleValue()));
    }

    @Override
    public Number atan(Number number, MathContext mathContext) {
        return new Double(Math.atan(number.doubleValue()));
    }

    @Override
    public Number sinh(Number number, MathContext mathContext) {
        return new Double(this.sinh(number.doubleValue()));
    }

    @Override
    public Number cosh(Number number, MathContext mathContext) {
        return new Double(this.cosh(number.doubleValue()));
    }

    @Override
    public Number tanh(Number number, MathContext mathContext) {
        return new Double(this.tanh(number.doubleValue()));
    }

    @Override
    public Number asinh(Number number, MathContext mathContext) {
        return new Double(this.asinh(number.doubleValue()));
    }

    @Override
    public Number acosh(Number number, MathContext mathContext) {
        return new Double(this.acosh(number.doubleValue()));
    }

    @Override
    public Number atanh(Number number, MathContext mathContext) {
        if (mathContext.isInErrorTolerance(number.doubleValue(), -1.0)) {
            return new Double(Double.NaN);
        }
        if (mathContext.isInErrorTolerance(number.doubleValue(), 1.0)) {
            return new Double(Double.NaN);
        }
        return new Double(this.atanh(number.doubleValue()));
    }

    @Override
    public Number sqrt(Number number, MathContext mathContext) {
        return new Double(Math.sqrt(number.doubleValue()));
    }

    @Override
    public Number floor(Number number, MathContext mathContext) {
        return new Double(Math.floor(number.doubleValue()));
    }

    @Override
    public Number naturalLog(Number number, MathContext mathContext) {
        if (mathContext.isInErrorTolerance(number.doubleValue(), 0.0)) {
            return new Double(Math.log(0.0));
        }
        return new Double(Math.log(number.doubleValue()));
    }

    @Override
    public Number exp(Number number, MathContext mathContext) {
        return new Double(Math.exp(number.doubleValue()));
    }

    @Override
    public Number log(Number number, MathContext mathContext) {
        if (mathContext.isInErrorTolerance(number.doubleValue(), 0.0)) {
            return new Double(Math.log(0.0) / Math.log(10.0));
        }
        return new Double(Math.log(number.doubleValue()) / Math.log(10.0));
    }

    @Override
    public Number abs(Number number, MathContext mathContext) {
        return new Double(Math.abs(number.doubleValue()));
    }

    @Override
    public Number power(Number number, Number number2, MathContext mathContext) {
        try {
            boolean bl;
            Fraction fraction = Fraction.createFraction(number2.doubleValue());
            boolean bl2 = Math.abs(fraction.getNumerator()) % 2L == 1L;
            boolean bl3 = Math.abs(fraction.getDenominator()) % 2L == 1L;
            boolean bl4 = bl = fraction.getDenominator() != 1L;
            if (number.doubleValue() < 0.0 && bl3 && bl) {
                int n = bl2 ? -1 : 1;
                return new Double((double)n * Math.pow(-1.0 * number.doubleValue(), number2.doubleValue()));
            }
            if (number.doubleValue() == 0.0 && number2.doubleValue() == 0.0) {
                return new Double(Double.NaN);
            }
            return new Double(Math.pow(number.doubleValue(), number2.doubleValue()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new Double(Double.NaN);
        }
    }

    @Override
    public Number negative(Number number, MathContext mathContext) {
        return new Double(-number.doubleValue());
    }

    @Override
    public Number pi(MathContext mathContext) {
        return new Double(Math.PI);
    }

    @Override
    public Number e(MathContext mathContext) {
        return new Double(Math.E);
    }

    @Override
    public Number tenToX(Number number, MathContext mathContext) {
        return this.power(new Double(10.0), number, mathContext);
    }

    @Override
    public Number inverse(Number number, MathContext mathContext) {
        return this.power(number, new Double(-1.0), mathContext);
    }

    @Override
    public Number square(Number number, MathContext mathContext) {
        return this.power(number, new Double(2.0), mathContext);
    }

    private double sinh(double d) {
        return 0.5 * (Math.exp(d) - Math.exp(-d));
    }

    private double cosh(double d) {
        return 0.5 * (Math.exp(d) + Math.exp(-d));
    }

    private double tanh(double d) {
        if (Math.abs(d) >= 13.0) {
            return 1 * (d < 0.0 ? -1 : 1);
        }
        return this.sinh(d) / this.cosh(d);
    }

    private double asinh(double d) {
        return Math.log(d + Math.sqrt(d * d + 1.0));
    }

    private double acosh(double d) {
        return Math.log(d + Math.sqrt(d * d - 1.0));
    }

    private double atanh(double d) {
        return 0.5 * (Math.log(1.0 + d) - Math.log(1.0 - d));
    }
}

