/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.dbus;

import com.ti.eps.calc.dbus.DeviceString;
import java.nio.ByteBuffer;

public abstract class TokenString
implements DeviceString {
    protected ByteBuffer tokenBuffer;

    public TokenString(byte[] byArray) {
        this.tokenBuffer = ByteBuffer.wrap(byArray);
        this.trim();
    }

    public TokenString(ByteBuffer byteBuffer) {
        this.tokenBuffer = byteBuffer.duplicate();
        this.trim();
    }

    public TokenString(String string) {
        byte[] byArray = this.getTokens(string);
        this.tokenBuffer = ByteBuffer.wrap(byArray);
    }

    private void trim() {
        ByteBuffer byteBuffer = this.tokenBuffer.duplicate();
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            if (by != 0) continue;
            this.tokenBuffer.limit(byteBuffer.position());
            break;
        }
    }

    protected abstract byte[] getTokens(String var1);

    public abstract int length();

    public byte[] toTokens() {
        byte[] byArray = new byte[this.tokenBuffer.remaining()];
        this.tokenBuffer.duplicate().get(byArray);
        return byArray;
    }

    @Override
    public abstract String toString();

    @Override
    public byte[] toBytes() {
        return this.toTokens();
    }

    protected static final int getNumTokens(ByteBuffer byteBuffer, int[] nArray) {
        byteBuffer = byteBuffer.duplicate();
        int n = 0;
        while (byteBuffer.hasRemaining()) {
            int n2 = byteBuffer.get() & 0xFF;
            ++n;
            int n3 = nArray[n2];
            if (n3 >= 0) continue;
            if (!byteBuffer.hasRemaining()) {
                throw new ArrayIndexOutOfBoundsException("Invalid token byte size");
            }
            byteBuffer.get();
            ++n;
        }
        return n;
    }

    protected static final String toString(ByteBuffer byteBuffer, int[] nArray, int[][] nArray2, String[] stringArray) {
        byteBuffer = byteBuffer.duplicate();
        StringBuffer stringBuffer = new StringBuffer(byteBuffer.remaining() * 3);
        int n = stringArray.length;
        while (byteBuffer.hasRemaining()) {
            int n2 = byteBuffer.get() & 0xFF;
            int n3 = nArray[n2];
            if (n3 < 0) {
                if (!byteBuffer.hasRemaining()) {
                    throw new ArrayIndexOutOfBoundsException("Invalid token byte size");
                }
                int n4 = byteBuffer.get() & 0xFF;
                try {
                    n3 = nArray2[-n3][n4];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    n3 = 0;
                    break;
                }
            }
            if (n3 >= n) {
                n3 = 0;
            }
            stringBuffer.append(stringArray[n3] != null ? stringArray[n3] : stringArray[0]);
        }
        return stringBuffer.toString();
    }
}

