/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.dbus;

import java.nio.ByteBuffer;

public class FlashFileSlot {
    private ByteBuffer slotData = ByteBuffer.allocate(16384);
    private boolean completed = false;
    private final byte slotNum;
    private int startAddress = -1;

    public FlashFileSlot(byte by) {
        this.slotNum = by;
    }

    public void append(byte by) {
        if (this.startAddress < 0) {
            throw new IllegalStateException("You must set a start address before appending data");
        }
        if (this.completed) {
            throw new IllegalStateException("Cannot add data to a completed slot");
        }
        this.slotData.put(by);
    }

    public void append(byte[] byArray) {
        if (this.startAddress < 0) {
            throw new IllegalStateException("You must set a start address before appending data");
        }
        if (this.completed) {
            throw new IllegalStateException("Cannot add data to a completed slot");
        }
        this.slotData.put(byArray);
    }

    public void complete() {
        this.slotData.flip();
        this.completed = true;
    }

    public byte getSlotNum() {
        return this.slotNum;
    }

    public int getStartAddress() {
        return this.startAddress;
    }

    public void setStartAddress(int n) {
        if (this.completed) {
            throw new IllegalStateException("Start address cannot be set on a completed slot");
        }
        if (this.startAddress >= 0) {
            throw new IllegalStateException("Cannot set start address more than once");
        }
        this.startAddress = n;
    }

    public ByteBuffer getData() {
        return this.slotData.asReadOnlyBuffer();
    }
}

