/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.dbus;

import com.ti.eps.calc.dbus.BatteryInformation;
import com.ti.eps.calc.dbus.BatteryState;
import com.ti.eps.calc.dbus.DBUSCommand;
import com.ti.eps.calc.dbus.DBUSPacket;
import com.ti.eps.calc.dbus.DeviceInformation;
import com.ti.eps.calc.dbus.DeviceMessageImpl;
import com.ti.eps.calc.dbus.HardwareRevision;
import java.nio.ByteOrder;

public abstract class DeviceInformationImpl
extends DeviceMessageImpl
implements DeviceInformation,
BatteryInformation {
    private static final int BASECODE_REV_POS = 0;
    private static final int BOOTCODE_REV_POS = 2;
    private static final int BATTERY_STATE_POS = 4;
    private static final int HW_REV_POS = 5;
    private static final int LANG_PRI_POS = 6;
    private static final int LANG_SUB_POS = 7;

    protected DeviceInformationImpl(DBUSPacket dBUSPacket, ByteOrder byteOrder) {
        super(dBUSPacket, byteOrder);
        if (!DBUSCommand.XDP.equals(this.packet.getCommand())) {
            throw new IllegalArgumentException("Packet must be a XDP packet");
        }
        if (this.dataBlock.limit() < 8) {
            throw new IllegalArgumentException("Packet is not big enough to be a RDI response XDP packet");
        }
    }

    @Override
    public int getBaseCodeRevision() {
        return this.dataBlock.getShort(0) & 0xFFFF;
    }

    @Override
    public int getBootCodeRevision() {
        return this.dataBlock.getShort(2) & 0xFFFF;
    }

    @Override
    public BatteryState getBatteryState() {
        byte by = this.dataBlock.get(4);
        return (by & 1) == 1 ? BatteryState.BATTERY_LOW : BatteryState.BATTERY_UNKNOWN;
    }

    @Override
    public abstract HardwareRevision getHardwareRevision();

    protected byte getHardwareRevisionCode() {
        return this.dataBlock.get(5);
    }

    @Override
    public int getLanguageCode() {
        return this.dataBlock.get(6);
    }

    @Override
    public int getLanguageSubCode() {
        return this.dataBlock.get(7);
    }
}

