/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.dbus;

import com.ti.eps.calc.dbus.DBUSCommand;
import com.ti.eps.calc.dbus.DBUSDeviceCode;

public class DBUSPacket {
    public static final DBUSPacket RDC_PACKET = new DBUSPacket(DBUSDeviceCode.NONE, DBUSCommand.RDC, null);
    private static final StringBuffer TO_STRING_BUFFER = new StringBuffer();
    protected DBUSDeviceCode devcode;
    protected DBUSCommand cmd;
    protected byte[] payload;
    private byte[] buffer;

    public DBUSPacket(DBUSDeviceCode dBUSDeviceCode, DBUSCommand dBUSCommand, byte[] byArray) {
        this.devcode = dBUSDeviceCode;
        this.cmd = dBUSCommand;
        this.payload = byArray;
    }

    public synchronized String toString() {
        TO_STRING_BUFFER.setLength(0);
        TO_STRING_BUFFER.append("{ ");
        TO_STRING_BUFFER.append("[DeviceCode: " + this.devcode + "] ");
        TO_STRING_BUFFER.append("[Command: " + this.cmd + "] ");
        if (this.payload != null) {
            TO_STRING_BUFFER.append("[Payload: ");
            for (int i = 0; i < this.payload.length; ++i) {
                String string = Integer.toHexString(this.payload[i] & 0xFF);
                if (string.length() < 2) {
                    TO_STRING_BUFFER.append("0x0");
                } else {
                    TO_STRING_BUFFER.append("0x");
                }
                TO_STRING_BUFFER.append(string);
                TO_STRING_BUFFER.append(" ");
            }
            TO_STRING_BUFFER.append("]");
        }
        TO_STRING_BUFFER.append(" }");
        return TO_STRING_BUFFER.toString();
    }

    public DBUSDeviceCode getDeviceCode() {
        return this.devcode;
    }

    public DBUSCommand getCommand() {
        return this.cmd;
    }

    public byte[] getPayload() {
        return (byte[])this.payload.clone();
    }

    public int getLength() {
        return this.payload != null ? this.payload.length : 0;
    }

    public void setDeviceCode(DBUSDeviceCode dBUSDeviceCode) {
        this.devcode = dBUSDeviceCode;
    }

    public void setCommand(DBUSCommand dBUSCommand) {
        this.cmd = dBUSCommand;
    }

    public void setPayload(byte[] byArray) {
        this.payload = byArray;
    }

    public int getChecksum() {
        return this.payload != null ? DBUSPacket.calcChecksum(this.payload, 0, this.payload.length) : 0;
    }

    public byte[] toBuffer() {
        int n = this.getChecksum();
        int n2 = 4 + (this.payload == null || this.lengthIsPayload() ? 0 : this.payload.length + 2);
        if (this.buffer == null || this.buffer.length != n2) {
            this.buffer = new byte[n2];
        }
        this.buffer[0] = this.devcode.getValue();
        this.buffer[1] = this.cmd.getValue();
        if (this.payload == null) {
            this.buffer[3] = 0;
            this.buffer[2] = 0;
        } else if (this.lengthIsPayload() && this.payload.length == 2) {
            this.buffer[2] = this.payload[0];
            this.buffer[3] = this.payload[1];
        } else {
            this.buffer[2] = (byte)(this.payload.length & 0xFF);
            this.buffer[3] = (byte)(this.payload.length >> 8 & 0xFF);
            System.arraycopy(this.payload, 0, this.buffer, 4, this.payload.length);
            this.buffer[4 + this.payload.length] = (byte)(n & 0xFF);
            this.buffer[4 + this.payload.length + 1] = (byte)(n >> 8 & 0xFF);
        }
        return this.buffer;
    }

    public static DBUSPacket fromBuffer(byte[] byArray) {
        if (byArray.length < 4) {
            throw new IllegalArgumentException("Buffer is too short to contain a DBUS packet");
        }
        DBUSDeviceCode dBUSDeviceCode = DBUSDeviceCode.find(byArray[0]);
        DBUSCommand dBUSCommand = DBUSCommand.find(byArray[1]);
        if (dBUSDeviceCode == null) {
            throw new IllegalArgumentException("Not a valid DBUS device code.");
        }
        if (dBUSCommand == null) {
            throw new IllegalArgumentException("Not a valid DBUS command.");
        }
        int n = (byArray[3] & 0xFF) << 8 | byArray[2] & 0xFF;
        if (n == 0) {
            return new DBUSPacket(dBUSDeviceCode, dBUSCommand, null);
        }
        if (byArray.length < n + 6) {
            throw new IllegalArgumentException("Buffer is too short to contain a DBUS packet with the specified payload length");
        }
        int n2 = (byArray[5 + n] & 0xFF) << 8 | byArray[4 + n] & 0xFF;
        if (DBUSPacket.calcChecksum(byArray, 4, n) != n2) {
            throw new IllegalArgumentException("Invalid DBUS payload checksum");
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 4, byArray2, 0, n);
        DBUSPacket dBUSPacket = new DBUSPacket(dBUSDeviceCode, dBUSCommand, byArray2);
        return dBUSPacket;
    }

    public static int calcChecksum(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 += byArray[n + i] & 0xFF;
        }
        return n3 & 0xFFFF;
    }

    private boolean lengthIsPayload() {
        return DBUSCommand.SKY.equals(this.cmd) || DBUSCommand.ACK.equals(this.cmd);
    }
}

