/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.dbus;

import com.ti.eps.calc.dbus.DBUSCommand;
import com.ti.eps.calc.dbus.DBUSDataType;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.DBUSDeviceHandler;
import com.ti.eps.calc.dbus.DBUSPacket;
import com.ti.eps.calc.math.MathContext;
import com.ti.eps.calc.math.MathConverter;
import com.ti.eps.calc.math.MathNumber;
import com.ti.eps.calc.math.equation.EquationHandler;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DBUSDeviceHandlerImpl
implements DBUSDeviceHandler {
    private static final Logger LOGGER = Logger.getLogger("DBUSDeviceHandlerImpl");
    private static final int DEVICE_CODE_POS = 0;
    private static final int COMMAND_POS = 1;
    private static final int PAYLOAD_LENGTH_POS = 2;
    private static final int PAYLOAD_LENGTH_LENGTH = 2;
    private static final int HEADER_LENGTH = 4;
    private static final int CHECKSUM_LENGTH = 2;

    @Override
    public DBUSPacket parsePacket(ByteBuffer byteBuffer) {
        int n;
        byte[] byArray;
        DBUSCommand dBUSCommand;
        DBUSDeviceCode dBUSDeviceCode;
        byteBuffer.order(this.byteOrder());
        while (true) {
            int n2;
            int n3;
            int n4;
            LOGGER.finest("Top of parsePacket loop");
            if (byteBuffer.remaining() < 4) {
                return null;
            }
            dBUSDeviceCode = this.getDeviceCode();
            byte by = byteBuffer.get(byteBuffer.position() + 0);
            if (by == 0) {
                dBUSDeviceCode = DBUSDeviceCode.NONE;
            } else if (by != dBUSDeviceCode.getValue()) {
                LOGGER.log(Level.INFO, "Incorrect unit code -- flushing 1 byte");
                byteBuffer.get();
                continue;
            }
            byte by2 = byteBuffer.get(byteBuffer.position() + 1);
            dBUSCommand = this.parseCommand(by2);
            if (dBUSCommand == null) {
                LOGGER.log(Level.INFO, "Invalid command 0x" + Integer.toHexString(by2) + " -- flushing 1 byte");
                byteBuffer.get();
                continue;
            }
            byArray = null;
            if (this.lengthIsPayload(dBUSCommand)) {
                LOGGER.finest("length is payload");
                n4 = 2;
                n = 4;
                byArray = new byte[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    byArray[n3] = byteBuffer.get(byteBuffer.position() + 2 + n3);
                }
                break;
            }
            LOGGER.finest("Looking for packet payload");
            n4 = byteBuffer.getShort(byteBuffer.position() + 2) & 0xFFFF;
            n = 4 + n4 + 2;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("payloadLength=" + n4 + " totalPacketLength=" + n);
            }
            if (n4 <= 0) break;
            if (byteBuffer.remaining() < n) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Buffered data has incomplete packet -- deferring, packetData.remaining()=" + byteBuffer.remaining() + " is less than totalPacketLength=" + n);
                }
                return null;
            }
            n3 = 4 + n4;
            int n5 = byteBuffer.getShort(byteBuffer.position() + n3) & 0xFFFF;
            byArray = new byte[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                byArray[n2] = byteBuffer.get(byteBuffer.position() + 4 + n2);
            }
            n2 = DBUSPacket.calcChecksum(byArray, 0, n4);
            if (n2 == n5) break;
            LOGGER.log(Level.INFO, "DBUSPacket has bad checksum -- flushing byte, expected checksum was " + Integer.toHexString(n2));
            byteBuffer.get();
        }
        DBUSPacket dBUSPacket = new DBUSPacket(dBUSDeviceCode, dBUSCommand, byArray);
        byteBuffer.position(byteBuffer.position() + n);
        return dBUSPacket;
    }

    protected DBUSCommand parseCommand(byte by) {
        return DBUSCommand.find(by);
    }

    protected boolean lengthIsPayload(DBUSCommand dBUSCommand) {
        return false;
    }

    protected ByteOrder byteOrder() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    public DBUSDataType findDataType(String string) {
        return DBUSDataType.find(this.getDeviceCode(), string);
    }

    @Override
    public EquationHandler newEquationHandler(InputStream inputStream) {
        return null;
    }

    @Override
    public EquationHandler newEquationHandler(Reader reader) {
        return null;
    }

    @Override
    public MathNumber newMathNumber(double d) {
        return null;
    }

    @Override
    public MathNumber newMathNumber(String string) {
        return null;
    }

    @Override
    public MathContext getMathContext() {
        return null;
    }

    @Override
    public MathConverter getMathConverter() {
        return null;
    }
}

