/*
 * Decompiled with CFR 0.152.
 */
package com.ti.et.smartview.jsemulator.virtuastream.impl;

import com.ti.et.smartview.jsemulator.virtuastream.VirtualStreamInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCPClientVirtualStream
implements VirtualStreamInterface {
    private Socket a = null;
    private boolean b = false;
    private InputStream c = null;
    private OutputStream d = null;
    private Logger e = Logger.getLogger(TCPClientVirtualStream.class.getSimpleName());

    public String toHexString(byte[] ba, int length) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            stringBuilder.append(String.format("%02x", ba[i]));
        }
        return stringBuilder.toString();
    }

    @Override
    public int openIOStream() {
        this.connectToTCPServer();
        return 1;
    }

    @Override
    public String readIOStream() {
        if (this.getNumberOfBytesAvailableFromTCPServer() > 0) {
            return this.readBytesFromTCPServer();
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeIOStream(String outBuffer) {
        void var1_1;
        this.writeBytesToTCPServer((String)var1_1);
    }

    @Override
    public void closeIOStream() {
        this.disconnectFromTCPServer();
    }

    public byte[] fromHexString(String hex) {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = null;
        for (int i = 0; i < hex.length(); i += 2) {
            int n = i;
            stringBuilder.append((char)Integer.parseInt(hex.substring(n, n + 2), 16));
        }
        try {
            byArray = stringBuilder.toString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.e.log(Level.SEVERE, unsupportedEncodingException.getMessage());
        }
        return byArray;
    }

    public void connectToTCPServer() {
        try {
            this.a = new Socket("localhost", 6789);
            this.c = this.a.getInputStream();
            this.d = this.a.getOutputStream();
            this.b = true;
            this.e.log(Level.INFO, "Connected to TCPServer.");
            return;
        }
        catch (IOException iOException) {
            this.e.log(Level.SEVERE, iOException.getMessage());
            return;
        }
    }

    public String readBytesFromTCPServer() {
        String string = "";
        byte[] byArray = new byte[1024];
        if (!this.b) {
            this.e.log(Level.INFO, "Connecting in readBytesFromTCPServer!");
            this.connectToTCPServer();
        }
        try {
            int n = this.c.read(byArray, 0, 1024);
            string = this.toHexString(byArray, n);
        }
        catch (IOException iOException) {
            this.e.log(Level.SEVERE, iOException.getMessage());
        }
        return string;
    }

    public int getNumberOfBytesAvailableFromTCPServer() {
        int n = 0;
        if (!this.b) {
            this.e.log(Level.INFO, "Connecting in getNumberOfBytesAvailableFromTCPServer!");
            this.connectToTCPServer();
        }
        try {
            n = this.c.available();
        }
        catch (IOException iOException) {
            this.e.log(Level.SEVERE, iOException.getMessage());
        }
        return n;
    }

    public void writeBytesToTCPServer(String outBuffer) {
        if (!this.b) {
            this.e.log(Level.INFO, "Connecting in writeBytesToTCPServer!");
            this.connectToTCPServer();
        }
        if (this.b) {
            byte[] byArray;
            if ((byArray = this.fromHexString((String)byArray)) != null) {
                try {
                    this.d.write(byArray);
                    return;
                }
                catch (IOException iOException) {
                    this.e.log(Level.SEVERE, iOException.getMessage());
                    return;
                }
            }
            this.e.log(Level.INFO, "Conversion from Hex string to byte array failed!");
        }
    }

    public void disconnectFromTCPServer() {
        if (this.b) {
            try {
                this.a.close();
                this.e.log(Level.INFO, "Disconnected from the TCPServer");
            }
            catch (IOException iOException) {
                this.e.log(Level.SEVERE, iOException.getMessage());
            }
            this.b = false;
        }
    }

    @Override
    public InputStream getDataIn() {
        return this.c;
    }

    @Override
    public OutputStream getDataOut() {
        return this.d;
    }

    @Override
    public void setDataIn(OutputStream os) {
    }
}

