/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.z80.math.equation;

import com.ti.eps.calc.TiCalc;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.math.MathContext;
import com.ti.eps.calc.math.MathNumber;
import com.ti.eps.calc.z80.math.equation.EquationParser;
import com.ti.eps.calc.z80.math.equation.EquationParserVisitor;
import com.ti.eps.calc.z80.math.equation.SimpleNode;
import com.ti.eps.calc.z80.math.equation.TokenMgrError;
import java.util.HashMap;
import java.util.Map;

public class ASTNumber
extends SimpleNode {
    private Map<MathContext, MathNumber> numberValMap = new HashMap<MathContext, MathNumber>(2);
    private String stringVal;
    private String decimalStringVal;
    private double val;
    private boolean isFraction = false;

    public ASTNumber(int n) {
        super(n);
    }

    public ASTNumber(EquationParser equationParser, int n) {
        super(equationParser, n);
    }

    public double getVal() {
        return this.val;
    }

    public Number getValAsNumber(MathContext mathContext) {
        if (this.numberValMap.get(mathContext) == null) {
            this.numberValMap.put(mathContext, mathContext.getMathEngine().getNumberFromString(this.getValAsString()));
        }
        return this.numberValMap.get(mathContext);
    }

    public String getValAsString() {
        if (this.isFraction) {
            if (this.decimalStringVal == null) {
                this.decimalStringVal = TiCalc.newMathNumber(DBUSDeviceCode.UNIT_83PLUS, this.val).toString();
            }
            return this.decimalStringVal;
        }
        return this.stringVal;
    }

    private void setFraction(boolean bl) {
        this.isFraction = bl;
    }

    boolean isFraction() {
        return this.isFraction;
    }

    public void setVal(String string) {
        this.setFraction(string.indexOf(240) > 0);
        string = string.replace(':', '.');
        string = string.replace(';', 'E');
        string = string.replace('p', '+');
        string = string.replace('\u00b0', '-');
        string = string.replace('\u00ef', ' ');
        string = string.replace('\u00f0', '/');
        if (string.startsWith("E")) {
            string = "1.0" + string;
        }
        this.stringVal = string;
        this.val = TiCalc.newMathNumber(DBUSDeviceCode.UNIT_83PLUS, string).doubleValue();
        if (Double.isNaN(this.val)) {
            throw new TokenMgrError("Invalid number [" + this.stringVal + "]", 0);
        }
    }

    @Override
    public Object jjtAccept(EquationParserVisitor equationParserVisitor, Object object) {
        return equationParserVisitor.visit(this, object);
    }

    @Override
    public String toString() {
        return "Number: " + this.stringVal;
    }
}

