/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.z80;

import com.ti.eps.calc.dbus.TokenString;
import com.ti.eps.calc.util.IntHashMap;
import com.ti.eps.calc.z80.STok;
import com.ti.eps.calc.z80.Z80TokenizeMap;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

public abstract class Z80TokenString
extends TokenString {
    public Z80TokenString(byte[] byArray) {
        super(byArray);
    }

    public Z80TokenString(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    public Z80TokenString(String string) {
        super(string);
    }

    protected static byte[] stringToTokens(String string, int n, int[] nArray, int n2) {
        int n3 = string.length();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3 - n);
        IntHashMap intHashMap = Z80TokenizeMap.map;
        block0: for (int i = n; i < n3; ++i) {
            char c = string.charAt(i);
            STok[] sTokArray = (STok[])intHashMap.get(c);
            if (sTokArray != null) {
                for (int j = 0; j < sTokArray.length; ++j) {
                    if (!string.startsWith(sTokArray[j].str, i)) continue;
                    int n4 = nArray[sTokArray[j].stoken];
                    n4 = n4 == 0 ? n2 : n4;
                    Z80TokenString.writeToken(n4, byteArrayOutputStream);
                    i += sTokArray[j].str.length() - 1;
                    continue block0;
                }
            }
            Z80TokenString.writeToken(n2, byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    private static void writeToken(int n, ByteArrayOutputStream byteArrayOutputStream) {
        if ((n & 0xFF00) != 0) {
            byteArrayOutputStream.write((byte)(n >> 8 & 0xFF));
        }
        byteArrayOutputStream.write((byte)(n & 0xFF));
    }
}

