/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.z80;

import com.ti.eps.calc.dbus.DBUSCommand;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.DBUSPacket;
import com.ti.eps.calc.dbus.DBUSPacketRTS;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class Z80DBUSPacketRTS
extends DBUSPacketRTS {
    private static final int POS_SECTOR_SIZE = 0;
    private static final int POS_DATA_TYPE = 2;
    private static final int POS_BLOCK_FLAG = 5;
    private static final int POS_PAGE_OFFSET = 6;
    private static final int POS_PAGE_NUM = 8;
    private final ByteBuffer buffer;

    public Z80DBUSPacketRTS(ByteOrder byteOrder, DBUSDeviceCode dBUSDeviceCode) {
        super(dBUSDeviceCode, DBUSCommand.RTS, new byte[10]);
        Arrays.fill(this.payload, (byte)0);
        this.buffer = ByteBuffer.wrap(this.payload);
        this.buffer.order(byteOrder);
    }

    public Z80DBUSPacketRTS(ByteOrder byteOrder, DBUSDeviceCode dBUSDeviceCode, byte by, short s, byte by2, short s2, byte by3) {
        this(byteOrder, dBUSDeviceCode);
        this.setSectorSize(s);
        this.setDataType(by);
        this.setBlockFlag(by3);
        this.setPageOffset(s2);
        this.setPageNum(by2);
    }

    public Z80DBUSPacketRTS(ByteOrder byteOrder, DBUSPacket dBUSPacket) {
        super(dBUSPacket.getDeviceCode(), dBUSPacket.getCommand(), dBUSPacket.getPayload());
        this.buffer = ByteBuffer.wrap(this.payload);
        this.buffer.order(byteOrder);
    }

    @Override
    public void setDataType(byte by) {
        this.buffer.put(2, by);
    }

    public byte getDataType() {
        return this.buffer.get(2);
    }

    @Override
    public void setSectorSize(short s) {
        this.buffer.putShort(0, s);
    }

    public short getSectorSize() {
        return this.buffer.getShort(0);
    }

    @Override
    public void setPageNum(byte by) {
        if (by < 0 || by > 32) {
            throw new IllegalArgumentException("page out of range " + by);
        }
        this.buffer.putShort(8, by);
    }

    public byte getPageNum() {
        return (byte)(this.buffer.getShort(8) & 0xFF);
    }

    @Override
    public void setPageOffset(short s) {
        this.buffer.putShort(6, s);
    }

    public short getPageOffset() {
        return this.buffer.getShort(6);
    }

    @Override
    public void setBlockFlag(byte by) {
        this.buffer.put(5, by);
    }

    public byte getBlockFlag() {
        return this.buffer.get(5);
    }
}

