/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.z80;

import com.ti.eps.calc.dbus.DBUSDataType;
import com.ti.eps.calc.dbus.DBUSDeviceHandlerImpl;
import com.ti.eps.calc.dbus.TokenString;
import com.ti.eps.calc.math.MathContext;
import com.ti.eps.calc.math.MathConverter;
import com.ti.eps.calc.math.MathNumber;
import com.ti.eps.calc.math.equation.EquationHandler;
import com.ti.eps.calc.z80.math.Z80MathContext;
import com.ti.eps.calc.z80.math.Z80MathConverter;
import com.ti.eps.calc.z80.math.Z80Number;
import com.ti.eps.calc.z80.math.equation.Equation;
import java.io.InputStream;
import java.util.regex.Pattern;

public abstract class Z80DBUSDeviceHandler
extends DBUSDeviceHandlerImpl {
    private static final int MAX_LIST_NAME_LENGTH = 5;
    private static final byte TVARLST = 93;
    static Pattern LIST_NAME_PATTERN = Pattern.compile("[(\\p{Alpha}]+[(\\p{Alnum}]*");

    @Override
    public TokenString newTokenString(DBUSDataType dBUSDataType, String string) {
        if (dBUSDataType.getName().equals("Real List")) {
            return this.newTokenString(Z80DBUSDeviceHandler.tokenizeListName(string));
        }
        if (dBUSDataType.getName().equals("Application Variable")) {
            return this.newTokenString(Z80DBUSDeviceHandler.tokenizeAppVarName(string));
        }
        throw new RuntimeException("Unimplemented datatype:" + dBUSDataType.toString());
    }

    @Override
    public EquationHandler newEquationHandler(InputStream inputStream) {
        return new Equation(inputStream);
    }

    @Override
    public MathNumber newMathNumber(double d) {
        return new Z80Number(d);
    }

    @Override
    public MathNumber newMathNumber(String string) {
        return new Z80Number(string);
    }

    @Override
    public MathContext getMathContext() {
        return Z80MathContext.getInstance();
    }

    @Override
    public MathConverter getMathConverter() {
        return Z80MathConverter.getInstance();
    }

    protected static void validateListName(String string) {
        if (string.length() > 5) {
            throw new RuntimeException("Maximum length of list name is 5");
        }
        if (!LIST_NAME_PATTERN.matcher(string).matches()) {
            throw new RuntimeException("Invalid List Name " + string);
        }
    }

    private static byte[] tokenizeListName(String string) {
        Z80DBUSDeviceHandler.validateListName(string);
        if (string.equals("")) {
            return new byte[]{0};
        }
        if (string.equals("L1") || string.equals("L_1_")) {
            return new byte[]{93, 0};
        }
        if (string.equals("L2") || string.equals("L_2_")) {
            return new byte[]{93, 1};
        }
        if (string.equals("L3") || string.equals("L_3_")) {
            return new byte[]{93, 2};
        }
        if (string.equals("L4") || string.equals("L_4_")) {
            return new byte[]{93, 3};
        }
        if (string.equals("L5") || string.equals("L_5_")) {
            return new byte[]{93, 4};
        }
        if (string.equals("L6") || string.equals("L_6_")) {
            return new byte[]{93, 5};
        }
        byte[] byArray = new byte[string.length() + 1];
        byArray[0] = 93;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) {
                byArray[i + 1] = (byte)((byte)string.charAt(i) - (byte)"0".charAt(0) + 48);
                continue;
            }
            if (Character.isLetter(string.charAt(i))) {
                byArray[i + 1] = (byte)((byte)string.toUpperCase().charAt(i) - (byte)"A".charAt(0) + 65);
                continue;
            }
            throw new RuntimeException("Unsupported character:" + Integer.toHexString(string.charAt(i)));
        }
        return byArray;
    }

    public static byte[] tokenizeAppVarName(String string) {
        string = string.trim();
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) {
                byArray[i] = (byte)((byte)string.charAt(i) - (byte)"0".charAt(0) + 48);
                continue;
            }
            if (Character.isUpperCase(string.charAt(i))) {
                byArray[i] = (byte)((byte)string.charAt(i) - (byte)"A".charAt(0) + 65);
                continue;
            }
            if (Character.isLowerCase(string.charAt(i))) {
                byArray[i] = (byte)((byte)string.charAt(i) - (byte)"a".charAt(0) + 97);
                continue;
            }
            if (" ".equals(string.substring(i, i + 1))) {
                byArray[i] = 41;
                continue;
            }
            if ("(".equals(string.substring(i, i + 1))) {
                byArray[i] = 16;
                continue;
            }
            if (")".equals(string.substring(i, i + 1))) {
                byArray[i] = 17;
                continue;
            }
            if ("{".equals(string.substring(i, i + 1))) {
                byArray[i] = 123;
                continue;
            }
            if ("}".equals(string.substring(i, i + 1))) {
                byArray[i] = 125;
                continue;
            }
            if ("[".equals(string.substring(i, i + 1))) {
                byArray[i] = 91;
                continue;
            }
            throw new RuntimeException("Unsupported character");
        }
        return byArray;
    }
}

