/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.z80;

import com.ti.eps.calc.TiCalc;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.FontString;
import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Hashtable;

public class UnicodeToZ80Font {
    private static final byte DEFAULT_CHAR = 10;
    private static final FontCode[] UNICODE_TO_TI73_FONT = new FontCode[]{new FontCode('\t', -12, "_tab_"), new FontCode('\n', -42, "_enter_"), new FontCode('$', 36, "_$_"), new FontCode('[', -63, "_[_"), new FontCode(']', 93, "_]_"), new FontCode('_', 95, "_underscore_"), new FontCode('\u00a1', -70, "_!_"), new FontCode('\u00a2', 0, "_cents_"), new FontCode('\u00a3', 0, "_pounds_"), new FontCode('\u00a4', 0, "_starburst_"), new FontCode('\u00a5', 0, "_yen_"), new FontCode('\u00a6', 0, "_splitbar_"), new FontCode('\u00a7', 0, "_section_"), new FontCode('\u00a8', -72, "_dier_"), new FontCode('\u00a9', -39, "_(C)_"), new FontCode('\u00aa', 0, "_^a_"), new FontCode('\u00ab', 0, "_<<_"), new FontCode('\u00ac', 0, "_lnot_"), new FontCode('\u00ae', 0, "_registered_"), new FontCode('\u00af', 26, "_neg_"), new FontCode('\u00b0', 20, "_degrees_"), new FontCode('\u00b0', -44, "_temp_"), new FontCode('\u00b1', 0, "_+-_"), new FontCode('\u00b2', 18, "_^2_"), new FontCode('\u00b2', -45, "_squared_"), new FontCode('\u00b3', 14, "_^3_"), new FontCode('\u00b3', -43, "_cubed_"), new FontCode('\u00b4', -74, "_accent_"), new FontCode('\u00b5', -61, "_mu_"), new FontCode('\u00b6', 0, "_para_"), new FontCode('\u00b7', 0, "_dot_"), new FontCode('\u00b9', 0, "_^1_"), new FontCode('\u00ba', 0, "_^0_"), new FontCode('\u00bb', 0, "_>>_"), new FontCode('\u00bb', 0, "_>>_"), new FontCode('\u00bc', 0, "_1/4_"), new FontCode('\u00bd', 0, "_1/2_"), new FontCode('\u00be', 0, "_3/4_"), new FontCode('\u00bf', -71, "_?_"), new FontCode('\u00c0', -117, "_A`_"), new FontCode('\u00c1', -118, "_A'_"), new FontCode('\u00c2', -116, "_A^_"), new FontCode('\u00c3', 0, "_A~_"), new FontCode('\u00c4', -115, "_A:_"), new FontCode('\u00c5', 0, "_Ao_"), new FontCode('\u00c6', 0, "_AE_"), new FontCode('\u00c7', -78, "_C'_"), new FontCode('\u00c8', -109, "_E`_"), new FontCode('\u00c9', -110, "_E'_"), new FontCode('\u00ca', -108, "_E^_"), new FontCode('\u00cb', -107, "_E:_"), new FontCode('\u00cc', -101, "_I`_"), new FontCode('\u00cd', -102, "_I'_"), new FontCode('\u00ce', -100, "_I^_"), new FontCode('\u00cf', -99, "_I:_"), new FontCode('\u00d0', 0, "_Dbar_"), new FontCode('\u00d1', -76, "_N~_"), new FontCode('\u00d2', -93, "_O`_"), new FontCode('\u00d3', -94, "_O'_"), new FontCode('\u00d4', -92, "_O^_"), new FontCode('\u00d5', 0, "_O~_"), new FontCode('\u00d6', -91, "_O:_"), new FontCode('\u00d7', 9, "_sideways+_"), new FontCode('\u00d8', 0, "_O/_"), new FontCode('\u00d9', -85, "_U`_"), new FontCode('\u00da', -86, "_U'_"), new FontCode('\u00db', -84, "_U^_"), new FontCode('\u00dc', -83, "_U:_"), new FontCode('\u00dd', 0, "_Y'_"), new FontCode('\u00de', 0, "_P_"), new FontCode('\u00df', 0, "_eschett_"), new FontCode('\u00e0', -113, "_a`_"), new FontCode('\u00e1', -114, "_a'_"), new FontCode('\u00e2', -112, "_a^_"), new FontCode('\u00e3', 0, "_a~_"), new FontCode('\u00e4', -111, "_a:_"), new FontCode('\u00e5', 0, "_ao_"), new FontCode('\u00e6', 0, "_ae_"), new FontCode('\u00e7', -77, "_c'_"), new FontCode('\u00e8', -105, "_e`_"), new FontCode('\u00e9', -106, "_e'_"), new FontCode('\u00ea', -104, "_e^_"), new FontCode('\u00eb', -103, "_e:_"), new FontCode('\u00ec', -97, "_i`_"), new FontCode('\u00ed', -98, "_i'_"), new FontCode('\u00ee', -96, "_i^_"), new FontCode('\u00ef', -95, "_i:_"), new FontCode('\u00f0', 0, "_dbar_"), new FontCode('\u00f1', -75, "_n~_"), new FontCode('\u00f2', -89, "_o`_"), new FontCode('\u00f3', -90, "_o'_"), new FontCode('\u00f4', -88, "_o^_"), new FontCode('\u00f5', 0, "_o~_"), new FontCode('\u00f6', -87, "_o:_"), new FontCode('\u00f7', 0, "_/_"), new FontCode('\u00f8', 0, "_o/_"), new FontCode('\u00f9', -81, "_u`_"), new FontCode('\u00fa', -82, "_u'_"), new FontCode('\u00fb', -80, "_u^_"), new FontCode('\u00fc', -79, "_u:_"), new FontCode('\u00fd', 0, "_y'_"), new FontCode('\u00fe', 0, "_p_"), new FontCode('\u00ff', 0, "_y:_"), new FontCode('\u0393', 0, "_GAMMA_"), new FontCode('\u0394', -66, "_DELTA_"), new FontCode('\u03a0', 0, "_PI_"), new FontCode('\u03a3', -58, "_SIGMA_"), new FontCode('\u03a9', -54, "_OMEGA_"), new FontCode('\u03b1', -69, "_alpha_"), new FontCode('\u03b2', -68, "_beta_"), new FontCode('\u03b3', -67, "_gamma_"), new FontCode('\u03b4', -65, "_delta_"), new FontCode('\u03b5', -64, "_epsilon_"), new FontCode('\u03b6', 0, "_zeta_"), new FontCode('\u03b8', 91, "_theta_"), new FontCode('\u03bb', -62, "_lambda_"), new FontCode('\u03be', 0, "_xi_"), new FontCode('\u03c0', -60, "_pi_"), new FontCode('\u03c1', -59, "_rho_"), new FontCode('\u03c3', -57, "_sigma_"), new FontCode('\u03c4', -56, "_tau_"), new FontCode('\u03c6', -55, "_phi_"), new FontCode('\u03c7', 0, "_chi_"), new FontCode('\u03c8', 0, "_psi_"), new FontCode('\u03c9', 0, "_omega_"), new FontCode('\u2022', 12, "_bullet_"), new FontCode('\u2026', -50, "_ellipsis_"), new FontCode('\u207a', 11, "_^+_"), new FontCode('\u207b', 0, "_^-_"), new FontCode('\u2080', -128, "_0_"), new FontCode('\u2081', -127, "_1_"), new FontCode('\u2082', -126, "_2_"), new FontCode('\u2083', -125, "_3_"), new FontCode('\u2084', -124, "_4_"), new FontCode('\u2085', -123, "_5_"), new FontCode('\u2086', -122, "_6_"), new FontCode('\u2087', -121, "_7_"), new FontCode('\u2088', -120, "_8_"), new FontCode('\u2089', -119, "_9_"), new FontCode('\u212f', -37, "_e_"), new FontCode('\u2190', 0, "_<-_"), new FontCode('\u2191', 30, "_up-arrow_"), new FontCode('\u2192', 28, "_->_"), new FontCode('\u2193', 31, "_dn-arrow_"), new FontCode('\u2208', 0, "_element_"), new FontCode('\u221a', 16, "_root_"), new FontCode('\u221e', 0, "_infinity_"), new FontCode('\u2220', 19, "_angle_"), new FontCode('\u2229', 0, "_intersect_"), new FontCode('\u222a', 0, "_union_"), new FontCode('\u222b', 8, "_integral_"), new FontCode('\u2260', 24, "_!=_"), new FontCode('\u2264', 23, "_<=_"), new FontCode('\u2265', 25, "_>=_"), new FontCode('\u2282', 0, "_subset_"), new FontCode('\u230a', -36, "_L_"), new FontCode('\u25ab', 10, "_block_"), new FontCode('\u25b6', 0, "_small>_"), new FontCode('\uf000', 27, "_EE_"), new FontCode('\uf001', 21, "_radians_"), new FontCode('\uf002', 22, "_trans_"), new FontCode('\uf003', -53, "_xmean_"), new FontCode('\uf004', -52, "_ymean_"), new FontCode('\uf005', 17, "_^-1_"), new FontCode('\uf006', -51, "_^x_"), new FontCode('\uf007', 0, "_ord_"), new FontCode('\uf008', 0, "_diff_"), new FontCode('\uf00a', -47, "_per_"), new FontCode('\uf00b', -49, "_<_"), new FontCode('\uf00e', 1, "_n_"), new FontCode('\uf014', 5, "_>_"), new FontCode('\uf015', 0, "_up-solid_"), new FontCode('\uf016', 7, "_dn-solid_"), new FontCode('\uf01d', 29, "_10_"), new FontCode('\uf021', 0, "_F-stat_"), new FontCode('\uf022', 0, "_rho^_"), new FontCode('\uf025', 0, "_bin_"), new FontCode('\uf026', 0, "_oct_"), new FontCode('\uf027', 0, "_dec_"), new FontCode('\uf028', 0, "_hex_"), new FontCode('\uf029', 0, "_A_"), new FontCode('\uf02a', 0, "_B_"), new FontCode('\uf02b', 0, "_C_"), new FontCode('\uf02c', 0, "_D_"), new FontCode('\uf02d', 0, "_E_"), new FontCode('\uf02e', 15, "_F_"), new FontCode('\uf02f', 0, "_i_"), new FontCode('\uf038', 13, "_T_"), new FontCode('\uf03a', 0, "_lock_")};
    private static final FontCode[] UNICODE_TO_TI83_FONT = new FontCode[]{new FontCode('\t', -12, "_tab_"), new FontCode('\n', -42, "_enter_"), new FontCode('$', -14, "_$_"), new FontCode('[', -63, "_[_"), new FontCode(']', 93, "_]_"), new FontCode('_', 95, "_underscore_"), new FontCode('\u00a1', -70, "_!_"), new FontCode('\u00a2', 0, "_cents_"), new FontCode('\u00a3', 0, "_pounds_"), new FontCode('\u00a4', 0, "_starburst_"), new FontCode('\u00a5', 0, "_yen_"), new FontCode('\u00a6', 0, "_splitbar_"), new FontCode('\u00a7', 0, "_section_"), new FontCode('\u00a8', -72, "_dier_"), new FontCode('\u00a9', 0, "_(C)_"), new FontCode('\u00aa', 0, "_^a_"), new FontCode('\u00ab', 0, "_<<_"), new FontCode('\u00ac', 0, "_lnot_"), new FontCode('\u00ae', 0, "_registered_"), new FontCode('\u00af', 26, "_neg_"), new FontCode('\u00b0', 20, "_degrees_"), new FontCode('\u00b0', -44, "_temp_"), new FontCode('\u00b1', 0, "_+-_"), new FontCode('\u00b2', 18, "_^2_"), new FontCode('\u00b2', -45, "_squared_"), new FontCode('\u00b3', 14, "_^3_"), new FontCode('\u00b3', -43, "_cubed_"), new FontCode('\u00b4', -74, "_accent_"), new FontCode('\u00b5', -61, "_mu_"), new FontCode('\u00b6', 0, "_para_"), new FontCode('\u00b7', 0, "_dot_"), new FontCode('\u00b9', 0, "_^1_"), new FontCode('\u00ba', 0, "_^0_"), new FontCode('\u00bb', 0, "_>>_"), new FontCode('\u00bb', 0, "_>>_"), new FontCode('\u00bc', 0, "_1/4_"), new FontCode('\u00bd', 0, "_1/2_"), new FontCode('\u00be', 0, "_3/4_"), new FontCode('\u00bf', -71, "_?_"), new FontCode('\u00c0', -117, "_A`_"), new FontCode('\u00c1', -118, "_A'_"), new FontCode('\u00c2', -116, "_A^_"), new FontCode('\u00c3', 0, "_A~_"), new FontCode('\u00c4', -115, "_A:_"), new FontCode('\u00c5', 0, "_Ao_"), new FontCode('\u00c6', 0, "_AE_"), new FontCode('\u00c7', -78, "_C'_"), new FontCode('\u00c8', -109, "_E`_"), new FontCode('\u00c9', -110, "_E'_"), new FontCode('\u00ca', -108, "_E^_"), new FontCode('\u00cb', -107, "_E:_"), new FontCode('\u00cc', -101, "_I`_"), new FontCode('\u00cd', -102, "_I'_"), new FontCode('\u00ce', -100, "_I^_"), new FontCode('\u00cf', -99, "_I:_"), new FontCode('\u00d0', 0, "_Dbar_"), new FontCode('\u00d1', -76, "_N~_"), new FontCode('\u00d2', -93, "_O`_"), new FontCode('\u00d3', -94, "_O'_"), new FontCode('\u00d4', -92, "_O^_"), new FontCode('\u00d5', 0, "_O~_"), new FontCode('\u00d6', -91, "_O:_"), new FontCode('\u00d7', 9, "_sideways+_"), new FontCode('\u00d8', 0, "_O/_"), new FontCode('\u00d9', -85, "_U`_"), new FontCode('\u00da', -86, "_U'_"), new FontCode('\u00db', -84, "_U^_"), new FontCode('\u00dc', -83, "_U:_"), new FontCode('\u00dd', 0, "_Y'_"), new FontCode('\u00de', 0, "_P_"), new FontCode('\u00df', -12, "_eschett_"), new FontCode('\u00e0', -113, "_a`_"), new FontCode('\u00e1', -114, "_a'_"), new FontCode('\u00e2', -112, "_a^_"), new FontCode('\u00e3', 0, "_a~_"), new FontCode('\u00e4', -111, "_a:_"), new FontCode('\u00e5', 0, "_ao_"), new FontCode('\u00e6', 0, "_ae_"), new FontCode('\u00e7', -77, "_c'_"), new FontCode('\u00e8', -105, "_e`_"), new FontCode('\u00e9', -106, "_e'_"), new FontCode('\u00ea', -104, "_e^_"), new FontCode('\u00eb', -103, "_e:_"), new FontCode('\u00ec', -97, "_i`_"), new FontCode('\u00ed', -98, "_i'_"), new FontCode('\u00ee', -96, "_i^_"), new FontCode('\u00ef', -95, "_i:_"), new FontCode('\u00f0', 0, "_dbar_"), new FontCode('\u00f1', -75, "_n~_"), new FontCode('\u00f2', -89, "_o`_"), new FontCode('\u00f3', -90, "_o'_"), new FontCode('\u00f4', -88, "_o^_"), new FontCode('\u00f5', 0, "_o~_"), new FontCode('\u00f6', -87, "_o:_"), new FontCode('\u00f7', 0, "_/_"), new FontCode('\u00f8', 0, "_o/_"), new FontCode('\u00f9', -81, "_u`_"), new FontCode('\u00fa', -82, "_u'_"), new FontCode('\u00fb', -80, "_u^_"), new FontCode('\u00fc', -79, "_u:_"), new FontCode('\u00fd', 0, "_y'_"), new FontCode('\u00fe', 0, "_p_"), new FontCode('\u00ff', 0, "_y:_"), new FontCode('\u0393', 0, "_GAMMA_"), new FontCode('\u0394', -66, "_DELTA_"), new FontCode('\u03a0', 0, "_PI_"), new FontCode('\u03a3', -58, "_SIGMA_"), new FontCode('\u03a9', -54, "_OMEGA_"), new FontCode('\u03b1', -69, "_alpha_"), new FontCode('\u03b2', -68, "_beta_"), new FontCode('\u03b3', -67, "_gamma_"), new FontCode('\u03b4', -65, "_delta_"), new FontCode('\u03b5', -64, "_epsilon_"), new FontCode('\u03b6', 0, "_zeta_"), new FontCode('\u03b8', 91, "_theta_"), new FontCode('\u03bb', -62, "_lambda_"), new FontCode('\u03be', 0, "_xi_"), new FontCode('\u03c0', -60, "_pi_"), new FontCode('\u03c1', -59, "_rho_"), new FontCode('\u03c3', -57, "_sigma_"), new FontCode('\u03c4', -56, "_tau_"), new FontCode('\u03c6', -55, "_phi_"), new FontCode('\u03c7', -39, "_chi_"), new FontCode('\u03c8', 0, "_psi_"), new FontCode('\u03c9', 0, "_omega_"), new FontCode('\u2022', 12, "_bullet_"), new FontCode('\u2026', -50, "_ellipsis_"), new FontCode('\u207a', 11, "_^+_"), new FontCode('\u207b', 0, "_^-_"), new FontCode('\u2080', -128, "_0_"), new FontCode('\u2081', -127, "_1_"), new FontCode('\u2082', -126, "_2_"), new FontCode('\u2083', -125, "_3_"), new FontCode('\u2084', -124, "_4_"), new FontCode('\u2085', -123, "_5_"), new FontCode('\u2086', -122, "_6_"), new FontCode('\u2087', -121, "_7_"), new FontCode('\u2088', -120, "_8_"), new FontCode('\u2089', -119, "_9_"), new FontCode('\u212f', -37, "_e_"), new FontCode('\u2190', 0, "_<-_"), new FontCode('\u2191', 30, "_up-arrow_"), new FontCode('\u2192', 28, "_->_"), new FontCode('\u2193', 31, "_dn-arrow_"), new FontCode('\u2208', 0, "_element_"), new FontCode('\u221a', 16, "_root_"), new FontCode('\u221e', 0, "_infinity_"), new FontCode('\u2220', 19, "_angle_"), new FontCode('\u2229', 0, "_intersect_"), new FontCode('\u222a', 0, "_union_"), new FontCode('\u222b', 8, "_integral_"), new FontCode('\u2260', 24, "_!=_"), new FontCode('\u2264', 23, "_<=_"), new FontCode('\u2265', 25, "_>=_"), new FontCode('\u2282', 0, "_subset_"), new FontCode('\u230a', -36, "_L_"), new FontCode('\u25ab', 10, "_block_"), new FontCode('\u25b6', 0, "_small>_"), new FontCode('\uf000', 27, "_EE_"), new FontCode('\uf001', 21, "_radians_"), new FontCode('\uf002', 22, "_trans_"), new FontCode('\uf003', -53, "_xmean_"), new FontCode('\uf004', -52, "_ymean_"), new FontCode('\uf005', 17, "_^-1_"), new FontCode('\uf006', -51, "_^x_"), new FontCode('\uf007', 0, "_ord_"), new FontCode('\uf008', 0, "_diff_"), new FontCode('\uf00a', -47, "_per_"), new FontCode('\uf00b', -49, "_<_"), new FontCode('\uf00e', 1, "_n_"), new FontCode('\uf014', 5, "_>_"), new FontCode('\uf015', -13, "_up-solid_"), new FontCode('\uf016', 7, "_dn-solid_"), new FontCode('\uf01d', 29, "_10_"), new FontCode('\uf021', -38, "_F-stat_"), new FontCode('\uf022', -40, "_rho^_"), new FontCode('\uf025', 0, "_bin_"), new FontCode('\uf026', 0, "_oct_"), new FontCode('\uf027', 0, "_dec_"), new FontCode('\uf028', 0, "_hex_"), new FontCode('\uf029', 0, "_A_"), new FontCode('\uf02a', 0, "_B_"), new FontCode('\uf02b', 0, "_C_"), new FontCode('\uf02c', 0, "_D_"), new FontCode('\uf02d', 0, "_E_"), new FontCode('\uf02e', 15, "_F_"), new FontCode('\uf02f', -41, "_i_"), new FontCode('\uf038', 13, "_T_"), new FontCode('\uf03a', 0, "_lock_")};
    private static Hashtable<Byte, Byte> toUpper73 = new Hashtable();
    private static boolean built73 = false;
    private static boolean built83 = false;
    private static Hashtable<Byte, Byte> toUpper83 = new Hashtable();
    private static ByteBuffer buf = ByteBuffer.allocate(200);

    private static void build73() {
        if (built73) {
            return;
        }
        toUpper73.put(new Byte(-113), new Byte(-117));
        toUpper73.put(new Byte(-114), new Byte(-118));
        toUpper73.put(new Byte(-112), new Byte(-116));
        toUpper73.put(new Byte(-111), new Byte(-115));
        toUpper73.put(new Byte(-77), new Byte(-78));
        toUpper73.put(new Byte(-105), new Byte(-109));
        toUpper73.put(new Byte(-106), new Byte(-110));
        toUpper73.put(new Byte(-104), new Byte(-108));
        toUpper73.put(new Byte(-103), new Byte(-107));
        toUpper73.put(new Byte(-97), new Byte(-101));
        toUpper73.put(new Byte(-98), new Byte(-102));
        toUpper73.put(new Byte(-96), new Byte(-100));
        toUpper73.put(new Byte(-95), new Byte(-99));
        toUpper73.put(new Byte(-75), new Byte(-76));
        toUpper73.put(new Byte(-89), new Byte(-93));
        toUpper73.put(new Byte(-90), new Byte(-94));
        toUpper73.put(new Byte(-88), new Byte(-92));
        toUpper73.put(new Byte(-87), new Byte(-91));
        toUpper73.put(new Byte(-81), new Byte(-85));
        toUpper73.put(new Byte(-82), new Byte(-86));
        toUpper73.put(new Byte(-80), new Byte(-84));
        toUpper73.put(new Byte(-79), new Byte(-83));
        built73 = true;
    }

    private static void build83() {
        if (built83) {
            return;
        }
        toUpper83.put(new Byte(-113), new Byte(-117));
        toUpper83.put(new Byte(-114), new Byte(-118));
        toUpper83.put(new Byte(-112), new Byte(-116));
        toUpper83.put(new Byte(-111), new Byte(-115));
        toUpper83.put(new Byte(-77), new Byte(-78));
        toUpper83.put(new Byte(-105), new Byte(-109));
        toUpper83.put(new Byte(-106), new Byte(-110));
        toUpper83.put(new Byte(-104), new Byte(-108));
        toUpper83.put(new Byte(-103), new Byte(-107));
        toUpper83.put(new Byte(-97), new Byte(-101));
        toUpper83.put(new Byte(-98), new Byte(-102));
        toUpper83.put(new Byte(-96), new Byte(-100));
        toUpper83.put(new Byte(-95), new Byte(-99));
        toUpper83.put(new Byte(-75), new Byte(-76));
        toUpper83.put(new Byte(-89), new Byte(-93));
        toUpper83.put(new Byte(-90), new Byte(-94));
        toUpper83.put(new Byte(-88), new Byte(-92));
        toUpper83.put(new Byte(-87), new Byte(-91));
        toUpper83.put(new Byte(-81), new Byte(-85));
        toUpper83.put(new Byte(-82), new Byte(-86));
        toUpper83.put(new Byte(-80), new Byte(-84));
        toUpper83.put(new Byte(-79), new Byte(-83));
        built83 = true;
    }

    public static byte[] convertText(String string, DBUSDeviceCode dBUSDeviceCode) {
        if (DBUSDeviceCode.UNIT_73.equals(dBUSDeviceCode)) {
            return UnicodeToZ80Font.convert73Text(string);
        }
        return UnicodeToZ80Font.convert83Text(string);
    }

    private static byte[] convert83Text(String string) {
        return UnicodeToZ80Font.convertText(string, UNICODE_TO_TI83_FONT);
    }

    private static byte[] convert73Text(String string) {
        return UnicodeToZ80Font.convertText(string, UNICODE_TO_TI73_FONT);
    }

    public static String validateText(String string, DBUSDeviceCode dBUSDeviceCode) {
        if (DBUSDeviceCode.UNIT_73.equals(dBUSDeviceCode)) {
            return UnicodeToZ80Font.validate73Text(string);
        }
        return UnicodeToZ80Font.validate83Text(string);
    }

    private static String validate83Text(String string) {
        return UnicodeToZ80Font.validateText(string, UNICODE_TO_TI83_FONT);
    }

    private static String validate73Text(String string) {
        return UnicodeToZ80Font.validateText(string, UNICODE_TO_TI73_FONT);
    }

    private static synchronized String validateText(String string, FontCode[] fontCodeArray) {
        String string2 = "";
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            FontCode fontCode = UnicodeToZ80Font.findFontCode(c, fontCodeArray);
            if (fontCode == null && c >= ' ' && c <= '\u00ff') {
                string2 = string2 + c;
                continue;
            }
            if (fontCode == null) {
                buf.put((byte)10);
                continue;
            }
            string2 = fontCode.z80Code == 0 ? string2 + fontCode.empty : string2 + c;
        }
        return string2;
    }

    public static FontString alphaToUpper(DBUSDeviceCode dBUSDeviceCode, FontString fontString) {
        if (DBUSDeviceCode.UNIT_73.equals(dBUSDeviceCode)) {
            UnicodeToZ80Font.build73();
            return TiCalc.newFontString(dBUSDeviceCode, UnicodeToZ80Font.alphaToUpper(fontString, toUpper73));
        }
        UnicodeToZ80Font.build83();
        return TiCalc.newFontString(dBUSDeviceCode, UnicodeToZ80Font.alphaToUpper(fontString, toUpper83));
    }

    public static byte[] alphaToUpper(FontString fontString, Hashtable<Byte, Byte> hashtable) {
        byte[] byArray = fontString.toBytes();
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by >= 97 && by <= 122) {
                byArray[i] = (byte)Character.toUpperCase(by);
                continue;
            }
            if (!hashtable.containsKey(new Byte(by))) continue;
            byArray[i] = hashtable.get(new Byte(by));
        }
        return byArray;
    }

    private static synchronized byte[] convertText(String string, FontCode[] fontCodeArray) {
        try {
            buf.clear();
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                FontCode fontCode = UnicodeToZ80Font.findFontCode(c, fontCodeArray);
                if (fontCode == null && c >= ' ' && c <= '\u00ff') {
                    buf.put((byte)c);
                    continue;
                }
                if (fontCode == null) {
                    buf.put((byte)10);
                    continue;
                }
                if (fontCode.z80Code == 0) {
                    try {
                        buf.put(fontCode.empty.getBytes("US-ASCII"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    continue;
                }
                buf.put(fontCode.z80Code);
            }
            buf.flip();
            byte[] byArray = new byte[buf.limit()];
            buf.get(byArray);
            return byArray;
        }
        catch (BufferOverflowException bufferOverflowException) {
            buf = ByteBuffer.allocate(buf.capacity() * 2);
            return UnicodeToZ80Font.convertText(string, fontCodeArray);
        }
    }

    private static FontCode findFontCode(char c, FontCode[] fontCodeArray) {
        int n = Arrays.binarySearch(fontCodeArray, new Character(c));
        if (n > 0) {
            return fontCodeArray[n];
        }
        return null;
    }

    private UnicodeToZ80Font() {
    }

    private static class FontCode
    implements Comparable<FontCode> {
        char uniChar;
        byte z80Code;
        String empty;
        private static final MessageFormat MSG = new MessageFormat("\"{0}\" 0x{1}, 0x{2}");

        public FontCode(char c, byte by, String string) {
            this.uniChar = c;
            this.z80Code = by;
            this.empty = string;
        }

        @Override
        public int compareTo(FontCode fontCode) {
            return this.uniChar - fontCode.uniChar;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FontCode)) {
                return false;
            }
            FontCode fontCode = (FontCode)object;
            return this.z80Code == fontCode.z80Code && this.uniChar == fontCode.uniChar && (this.empty == null ? fontCode.empty == null : this.empty.equals(fontCode.empty));
        }

        public String toString() {
            return MSG.format(new String[]{this.empty, Integer.toHexString(this.z80Code), Integer.toHexString(this.uniChar)});
        }
    }
}

