/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.ti83Plus;

import com.ti.eps.calc.dbus.DBUSDataType;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.HardwareRevision;
import java.nio.ByteOrder;

public class Ti83PlusConstants {
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    public static final byte UNIT_CODE_VALUE = 115;
    public static final byte PC_CODE_VALUE = 35;
    public static final DBUSDeviceCode UNIT_CODE;
    public static final DBUSDeviceCode PC_CODE;
    public static final HardwareRevision HW_TI83PLUS;
    public static final HardwareRevision HW_TI83PLUS_SILVER;
    public static final HardwareRevision HW_TI84PLUS;
    public static final HardwareRevision HW_TI84PLUS_SILVER;
    public static final HardwareRevision HW_TI84PLUS_C_SILVER;
    public static final HardwareRevision HW_TI83PLUS_UNKNOWN;
    public static final byte DATA_TYPE_CODE_REAL = 0;
    public static final DBUSDataType DATA_TYPE_REAL;
    public static final byte DATA_TYPE_CODE_REAL_LIST = 1;
    public static final DBUSDataType DATA_TYPE_REAL_LIST;
    public static final byte DATA_TYPE_CODE_MATRIX = 2;
    public static final DBUSDataType DATA_TYPE_MATRIX;
    public static final byte DATA_TYPE_CODE_EQUATION = 3;
    public static final DBUSDataType DATA_TYPE_EQUATION;
    public static final byte DATA_TYPE_CODE_STRING = 4;
    public static final DBUSDataType DATA_TYPE_STRING;
    public static final byte DATA_TYPE_CODE_PROGRAM = 5;
    public static final DBUSDataType DATA_TYPE_PROGRAM;
    public static final byte DATA_TYPE_CODE_PROTECTED_PROGRAM = 6;
    public static final DBUSDataType DATA_TYPE_PROTECTED_PROGRAM;
    public static final byte DATA_TYPE_CODE_PICTURE = 7;
    public static final DBUSDataType DATA_TYPE_PICTURE;
    public static final byte DATA_TYPE_CODE_GRAPH_DATABASE = 8;
    public static final DBUSDataType DATA_TYPE_GRAPH_DATABASE;
    public static final byte DATA_TYPE_CODE_COMPLEX_NUMBER = 12;
    public static final DBUSDataType DATA_TYPE_COMPLEX_NUMBER;
    public static final byte DATA_TYPE_CODE_COMPLEX_LIST = 13;
    public static final DBUSDataType DATA_TYPE_COMPLEX_LIST;
    public static final byte DATA_TYPE_CODE_WINDOW_RANGE = 15;
    public static final DBUSDataType DATA_TYPE_WINDOW_RANGE;
    public static final byte DATA_TYPE_CODE_USER_ZOOM = 16;
    public static final DBUSDataType DATA_TYPE_USER_ZOOM;
    public static final byte DATA_TYPE_CODE_TABLE_SETUP = 17;
    public static final DBUSDataType DATA_TYPE_TABLE_SETUP;
    public static final byte DATA_TYPE_CODE_DIRECTORY = 19;
    public static final DBUSDataType DATA_TYPE_DIRECTORY;
    public static final byte DATA_TYPE_CODE_GROUP_OBJECT = 23;
    public static final DBUSDataType DATA_TYPE_GROUP_OBJECT;
    public static final byte DATA_TYPE_CODE_APPVAR = 21;
    public static final DBUSDataType DATA_TYPE_APPVAR;
    public static final byte DATA_TYPE_CODE_BASE_CODE = 35;
    public static final DBUSDataType DATA_TYPE_BASE_CODE;
    public static final byte DATA_TYPE_CODE_FLASHAPP = 36;
    public static final DBUSDataType DATA_TYPE_FLASHAPP;
    public static final byte DATA_TYPE_CODE_FLASHAPP_INTERNAL = 20;
    public static final DBUSDataType DATA_TYPE_FLASHAPP_INTERNAL;
    public static final byte DATA_TYPE_CODE_IMAGE_VAR = 26;
    public static final DBUSDataType DATA_TYPE_IMAGE_VAR;
    public static final int APP_SLOT_SIZE = 16384;
    public static final int FLASHAPP_SECTOR_SIZE = 128;
    public static final int BASECODE_SECTOR_SIZE = 256;

    static {
        HW_TI83PLUS = new HardwareRevision("TI-83 Plus");
        HW_TI83PLUS_SILVER = new HardwareRevision("TI-83 Plus Silver Edition");
        HW_TI84PLUS = new HardwareRevision("TI-84 Plus");
        HW_TI84PLUS_SILVER = new HardwareRevision("TI-84 Plus Silver Edition");
        HW_TI84PLUS_C_SILVER = new HardwareRevision("TI-84 Plus C Silver Edition");
        HW_TI83PLUS_UNKNOWN = new HardwareRevision("TI-83 Family Product");
        UNIT_CODE = DBUSDeviceCode.registerCode((byte)115, "TI-83 Plus / TI-84 Plus Family");
        PC_CODE = DBUSDeviceCode.registerCode((byte)35, "PC To TI-83 Plus");
        DATA_TYPE_REAL = DBUSDataType.registerType(UNIT_CODE, (byte)0, "8xn", "Real Number");
        DATA_TYPE_REAL_LIST = DBUSDataType.registerType(UNIT_CODE, (byte)1, "8xl", "Real List");
        DATA_TYPE_MATRIX = DBUSDataType.registerType(UNIT_CODE, (byte)2, "8xm", "Real Matrix");
        DATA_TYPE_EQUATION = DBUSDataType.registerType(UNIT_CODE, (byte)3, "8xy", "Equation", 10);
        DATA_TYPE_STRING = DBUSDataType.registerType(UNIT_CODE, (byte)4, "8xs", "String");
        DATA_TYPE_PROGRAM = DBUSDataType.registerType(UNIT_CODE, (byte)5, "8xp", "Program");
        DATA_TYPE_PROTECTED_PROGRAM = DBUSDataType.registerType(UNIT_CODE, (byte)6, "8xp", "Protect Program");
        DATA_TYPE_PICTURE = DBUSDataType.registerType(UNIT_CODE, (byte)7, "8xi", "Picture");
        DATA_TYPE_GRAPH_DATABASE = DBUSDataType.registerType(UNIT_CODE, (byte)8, "8xd", "Graph Database");
        DATA_TYPE_COMPLEX_NUMBER = DBUSDataType.registerType(UNIT_CODE, (byte)12, "8xc", "Complex Number");
        DATA_TYPE_COMPLEX_LIST = DBUSDataType.registerType(UNIT_CODE, (byte)13, "8xl", "Complex List");
        DATA_TYPE_WINDOW_RANGE = DBUSDataType.registerType(UNIT_CODE, (byte)15, "8xw", "Window Range");
        DATA_TYPE_USER_ZOOM = DBUSDataType.registerType(UNIT_CODE, (byte)16, "8xz", "User Zoom Window");
        DATA_TYPE_TABLE_SETUP = DBUSDataType.registerType(UNIT_CODE, (byte)17, "8xt", "Table Setup");
        DATA_TYPE_GROUP_OBJECT = DBUSDataType.registerType(UNIT_CODE, (byte)23, "8xg", "Group Object");
        DATA_TYPE_DIRECTORY = DBUSDataType.registerType(UNIT_CODE, (byte)19, null, "Directory Listing");
        DATA_TYPE_APPVAR = DBUSDataType.registerType(UNIT_CODE, (byte)21, "8xv", "Application Variable");
        DATA_TYPE_BASE_CODE = DBUSDataType.registerType(UNIT_CODE, (byte)35, "8xu", "Base Code");
        DATA_TYPE_FLASHAPP = DBUSDataType.registerType(UNIT_CODE, (byte)36, "8xk", "Flash Application");
        DATA_TYPE_FLASHAPP_INTERNAL = DBUSDataType.registerType(UNIT_CODE, (byte)20, null, "AppObject");
        DATA_TYPE_IMAGE_VAR = DBUSDataType.registerType(UNIT_CODE, (byte)26, "8ca", "BackgroundImage");
    }
}

