/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.ti83;

import com.ti.eps.calc.TiCalc;
import com.ti.eps.calc.dbus.DBUSDataType;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.DeviceFileImpl;
import com.ti.eps.calc.dbus.exceptions.InvalidDeviceFileException;
import com.ti.eps.calc.ti83.Ti83Constants;
import com.ti.eps.calc.ti83Plus.Ti83PlusTokenString;
import com.ti.eps.calc.z80.Z80DeviceFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class Ti83DeviceFile
extends Z80DeviceFile {
    private static final int MAX_EQUATIONS = 10;
    public static final byte[] validHeader83 = new byte[]{42, 42, 84, 73, 56, 51, 42, 42, 26, 10, 0};

    public Ti83DeviceFile(DBUSDataType dBUSDataType) {
        super(dBUSDataType);
    }

    public Ti83DeviceFile(File file) throws IOException, InvalidDeviceFileException {
        super(file);
    }

    public Ti83DeviceFile(InputStream inputStream) throws IOException, InvalidDeviceFileException {
        super(inputStream);
    }

    @Override
    protected boolean verifyHeader(byte[] byArray) {
        return DeviceFileImpl.isValidHeader(ByteBuffer.wrap(byArray), validHeader83);
    }

    @Override
    protected byte[] getFileHeader() {
        return validHeader83;
    }

    @Override
    public DBUSDeviceCode getDeviceCode() {
        return Ti83Constants.UNIT_CODE;
    }

    @Override
    public void setName(int n) {
        if (this.getDataType().getName().equals("Equation")) {
            if (n < 0 || n > 10) {
                throw new IllegalArgumentException("Valid equation ids are 0 to 10");
            }
        } else {
            throw new IllegalArgumentException("Unsupported datatype [" + this.getDataType() + "] for this method");
        }
        int n2 = n == 10 ? 0 : n + 1;
        String string = "Y_" + n2 + "_";
        this.setName(TiCalc.newTokenString(this.getDeviceCode(), string));
    }

    @Override
    protected void setName(byte[] byArray) {
        this.setName(new Ti83PlusTokenString(byArray));
    }

    @Override
    public void setVersion(byte by) {
    }

    @Override
    public byte getVersion() {
        return 0;
    }
}

