/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.ti73;

import com.ti.eps.calc.z80.Z80STokenOffsets;
import com.ti.eps.calc.z80.Z80STokensAscii;
import com.ti.eps.calc.z80.Z80SmallFontToAscii;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParseConnectHeaders {
    private final Pattern SECONDBYTE_PATTERN = Pattern.compile("\\{\"(.*?)\",\\s+(0[Xx][0-9A-F][0-9A-F]),\\s+(0[Xx][0-9A-F][0-9A-F])\\}");
    private final Pattern PRIMEDECL_PATTERN = Pattern.compile("char primeToken");
    private final Pattern PRIME_PATTERN = Pattern.compile("^\\s+\"(.*?)\",?\\s+(.*)\\s*$");
    private final Pattern ESC_PATTERN = Pattern.compile("\\\\[xX]([0-9A-F][0-9A-F])");
    String[] lengthElements = new String[]{"mm", "cm", "m", "inch", "ft", "yard", "km", "mile"};
    String[] areaElements = new String[]{"sqft", "sqm", "sqmi", "sqkm", "acre", "sqin", "sqcm", "sqyd", "ha"};
    String[] volumeElements = new String[]{"liter", "gal", "qt", "pt", "oz", "cubiccm", "cubicin", "cubicft", "cubicm", "galUK", "ozUK"};
    String[] timeElements = new String[]{"sec", "min", "hr", "day", "year", "week"};
    String[] tempElements = new String[]{"degC", "degF", "degK"};
    String[] massElements = new String[]{"g", "kg", "lb", "ton", "mton"};
    String[] speedElements = new String[]{"ftps", "mps", "miphr", "kmphr", "knot"};

    public ParseConnectHeaders(String string) {
        System.out.println("Pattern=" + this.SECONDBYTE_PATTERN.pattern());
        try {
            File file = new File(string);
            file.mkdirs();
            File file2 = new File(file, "com" + File.separator + "ti" + File.separator + "eps" + File.separator + "calc" + File.separator + "ti73" + File.separator);
            file2.mkdirs();
            this.parseTokenH(file2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void parseTokenH(File file) throws IOException {
        File file2 = new File(file, "NewTi73Tok2STok.java");
        PrintStream printStream = new PrintStream(new FileOutputStream(file2, false));
        printStream.println("/* Automatically parsed from a TI Connect header file called");
        printStream.println(" * Token.h by ParseConnectHeaders.java");
        printStream.println(" */");
        printStream.println();
        printStream.println("package com.ti.eps.calc.ti73;");
        printStream.println();
        printStream.println("import com.ti.eps.calc.z80.Ti83STokenOffsets;");
        printStream.println();
        printStream.println("public class NewTi73Tok2STok");
        printStream.println("{");
        InputStream inputStream = this.getClass().getResourceAsStream("Token.h");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            String string3;
            String string4;
            Matcher matcher = this.SECONDBYTE_PATTERN.matcher(string);
            if (matcher.find()) {
                string4 = matcher.group(1);
                string3 = matcher.group(2).toLowerCase();
                String string5 = matcher.group(3).toLowerCase();
                string2 = string5.substring(1) + "Tokens";
                if (!arrayList.contains(string2)) {
                    if (!arrayList.isEmpty()) {
                        printStream.println("    };");
                    }
                    arrayList.add(string2);
                    printStream.println("    static final int[] " + string2 + " = new int[256];");
                    printStream.println("    static {");
                }
                printStream.println("        // " + string);
                printStream.println("        " + string2 + "[" + string3 + "] =  Ti83STokenOffsets." + this.findSTokRef(string4) + ";");
                continue;
            }
            matcher = this.PRIMEDECL_PATTERN.matcher(string);
            if (matcher.find()) {
                int n2;
                printStream.println("    };");
                printStream.println();
                arrayList.add("xf8Tokens");
                this.printGroup(printStream, "xf8Tokens", this.lengthElements);
                arrayList.add("xf9Tokens");
                this.printGroup(printStream, "xf9Tokens", this.areaElements);
                arrayList.add("xfaTokens");
                this.printGroup(printStream, "xfaTokens", this.volumeElements);
                arrayList.add("xfbTokens");
                this.printGroup(printStream, "xfbTokens", this.timeElements);
                arrayList.add("xfcTokens");
                this.printGroup(printStream, "xfcTokens", this.tempElements);
                arrayList.add("xfdTokens");
                this.printGroup(printStream, "xfdTokens", this.massElements);
                arrayList.add("xfeTokens");
                this.printGroup(printStream, "xfeTokens", this.speedElements);
                printStream.println();
                printStream.println("    private static int i = 0;");
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    printStream.println("    static final int " + (String)arrayList.get(n2) + "Index = ++i;");
                }
                printStream.println("    static final int[][] secondByte = new int[i + 1][];");
                printStream.println("    static {");
                printStream.println("        secondByte[0] = new int[0];");
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    printStream.println("        secondByte[" + (String)arrayList.get(n2) + "Index] = " + (String)arrayList.get(n2) + ";");
                }
                printStream.println("    }");
                printStream.println();
                printStream.println("    static final int[] tokens = new int[256];");
                printStream.println("    static {");
                continue;
            }
            matcher = this.PRIME_PATTERN.matcher(string);
            if (matcher.find()) {
                string4 = "Ti83STokenOffsets." + this.findSTokRef(matcher.group(1));
                string3 = Integer.toHexString(n++);
                for (int i = 0; i < arrayList.size(); ++i) {
                    string2 = (String)arrayList.get(i);
                    if (!string3.equals(string2.substring(1, 3))) continue;
                    string4 = "-" + string2 + "Index";
                }
                printStream.println("        // " + string);
                printStream.println("        tokens[" + (string3.length() == 1 ? "0x000" : "0x00") + string3 + "] = " + string4 + ";");
                continue;
            }
            printStream.println("    // " + string);
        }
        printStream.println("    }");
        printStream.println();
        printStream.println("/*");
        int n3 = 689;
        n3 = this.printGroupTokenOffsets(printStream, n3, "xf8Tokens", this.lengthElements);
        n3 = this.printGroupTokenOffsets(printStream, n3, "xf9Tokens", this.areaElements);
        n3 = this.printGroupTokenOffsets(printStream, n3, "xfaTokens", this.volumeElements);
        n3 = this.printGroupTokenOffsets(printStream, n3, "xfbTokens", this.timeElements);
        n3 = this.printGroupTokenOffsets(printStream, n3, "xfcTokens", this.tempElements);
        n3 = this.printGroupTokenOffsets(printStream, n3, "xfdTokens", this.massElements);
        n3 = this.printGroupTokenOffsets(printStream, n3, "xfeTokens", this.speedElements);
        printStream.println();
        printStream.println();
        this.printGroupSTok(printStream, this.lengthElements);
        this.printGroupSTok(printStream, this.areaElements);
        this.printGroupSTok(printStream, this.volumeElements);
        this.printGroupSTok(printStream, this.timeElements);
        this.printGroupSTok(printStream, this.tempElements);
        this.printGroupSTok(printStream, this.massElements);
        this.printGroupSTok(printStream, this.speedElements);
        printStream.println("*/");
        printStream.println("}");
        printStream.close();
        bufferedReader.close();
    }

    private void printGroup(PrintStream printStream, String string, String[] stringArray) {
        int n = (stringArray.length << 4 | stringArray.length & 0xF) + 1;
        printStream.println("    static final int[] " + string + " = new int[" + n + "];");
        printStream.println("    static {");
        printStream.println("        " + string + "[0x00] = Ti83STokenOffsets.STINVALID;");
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                int n2 = i + 1 << 4 | j + 1 & 0xF;
                String string2 = "ST" + stringArray[i] + "2" + stringArray[j];
                string2 = string2.toUpperCase();
                String string3 = Integer.toHexString(n2);
                printStream.println("        " + string + "[" + (string3.length() == 1 ? "0x0" : "0x") + string3 + "] =  Ti83STokenOffsets." + string2 + ";");
            }
        }
        printStream.println("    }");
        printStream.println();
    }

    private int printGroupTokenOffsets(PrintStream printStream, int n, String string, String[] stringArray) {
        printStream.println("  // " + string);
        for (String string2 : stringArray) {
            for (String string3 : stringArray) {
                String string4 = "ST" + string2 + "2" + string3;
                string4 = string4.toUpperCase();
                printStream.println(" public static final int " + string4 + " = " + n++ + ";");
            }
        }
        printStream.println();
        return n;
    }

    private void printGroupSTok(PrintStream printStream, String[] stringArray) {
        for (String string : stringArray) {
            for (String string2 : stringArray) {
                String string3 = "ST" + string + "2" + string2;
                string3 = string3.toUpperCase();
                String string4 = this.mangleConversionName(string);
                String string5 = this.mangleConversionName(string2);
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < Math.max(10 - string3.length(), 0); ++i) {
                    stringBuffer.append(" ");
                }
                printStream.println("   stokens[Ti83STokenOffsets." + string3 + "] = " + stringBuffer + string4 + "+fontTable[Ti83LFont.LCONVERT]+" + string5 + ";");
            }
        }
        printStream.println();
    }

    private String mangleConversionName(String string) {
        if (string.startsWith("sq")) {
            return "\"" + string.substring(2) + "\"+fontTable[Ti83LFont.LSQUARE]";
        }
        if (string.startsWith("cubic")) {
            return "\"" + string.substring(5) + "\"+fontTable[Ti83LFont.LCUBE]";
        }
        if (string.endsWith("ps")) {
            return "\"" + string.substring(0, string.length() - 2) + "/s\"";
        }
        return "\"" + string + "\"";
    }

    public String findSTokRef(String string) {
        Object object;
        int n;
        String[] stringArray;
        if ("".equals(string)) {
            return "STINVALID";
        }
        if ("\\x0D\\x0A".equals(string)) {
            return "STENTER";
        }
        while ((stringArray = this.ESC_PATTERN.matcher(string)).find()) {
            n = Integer.parseInt(stringArray.group(1), 16);
            object = Z80SmallFontToAscii.table[n];
            System.out.println("Found one " + stringArray.group(0) + " = " + n + " = " + (String)object);
            string = stringArray.replaceFirst((String)object);
        }
        if ("\\x22".equals(string)) {
            string = "\"";
        }
        stringArray = Z80STokensAscii.stokens;
        for (n = 0; n < stringArray.length; ++n) {
            Field[] fieldArray;
            if (!string.equals(stringArray[n])) continue;
            object = Z80STokenOffsets.class;
            for (Field field : fieldArray = ((Class)object).getFields()) {
                try {
                    if (field.getInt(object) != n) continue;
                    return field.getName();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
        }
        return "STINVALID /* TODO */";
    }

    public static void main(String[] stringArray) {
        new ParseConnectHeaders(stringArray[0]);
    }
}

