/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.nspire;

import com.ti.eps.calc.dbus.FontString;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class TiNspireFontString
extends FontString {
    private static final String NSPIRE_CHARSET = "UTF-8";

    private static byte[] getUTF8Bytes(String string) {
        try {
            return string.getBytes(NSPIRE_CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new byte[0];
        }
    }

    public TiNspireFontString(byte[] byArray) {
        super(byArray);
    }

    public TiNspireFontString(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    public TiNspireFontString(String string) {
        super(ByteBuffer.wrap(TiNspireFontString.getUTF8Bytes(string)));
    }

    @Override
    public String toAscii() {
        try {
            return new String(this.fontBuffer.array(), this.fontBuffer.position(), this.fontBuffer.remaining(), NSPIRE_CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    @Override
    public String toAsciiSC() {
        return this.toAscii();
    }

    @Override
    public String toHtml() {
        return this.toAscii();
    }

    @Override
    public String toStringSC() {
        return this.toAscii();
    }
}

