/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.math;

public class Fraction {
    private static final int MAX_NUM_FRAC_LOOPS = 20;
    private static final int MAX_DENOM = 10000;
    private final long numerator;
    private final long denominator;

    private Fraction(long l, long l2) {
        this.numerator = l2 < 0L ? -l : l;
        this.denominator = Math.abs(l2);
    }

    public long getNumerator() {
        return this.numerator;
    }

    public long getDenominator() {
        return this.denominator;
    }

    public static Fraction createFraction(long l, long l2) {
        if (l2 == 0L) {
            throw new IllegalArgumentException("0 denominator not allowed");
        }
        long l3 = Fraction.getGCD(Math.abs(l), l2);
        return new Fraction(l / l3, l2 / l3);
    }

    public static Fraction createFraction(double d) throws IllegalArgumentException {
        double d2;
        double d3 = Math.abs(d);
        if (d3 > 9.223372036854776E18) {
            throw new IllegalArgumentException("The magnitude can only go up to the max long");
        }
        if (Double.isNaN(d3)) {
            throw new IllegalArgumentException("Can't convert NaN to fraction");
        }
        long l = (long)d3;
        d3 -= (double)l;
        long l2 = 0L;
        long l3 = 1L;
        long l4 = 1L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = (long)d3;
        long l9 = 0L;
        double d4 = 1.0;
        double d5 = 0.0;
        double d6 = d3 - (double)l8;
        double d7 = 0.0;
        double d8 = Double.MAX_VALUE;
        long l10 = 0L;
        do {
            d2 = d8;
            l9 = (long)(d4 / d6);
            d5 = d6;
            d7 = d4 - (double)l9 * d6;
            l6 = l8 * l4 + l2;
            l7 = l8 * l5 + l3;
            double d9 = (double)l6 / (double)l7;
            d8 = Math.abs(d3 - d9);
            l8 = l9;
            d4 = d5;
            d6 = d7;
            l2 = l4;
            l3 = l5;
            l4 = l6;
            l5 = l7;
            if (++l10 != 20L) continue;
            throw new IllegalArgumentException("Too many loops in computing the fraction");
        } while (d2 > d8 && l7 <= 10000L && l7 > 0L);
        long l11 = d < 0.0 ? -1L : 1L;
        return Fraction.createFraction(l11 * (l2 + l * l3), l3);
    }

    public static long getGCD(long l, long l2) {
        long l3 = l % l2;
        while (l3 != 0L) {
            l = l2;
            l2 = l3;
            l3 = l % l2;
        }
        return l2;
    }

    public static long getLCM(long l, long l2) {
        long l3 = Fraction.getGCD(l, l2);
        return l * l2 / l3;
    }
}

