/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.java.math.equation;

import com.ti.eps.calc.java.math.equation.ASTAbs;
import com.ti.eps.calc.java.math.equation.ASTAcos;
import com.ti.eps.calc.java.math.equation.ASTAcosh;
import com.ti.eps.calc.java.math.equation.ASTAdd;
import com.ti.eps.calc.java.math.equation.ASTAsin;
import com.ti.eps.calc.java.math.equation.ASTAsinh;
import com.ti.eps.calc.java.math.equation.ASTAtan;
import com.ti.eps.calc.java.math.equation.ASTAtanh;
import com.ti.eps.calc.java.math.equation.ASTCos;
import com.ti.eps.calc.java.math.equation.ASTCosh;
import com.ti.eps.calc.java.math.equation.ASTDiv;
import com.ti.eps.calc.java.math.equation.ASTExp;
import com.ti.eps.calc.java.math.equation.ASTFraction;
import com.ti.eps.calc.java.math.equation.ASTIdentifier;
import com.ti.eps.calc.java.math.equation.ASTInt;
import com.ti.eps.calc.java.math.equation.ASTLog;
import com.ti.eps.calc.java.math.equation.ASTMult;
import com.ti.eps.calc.java.math.equation.ASTNaturalLog;
import com.ti.eps.calc.java.math.equation.ASTNegative;
import com.ti.eps.calc.java.math.equation.ASTNumber;
import com.ti.eps.calc.java.math.equation.ASTPI;
import com.ti.eps.calc.java.math.equation.ASTParenExpression;
import com.ti.eps.calc.java.math.equation.ASTPower;
import com.ti.eps.calc.java.math.equation.ASTRand;
import com.ti.eps.calc.java.math.equation.ASTSin;
import com.ti.eps.calc.java.math.equation.ASTSinh;
import com.ti.eps.calc.java.math.equation.ASTSqrt;
import com.ti.eps.calc.java.math.equation.ASTStart;
import com.ti.eps.calc.java.math.equation.ASTSubtract;
import com.ti.eps.calc.java.math.equation.ASTTan;
import com.ti.eps.calc.java.math.equation.ASTTanh;
import com.ti.eps.calc.java.math.equation.ASTe;
import com.ti.eps.calc.java.math.equation.EquationParserVisitor;
import com.ti.eps.calc.java.math.equation.ImplicitlyCloseableNode;
import com.ti.eps.calc.java.math.equation.SimpleNode;
import java.util.Hashtable;
import java.util.Map;

public class EquationTextVisitor
implements EquationParserVisitor {
    private static final int VISIT_TYPE_PARENT = 0;
    private static final int VISIT_TYPE_PARENT_CHILD = 1;
    private static final int VISIT_TYPE_CHILD_PARENT_CHILD = 2;
    private static final String TOK_SIN = "sin(";
    private static final String TOK_COS = "cos(";
    private static final String TOK_TAN = "tan(";
    private static final String TOK_ASIN = "Arcsin(";
    private static final String TOK_ACOS = "Arccos(";
    private static final String TOK_ATAN = "Arctan(";
    private static final String TOK_SINH = "sinh(";
    private static final String TOK_COSH = "cosh(";
    private static final String TOK_TANH = "tanh(";
    private static final String TOK_ASINH = "Arcsinh(";
    private static final String TOK_ACOSH = "Arccosh(";
    private static final String TOK_ATANH = "Arctanh(";
    private static final String TOK_ADD = "+";
    private static final String TOK_SUB = "-";
    private static final String TOK_MUL = "*";
    private static final String TOK_IMPLICIT_MUL = "";
    private static final String TOK_DIV = "/";
    private static final String TOK_SQRT = "sqrt(";
    private static final String TOK_ABS = "abs(";
    private static final String TOK_INT = "int(";
    private static final String TOK_NATURAL_LOG = "ln(";
    private static final String TOK_EXP = "exp(";
    private static final String TOK_LOG = "log(";
    private static final String TOK_POWER = "^";
    private static final String TOK_NEGATIVE = "-";
    private static final String TOK_RAND = "rand";
    private static final String TOK_PI = "PI";
    private static final String TOK_E = "e";
    private static final String TOK_LPAREN = "(";
    private static final String TOK_RPAREN = ")";
    private static final String TOK_UNIT = "\u2423";
    private static final String TOK_FRACTION = "\uf01e";
    private Map<String, ? extends Number> symtab = new Hashtable<String, Number>();

    private Number getValue(String string) {
        return this.symtab.get(string);
    }

    public void setSymbolTable(Map<String, ? extends Number> map) {
        this.symtab = map;
    }

    @Override
    public Object visit(SimpleNode simpleNode, Object object) {
        System.out.println(simpleNode + ": acceptor not implemented in subclass?");
        return object;
    }

    @Override
    public Object visit(ASTStart aSTStart, Object object) {
        object = new StringBuffer();
        if (aSTStart.jjtGetNumChildren() > 0) {
            object = aSTStart.jjtGetChild(0).jjtAccept(this, object);
        }
        return object;
    }

    @Override
    public Object visit(ASTAdd aSTAdd, Object object) {
        return this.visit(aSTAdd, object, (Object)TOK_ADD, 2);
    }

    @Override
    public Object visit(ASTSubtract aSTSubtract, Object object) {
        return this.visit(aSTSubtract, object, (Object)"-", 2);
    }

    @Override
    public Object visit(ASTMult aSTMult, Object object) {
        if (aSTMult.isImplicitMultiplication()) {
            return this.visit(aSTMult, object, (Object)TOK_IMPLICIT_MUL, 2);
        }
        return this.visit(aSTMult, object, (Object)TOK_MUL, 2);
    }

    @Override
    public Object visit(ASTDiv aSTDiv, Object object) {
        return this.visit(aSTDiv, object, (Object)TOK_DIV, 2);
    }

    @Override
    public Object visit(ASTIdentifier aSTIdentifier, Object object) {
        Object object2 = aSTIdentifier.getName();
        if (this.symtab.containsKey(object2)) {
            object2 = this.getValue((String)object2);
        }
        return this.visit(aSTIdentifier, object, object2, 0);
    }

    @Override
    public Object visit(ASTNumber aSTNumber, Object object) {
        return this.visit(aSTNumber, object, (Object)aSTNumber.getValAsString(), 0);
    }

    @Override
    public Object visit(ASTSin aSTSin, Object object) {
        return this.visit(aSTSin, object, (Object)TOK_SIN, 1);
    }

    @Override
    public Object visit(ASTCos aSTCos, Object object) {
        return this.visit(aSTCos, object, (Object)TOK_COS, 1);
    }

    @Override
    public Object visit(ASTTan aSTTan, Object object) {
        return this.visit(aSTTan, object, (Object)TOK_TAN, 1);
    }

    @Override
    public Object visit(ASTAsin aSTAsin, Object object) {
        return this.visit(aSTAsin, object, (Object)TOK_ASIN, 1);
    }

    @Override
    public Object visit(ASTAcos aSTAcos, Object object) {
        return this.visit(aSTAcos, object, (Object)TOK_ACOS, 1);
    }

    @Override
    public Object visit(ASTAtan aSTAtan, Object object) {
        return this.visit(aSTAtan, object, (Object)TOK_ATAN, 1);
    }

    @Override
    public Object visit(ASTSinh aSTSinh, Object object) {
        return this.visit(aSTSinh, object, (Object)TOK_SINH, 1);
    }

    @Override
    public Object visit(ASTCosh aSTCosh, Object object) {
        return this.visit(aSTCosh, object, (Object)TOK_COSH, 1);
    }

    @Override
    public Object visit(ASTTanh aSTTanh, Object object) {
        return this.visit(aSTTanh, object, (Object)TOK_TANH, 1);
    }

    @Override
    public Object visit(ASTAsinh aSTAsinh, Object object) {
        return this.visit(aSTAsinh, object, (Object)TOK_ASINH, 1);
    }

    @Override
    public Object visit(ASTAcosh aSTAcosh, Object object) {
        return this.visit(aSTAcosh, object, (Object)TOK_ACOSH, 1);
    }

    @Override
    public Object visit(ASTAtanh aSTAtanh, Object object) {
        return this.visit(aSTAtanh, object, (Object)TOK_ATANH, 1);
    }

    @Override
    public Object visit(ASTSqrt aSTSqrt, Object object) {
        return this.visit(aSTSqrt, object, (Object)TOK_SQRT, 1);
    }

    @Override
    public Object visit(ASTAbs aSTAbs, Object object) {
        return this.visit(aSTAbs, object, (Object)TOK_ABS, 1);
    }

    @Override
    public Object visit(ASTInt aSTInt, Object object) {
        return this.visit(aSTInt, object, (Object)TOK_INT, 1);
    }

    @Override
    public Object visit(ASTNaturalLog aSTNaturalLog, Object object) {
        return this.visit(aSTNaturalLog, object, (Object)TOK_NATURAL_LOG, 1);
    }

    @Override
    public Object visit(ASTExp aSTExp, Object object) {
        return this.visit(aSTExp, object, (Object)TOK_EXP, 1);
    }

    @Override
    public Object visit(ASTLog aSTLog, Object object) {
        return this.visit(aSTLog, object, (Object)TOK_LOG, 1);
    }

    @Override
    public Object visit(ASTPower aSTPower, Object object) {
        return this.visit(aSTPower, object, (Object)TOK_POWER, 2);
    }

    @Override
    public Object visit(ASTNegative aSTNegative, Object object) {
        return this.visit(aSTNegative, object, (Object)"-", 1);
    }

    @Override
    public Object visit(ASTRand aSTRand, Object object) {
        return this.visit(aSTRand, object, (Object)TOK_RAND, 0);
    }

    @Override
    public Object visit(ASTPI aSTPI, Object object) {
        return this.visit(aSTPI, object, (Object)TOK_PI, 0);
    }

    @Override
    public Object visit(ASTe aSTe, Object object) {
        return this.visit(aSTe, object, (Object)TOK_E, 0);
    }

    @Override
    public Object visit(ASTParenExpression aSTParenExpression, Object object) {
        StringBuffer stringBuffer = (StringBuffer)object;
        stringBuffer.append(TOK_LPAREN);
        aSTParenExpression.jjtGetChild(0).jjtAccept(this, object);
        stringBuffer.append(TOK_RPAREN);
        return stringBuffer;
    }

    @Override
    public Object visit(ASTFraction aSTFraction, Object object) {
        StringBuffer stringBuffer = (StringBuffer)object;
        int n = 0;
        aSTFraction.jjtGetChild(n++).jjtAccept(this, object);
        if (aSTFraction.jjtGetNumChildren() == 3) {
            stringBuffer.append(TOK_UNIT);
            aSTFraction.jjtGetChild(n++).jjtAccept(this, object);
        }
        stringBuffer.append(TOK_FRACTION);
        aSTFraction.jjtGetChild(n++).jjtAccept(this, object);
        return stringBuffer;
    }

    private Object visit(SimpleNode simpleNode, Object object, Object object2, int n) {
        StringBuffer stringBuffer = (StringBuffer)object;
        if (n == 0) {
            stringBuffer.append(object2);
        } else if (n == 1) {
            stringBuffer.append(object2);
            simpleNode.jjtGetChild(0).jjtAccept(this, object);
        } else if (n == 2) {
            simpleNode.jjtGetChild(0).jjtAccept(this, object);
            stringBuffer.append(object2);
            simpleNode.jjtGetChild(1).jjtAccept(this, object);
        }
        return stringBuffer;
    }

    private Object visit(ImplicitlyCloseableNode implicitlyCloseableNode, Object object, Object object2, int n) {
        this.visit((SimpleNode)implicitlyCloseableNode, object, object2, n);
        StringBuffer stringBuffer = (StringBuffer)object;
        if (implicitlyCloseableNode.isExplicitCloseParen()) {
            stringBuffer.append(TOK_RPAREN);
        }
        return stringBuffer;
    }
}

