/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.java.math.equation;

import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.java.math.equation.ASTStart;
import com.ti.eps.calc.java.math.equation.EquationDumpVisitor;
import com.ti.eps.calc.java.math.equation.EquationEvaluateVisitor;
import com.ti.eps.calc.java.math.equation.EquationFractionTextVisitor;
import com.ti.eps.calc.java.math.equation.EquationParser;
import com.ti.eps.calc.java.math.equation.EquationParserVisitor;
import com.ti.eps.calc.java.math.equation.EquationTI73TokenizerVisitor;
import com.ti.eps.calc.java.math.equation.EquationTI83PlusTokenizerVisitor;
import com.ti.eps.calc.java.math.equation.EquationTextVisitor;
import com.ti.eps.calc.java.math.equation.ParseException;
import com.ti.eps.calc.java.math.equation.TokenMgrError;
import com.ti.eps.calc.math.MathContext;
import com.ti.eps.calc.math.MathNumber;
import com.ti.eps.calc.math.equation.EquationHandler;
import com.ti.eps.calc.math.equation.FractionEquationIterator;
import com.ti.eps.calc.math.equation.ResultData;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.logging.Logger;

public class Equation
extends EquationHandler {
    private static final Logger logger = Logger.getLogger(Equation.class.getName());
    protected String errorString;
    protected EquationParser parser;
    protected ASTStart startNode;
    protected EquationEvaluateVisitor evaluateVisitor;
    protected EquationDumpVisitor dumpVisitor;
    protected EquationTextVisitor textVisitor;
    protected EquationFractionTextVisitor fractionVisitor;
    protected Object equation = new String();
    protected EquationTI83PlusTokenizerVisitor ti83PlusVisitor;
    protected byte[] ti83PlusTokens = null;
    protected EquationTI73TokenizerVisitor ti73Visitor;
    protected byte[] ti73Tokens = null;
    private String stringVal;

    public Equation(Reader reader) {
        this.parseEquation(reader);
    }

    public Equation(String string) {
        this(new StringReader(string));
    }

    protected Equation() {
    }

    private void parseEquation(Reader reader) {
        try {
            this.parser = new EquationParser(reader);
            this.startNode = this.parser.start();
            this.evaluateVisitor = new EquationEvaluateVisitor();
            this.dumpVisitor = new EquationDumpVisitor();
            this.textVisitor = new EquationTextVisitor();
            this.fractionVisitor = new EquationFractionTextVisitor();
            this.equation = this.startNode.jjtAccept(this.textVisitor, null);
            this.parseError = false;
            this.checkFracinFrac();
        }
        catch (ParseException parseException) {
            this.parseError = !this.isEmpty();
            this.errorString = parseException.getLocalizedMessage();
        }
        catch (TokenMgrError tokenMgrError) {
            this.parseError = !this.isEmpty();
            this.errorChar = this.parser.token_source.curChar;
            this.errorIndex = this.parser.token.endColumn;
            this.errorString = tokenMgrError.getLocalizedMessage();
        }
    }

    private void checkFracinFrac() {
        if (this.isEmpty()) {
            return;
        }
        FractionEquationIterator fractionEquationIterator = this.fractionIterator();
        String string = fractionEquationIterator.getEquation();
        int n = 0;
        while ((n = string.indexOf("<fraction>", n)) != -1) {
            int n2 = string.indexOf("</fraction>", ++n);
            int n3 = string.indexOf("<fraction>", n);
            if (n3 == -1) continue;
            if (n2 == -1 || n3 < n2) {
                string = this.getAsString();
                this.parseError = true;
                this.errorChar = (char)47;
                this.errorIndex = string.indexOf(61470, string.indexOf(61470) + 1);
                continue;
            }
            n = n3;
        }
    }

    @Override
    public boolean isValid() {
        return this.isEmpty() || !this.parseError;
    }

    @Override
    public boolean isEmpty() {
        return this.startNode != null && this.startNode.isEmpty();
    }

    @Override
    public String getAsString() {
        if (this.stringVal != null) {
            return this.stringVal;
        }
        if (this.isEmpty()) {
            return "";
        }
        if (!this.isValid()) {
            return this.errorString;
        }
        this.stringVal = this.equation.toString();
        return this.stringVal;
    }

    @Override
    public FractionEquationIterator fractionIterator() {
        try {
            String string = this.startNode.jjtAccept(this.fractionVisitor, null).toString();
            return new FractionEquationIterator(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public byte[] getAsNative(DBUSDeviceCode dBUSDeviceCode) throws IllegalArgumentException {
        if (dBUSDeviceCode.equals(DBUSDeviceCode.UNIT_83) || dBUSDeviceCode.equals(DBUSDeviceCode.UNIT_83PLUS)) {
            return this.nativeVisit(dBUSDeviceCode, new EquationTI83PlusTokenizerVisitor());
        }
        if (dBUSDeviceCode.equals(DBUSDeviceCode.UNIT_73)) {
            return this.nativeVisit(dBUSDeviceCode, new EquationTI73TokenizerVisitor());
        }
        throw new IllegalArgumentException("Unsupported device type " + dBUSDeviceCode);
    }

    public byte[] nativeVisit(DBUSDeviceCode dBUSDeviceCode, EquationParserVisitor equationParserVisitor) throws IllegalArgumentException {
        if (dBUSDeviceCode.equals(DBUSDeviceCode.UNIT_83) || dBUSDeviceCode.equals(DBUSDeviceCode.UNIT_83PLUS)) {
            if (this.ti83PlusTokens == null) {
                this.ti83PlusVisitor = (EquationTI83PlusTokenizerVisitor)equationParserVisitor;
                this.ti83PlusTokens = this.toBytes(this.startNode.jjtAccept(this.ti83PlusVisitor, null).toString());
            }
            return this.ti83PlusTokens;
        }
        if (dBUSDeviceCode.equals(DBUSDeviceCode.UNIT_73)) {
            if (this.ti73Tokens == null) {
                this.ti73Visitor = (EquationTI73TokenizerVisitor)equationParserVisitor;
                this.ti73Tokens = this.toBytes(this.startNode.jjtAccept(this.ti73Visitor, null).toString());
            }
            return this.ti73Tokens;
        }
        throw new IllegalArgumentException("Unsupported device type " + dBUSDeviceCode);
    }

    @Override
    public Number evaluate(Map<String, Object> map, MathContext mathContext) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Equation is empty");
        }
        if (!this.isValid()) {
            throw new IllegalStateException("Equation was not recognized " + this.getAsString());
        }
        this.evaluateVisitor.setSymbolTable(map);
        this.evaluateVisitor.setMathContext(mathContext);
        this.stringVal = null;
        ResultData resultData = (ResultData)this.startNode.jjtAccept(this.evaluateVisitor, null);
        Object object = resultData.result;
        this.isContinuous = resultData.isContinuous;
        if (object instanceof Number) {
            MathNumber mathNumber;
            object = mathContext.getMathEngine().finishEvaluation((Number)object, mathContext);
            if (object instanceof Double) {
                Double d = (Double)object;
                if (d.isInfinite() || d.isNaN()) {
                    this.isContinuous = Boolean.FALSE;
                }
            } else if (object instanceof MathNumber && ((mathNumber = (MathNumber)object).isInfinite() || mathNumber.isNaN())) {
                this.isContinuous = Boolean.FALSE;
            }
            return (Number)object;
        }
        return new Double(object.toString());
    }
}

