/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.java.math;

import com.ti.eps.calc.java.math.JavaMathContext;
import com.ti.eps.calc.math.DefaultNumberFormatter;
import com.ti.eps.calc.math.MathContext;
import com.ti.eps.calc.math.MathNumber;
import javax.swing.text.NumberFormatter;

public class DoubleMathNumber
extends MathNumber {
    private static final long serialVersionUID = 1L;
    private static final char UNI_FRAC_CHAR = '\uf01e';
    private static final char UNI_UNIT_CHAR = '\u2423';
    private static NumberFormatter defaultNumberFormatter = new DefaultNumberFormatter(Double.class);
    public static final DoubleMathNumber ZERO = new DoubleMathNumber(0.0);
    private Double dNumber;

    public DoubleMathNumber(String string) {
        if (string.equals("NaN")) {
            this.dNumber = new Double(Double.NaN);
        } else if (string.indexOf(61470) > 0 || string.indexOf(47) > 0) {
            this.parseFractionString(string);
        } else {
            this.dNumber = new Double(string);
        }
    }

    public DoubleMathNumber(double d) {
        this.dNumber = new Double(d);
    }

    @Override
    public NumberFormatter getNumberFormatter() {
        return defaultNumberFormatter;
    }

    @Override
    public int intValue() {
        return this.dNumber.intValue();
    }

    @Override
    public long longValue() {
        return this.dNumber.longValue();
    }

    @Override
    public float floatValue() {
        return this.dNumber.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.dNumber;
    }

    @Override
    public byte byteValue() {
        return this.dNumber.byteValue();
    }

    @Override
    public short shortValue() {
        return this.dNumber.shortValue();
    }

    @Override
    public boolean isNaN() {
        return this.dNumber.isNaN();
    }

    @Override
    public boolean isInfinite() {
        return this.dNumber.isInfinite();
    }

    public String toString() {
        return this.dNumber.toString();
    }

    public int hashCode() {
        return this.dNumber.hashCode();
    }

    private void parseFractionString(String string) {
        String string2 = "/";
        String string3 = " ";
        if (string.indexOf(61470) > 0) {
            string2 = new String(new char[]{'\uf01e'});
            string3 = new String(new char[]{'\u2423'});
        }
        MathContext mathContext = JavaMathContext.getInstance();
        try {
            Double d;
            Object object;
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String[] stringArray = string.split(string2);
            if (stringArray.length != 2) {
                throw new IllegalArgumentException("NaN");
            }
            double d2 = 1.0;
            if (stringArray[0].indexOf(string3) > 0) {
                object = stringArray[0].split(string3);
                if (((String[])object).length != 2) {
                    throw new IllegalArgumentException("NaN");
                }
                string4 = object[0];
                string5 = object[1];
                d = new Double(string4);
                if (!mathContext.isInErrorTolerance(d, d.intValue())) {
                    throw new RuntimeException("Only integer units are allowed");
                }
            } else {
                string5 = stringArray[0];
                d = new Double("0");
            }
            string6 = stringArray[1];
            object = new DoubleMathNumber(string5);
            DoubleMathNumber doubleMathNumber = new DoubleMathNumber(string6);
            d2 = this.sign(d, (Number)object, doubleMathNumber);
            if (d < 0.0) {
                d = new Double(Math.abs(d));
            }
            Number number = mathContext.getMathEngine().abs(mathContext.getMathEngine().divide((Number)object, doubleMathNumber, mathContext), mathContext);
            Number number2 = mathContext.getMathEngine().add(d, number, mathContext);
            if (d2 < 0.0) {
                number2 = mathContext.getMathEngine().mult(d2, number2, mathContext);
            }
            this.dNumber = new Double(number2.doubleValue());
        }
        catch (Throwable throwable) {
            this.dNumber = new Double(Double.NaN);
        }
    }

    private double sign(Number number, Number number2, Number number3) {
        double d = number.doubleValue();
        double d2 = number2.doubleValue();
        double d3 = number3.doubleValue();
        if (d == 0.0) {
            return Math.signum(d2) * Math.signum(d3);
        }
        double d4 = Math.signum(d2) * Math.signum(d3);
        if (d4 == 0.0) {
            d4 = 1.0;
        }
        return Math.signum(d) * d4;
    }
}

