/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.dbus;

import com.ti.eps.calc.dbus.DBUSDataType;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.DBUSDeviceHandler;
import com.ti.eps.calc.dbus.DBUSDeviceRegistry;
import com.ti.eps.calc.dbus.DeviceString;
import com.ti.eps.calc.dbus.FlashFileSlot;
import com.ti.eps.calc.dbus.exceptions.InputFlashFileFormatException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class FlashFile {
    private static final int INTEL_HEX_START_LEN = 1;
    private static final int INTEL_HEX_CHECKSUM_LEN = 2;
    private static final int INTEL_HEX_HEADER_LEN = 8;
    private static final int INTEL_HEX_DATA_POS = 9;
    private static final int INTEL_HEX_TYPE_POS = 7;
    private static final int INTEL_HEX_ADDRESS_POS = 3;
    private static final int INTEL_HEX_BYTE_COUNT_POS = 1;
    private static final int MIN_HEX_RECORD_LEN = 11;
    private static final Logger LOGGER = Logger.getLogger("FlashAppFile");
    private static final byte[] VALID_HEADER = new byte[]{42, 42, 84, 73, 70, 76, 42, 42};
    private static final int REV_NUM_POS = 8;
    private static final int FORMAT_FLAG_POS = 10;
    private static final int NAME_LEN_POS = 16;
    private static final int NAME_POS = 17;
    private static final int DEVICE_TYPE_PAIR_POS = 48;
    private static final int GL_HEADER_LEN = 78;
    static final int SLOTSIZE = 16384;
    public static final byte PRE_DATA_SLOT = -128;
    public static final byte POST_DATA_SLOT = 127;
    private static final byte CERT_FIELD_MAJOR = 2;
    private static final byte CERT_FIELD_MINOR = 3;
    private static final byte CERT_FIELD_NAME = 4;
    static final byte[] HEX_TABLE = new byte[128];
    private ByteBuffer headerBuffer;
    private List<FlashFileSlot> slots = new ArrayList<FlashFileSlot>(1);
    private DeviceString name;

    FlashFile() {
    }

    public FlashFile(DeviceString deviceString, List<FlashFileSlot> list) {
        this.name = deviceString;
        this.slots.addAll(list);
    }

    public FlashFile(File file) throws FileNotFoundException, InputFlashFileFormatException, IOException {
        this(new FileInputStream(file));
    }

    public FlashFile(InputStream inputStream) throws InputFlashFileFormatException, IOException {
        this.parseFile(inputStream);
    }

    static final byte parseHexByte(String string, int n) {
        return (byte)(HEX_TABLE[string.charAt(n)] << 4 | HEX_TABLE[string.charAt(n + 1)]);
    }

    private boolean containsSlot(int n) {
        for (int i = 0; i < this.slots.size(); ++i) {
            if (this.slots.get(i).getSlotNum() != n) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseFile(InputStream inputStream) throws InputFlashFileFormatException, IOException {
        block31: {
            try {
                byte[] byArray = new byte[78];
                int n = inputStream.read(byArray);
                if (n != 78) {
                    throw new InputFlashFileFormatException("Incomplete or Invalid GraphLink Header");
                }
                for (int i = 0; i < VALID_HEADER.length; ++i) {
                    if (byArray[i] == VALID_HEADER[i]) continue;
                    throw new InputFlashFileFormatException("GraphLink header is incorrect.");
                }
                this.headerBuffer = ByteBuffer.wrap(byArray);
                if (this.isIntelHexFormat()) {
                    try (BufferedReader bufferedReader = null;){
                        bufferedReader = new LineNumberReader(new InputStreamReader(inputStream));
                        FlashFileSlot flashFileSlot = null;
                        String string = null;
                        int n2 = -1;
                        int n3 = -1;
                        block12: while ((string = ((LineNumberReader)bufferedReader).readLine()) != null) {
                            byte by;
                            if (string.charAt(0) != ':' || string.length() < 11) {
                                if (string.charAt(0) == '\u001a') {
                                    LOGGER.fine("Skipping Convert 0x1A line");
                                    continue;
                                }
                                throw new InputFlashFileFormatException("Invalid Intel-Hex format on line " + ((LineNumberReader)bufferedReader).getLineNumber() + " line.charAt(0) = " + Integer.toHexString(string.charAt(0)));
                            }
                            short s = FlashFile.parseUHexByte(string, 1);
                            int n4 = FlashFile.parseUHexShort(string, 3);
                            short s2 = FlashFile.parseUHexByte(string, 7);
                            byte by2 = FlashFile.parseHexByte(string, 9 + s * 2);
                            int n5 = s * 2 + 8;
                            if (string.length() != n5 + 2 + 1) {
                                if (s2 == 1) {
                                    LOGGER.finest("(non-fatal) Bad IntelHex termination record '" + string + "'");
                                } else {
                                    throw new InputFlashFileFormatException("Intel-Hex line " + (((LineNumberReader)bufferedReader).getLineNumber() - 1) + " is incorrect length");
                                }
                            }
                            if (by2 != (by = FlashFile.calcChecksum(string, (short)1, (short)(n5 / 2)))) {
                                throw new InputFlashFileFormatException("Intel-Hex checksum error on line " + (((LineNumberReader)bufferedReader).getLineNumber() - 1) + " fileChecksum=" + by2 + " calcChecksum=" + by);
                            }
                            switch (s2) {
                                case 2: {
                                    n3 = FlashFile.parseUHexShort(string, 9);
                                    flashFileSlot = new FlashFileSlot((byte)n3);
                                    if (this.containsSlot(n3)) {
                                        throw new InputFlashFileFormatException("Duplicate slot data encountered. Slot = " + n3);
                                    }
                                    this.slots.add(flashFileSlot);
                                    n2 = -1;
                                    continue block12;
                                }
                                case 0: {
                                    if (flashFileSlot == null) {
                                        int n6 = n3 = this.slots.size() == 0 ? -128 : 127;
                                        if (this.containsSlot(n3)) {
                                            throw new IllegalStateException("Duplicate pre/post data section");
                                        }
                                        flashFileSlot = new FlashFileSlot((byte)n3);
                                        this.slots.add(flashFileSlot);
                                        n2 = -1;
                                    }
                                    if (n2 < 0) {
                                        n2 = n4;
                                        flashFileSlot.setStartAddress(n4);
                                    }
                                    if (n4 != n2) {
                                        throw new InputFlashFileFormatException("Expected address of 0x" + Integer.toHexString(n2) + " on line " + (((LineNumberReader)bufferedReader).getLineNumber() - 1));
                                    }
                                    for (short s3 = 0; s3 < s; s3 = (short)(s3 + 1)) {
                                        flashFileSlot.append(FlashFile.parseHexByte(string, 9 + s3 * 2));
                                    }
                                    n2 += s;
                                    continue block12;
                                }
                                case 1: {
                                    flashFileSlot = null;
                                    continue block12;
                                }
                            }
                            throw new InputFlashFileFormatException("Invalid Intel Hex type code " + s2 + " on line " + (((LineNumberReader)bufferedReader).getLineNumber() - 1));
                        }
                    }
                    for (int i = 0; i < this.slots.size(); ++i) {
                        this.slots.get(i).complete();
                    }
                    break block31;
                }
                throw new InputFlashFileFormatException("Binary format FlashApp file aren't currently supported");
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    public DeviceString getDeviceFileName() {
        if (this.name == null) {
            DBUSDeviceCode dBUSDeviceCode = this.getDefaultDeviceCode();
            DBUSDataType dBUSDataType = this.getDefaultDataType();
            DBUSDeviceHandler dBUSDeviceHandler = DBUSDeviceRegistry.getDeviceHandler(dBUSDeviceCode.getValue());
            this.name = dBUSDeviceHandler.newFontString(this.getNameBytes());
            if ("Base Code".equals(dBUSDataType.getName())) {
                if (DBUSDeviceCode.UNIT_73.equals(dBUSDeviceCode)) {
                    this.name = dBUSDeviceHandler.newFontString("73OS");
                } else if (DBUSDeviceCode.UNIT_83PLUS.equals(dBUSDeviceCode)) {
                    this.name = this.getMajorRevision() > 1 ? dBUSDeviceHandler.newFontString("84PlusOS") : dBUSDeviceHandler.newFontString("83PlusOS");
                }
            }
        }
        return this.name;
    }

    public void setDeviceFileName(DeviceString deviceString) {
        this.name = deviceString;
    }

    private byte[] getNameBytes() {
        byte[] byArray;
        ByteBuffer byteBuffer = this.getCertificateField(4);
        if (byteBuffer != null && byteBuffer.remaining() >= 1 && byteBuffer.remaining() <= 8) {
            byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
        } else {
            int n = this.headerBuffer.get(16) & 0xFF;
            byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = this.headerBuffer.get(17 + i);
            }
        }
        return byArray;
    }

    private ByteBuffer getCertificateField(int n) {
        FlashFileSlot flashFileSlot = this.slots.iterator().next();
        ByteBuffer byteBuffer = flashFileSlot.getData();
        try {
            while (true) {
                byte by;
                if (((by = byteBuffer.get()) & 0xFF) != 128) {
                    continue;
                }
                byte by2 = byteBuffer.get();
                byte by3 = (byte)((by2 & 0xF0) >> 4);
                int n2 = by2 & 0xF;
                if ((by3 == 0 || by3 == 7) && n2 == 15) {
                    n2 = 4;
                }
                if (n == by3) {
                    byteBuffer.limit(byteBuffer.position() + n2);
                    return byteBuffer;
                }
                byteBuffer.position(byteBuffer.position() + n2);
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return null;
        }
    }

    public int getMajorRevision() {
        int n = -1;
        ByteBuffer byteBuffer = this.getCertificateField(2);
        if (byteBuffer != null && byteBuffer.remaining() == 1) {
            n = byteBuffer.get();
        }
        if (n < 0) {
            n = this.headerBuffer.get(8);
            n = ((n & 0xF0) >> 4) * 10 + (n & 0xF);
        }
        return n;
    }

    public int getMinorRevision() {
        int n = -1;
        ByteBuffer byteBuffer = this.getCertificateField(3);
        if (byteBuffer != null && byteBuffer.remaining() == 1) {
            n = byteBuffer.get();
        }
        if (n < 0) {
            n = this.headerBuffer.get(9);
            n = ((n & 0xF0) >> 4) * 10 + (n & 0xF);
        }
        return n;
    }

    public int getNumSlots() {
        return this.slots.size();
    }

    public Iterator<FlashFileSlot> getSlotIterator() {
        return this.slots.iterator();
    }

    public ByteBuffer getSlotData(int n) {
        for (int i = 0; i < this.slots.size(); ++i) {
            FlashFileSlot flashFileSlot = this.slots.get(i);
            if (flashFileSlot.getSlotNum() != n) continue;
            return flashFileSlot.getData();
        }
        throw new IllegalArgumentException("slotNum " + n + " not found");
    }

    public int getNumSectors(int n) {
        int n2 = 0;
        for (int i = 0; i < this.slots.size(); ++i) {
            FlashFileSlot flashFileSlot = this.slots.get(i);
            ByteBuffer byteBuffer = flashFileSlot.getData();
            n2 = (int)Math.ceil((float)n2 + (float)byteBuffer.remaining() / (float)n);
        }
        return n2;
    }

    public DBUSDeviceCode getDefaultDeviceCode() {
        byte by = this.headerBuffer.get(48);
        DBUSDeviceHandler dBUSDeviceHandler = DBUSDeviceRegistry.getDeviceHandler(by);
        return dBUSDeviceHandler != null ? dBUSDeviceHandler.getDeviceCode() : null;
    }

    public DBUSDataType getDefaultDataType() {
        byte by = this.headerBuffer.get(49);
        DBUSDeviceCode dBUSDeviceCode = this.getDefaultDeviceCode();
        return DBUSDataType.find(dBUSDeviceCode, by);
    }

    boolean isSupported(DBUSDataType dBUSDataType) {
        for (int i = 0; i < 22; i += 2) {
            byte by = this.headerBuffer.get(48 + i);
            byte by2 = this.headerBuffer.get(48 + i + 1);
            if (by == 0 || by != dBUSDataType.getDeviceCode().getValue() || by2 != dBUSDataType.getValue()) continue;
            return true;
        }
        return false;
    }

    boolean isIntelHexFormat() {
        return (this.headerBuffer.get(10) & 1) > 0;
    }

    protected static final short parseUHexByte(String string, int n) {
        return (short)(FlashFile.parseHexByte(string, n) & 0xFF);
    }

    protected static final short parseHexShort(String string, int n) {
        short s = FlashFile.parseUHexByte(string, n);
        short s2 = FlashFile.parseUHexByte(string, n + 2);
        return (short)(s << 8 | s2);
    }

    protected static final int parseUHexShort(String string, int n) {
        return FlashFile.parseHexShort(string, n) & 0xFFFF;
    }

    protected static byte calcChecksum(String string, short s, short n) {
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            n2 += FlashFile.parseUHexByte(string, s + 2 * i);
        }
        return (byte)(~n2 & 0xFF);
    }

    static {
        FlashFile.HEX_TABLE[48] = 0;
        FlashFile.HEX_TABLE[49] = 1;
        FlashFile.HEX_TABLE[50] = 2;
        FlashFile.HEX_TABLE[51] = 3;
        FlashFile.HEX_TABLE[52] = 4;
        FlashFile.HEX_TABLE[53] = 5;
        FlashFile.HEX_TABLE[54] = 6;
        FlashFile.HEX_TABLE[55] = 7;
        FlashFile.HEX_TABLE[56] = 8;
        FlashFile.HEX_TABLE[57] = 9;
        FlashFile.HEX_TABLE[65] = 10;
        FlashFile.HEX_TABLE[66] = 11;
        FlashFile.HEX_TABLE[67] = 12;
        FlashFile.HEX_TABLE[68] = 13;
        FlashFile.HEX_TABLE[69] = 14;
        FlashFile.HEX_TABLE[70] = 15;
    }
}

