/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.dbus;

import com.ti.eps.calc.dbus.DBUSCommand;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.DBUSDeviceHandler;
import com.ti.eps.calc.dbus.DBUSDeviceRegistry;
import com.ti.eps.calc.dbus.DBUSException;
import com.ti.eps.calc.dbus.DBUSPacket;
import com.ti.eps.calc.dbus.exceptions.RtsOrSendTooBigException;
import com.ti.eps.calc.dbus.exceptions.TimeoutException;
import com.ti.et.elg.inputStreamWithTimeout.export.InputStreamTimeoutInterface;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBUSPacketStreamReader {
    private static final Logger LOGGER = Logger.getLogger("DBUSPacketStreamReader");
    private static final int PACKET_BUFFER_SIZE = 66560;
    private static final int READ_BUFFER_SIZE = 256;
    private final String name;
    private final InputStream input;
    private final ByteBuffer buffer = ByteBuffer.allocate(66560);
    private final byte[] readBuffer = new byte[256];

    public DBUSPacketStreamReader(String string, InputStream inputStream) {
        this.name = string;
        this.input = inputStream;
        this.buffer.clear().flip();
    }

    public DBUSPacket readDBUSPacket(int n) throws TimeoutException {
        DBUSPacket dBUSPacket;
        while (!this.buffer.hasRemaining() || (dBUSPacket = this.parseBuffer()) == null) {
            this.buffer.compact();
            int n2 = 0;
            try {
                if (this.input instanceof InputStreamTimeoutInterface) {
                    ((InputStreamTimeoutInterface)this.input).setTimeout(n);
                }
                n2 = this.input.read(this.readBuffer);
            }
            catch (IOException iOException) {
                this.buffer.clear().flip();
                TimeoutException timeoutException = new TimeoutException();
                timeoutException.initCause(iOException);
                throw timeoutException;
            }
            finally {
                if (this.input instanceof InputStreamTimeoutInterface) {
                    ((InputStreamTimeoutInterface)this.input).setTimeout(10000);
                }
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest(this.name + ": Read " + n2 + " from input stream");
            }
            this.buffer.put(this.readBuffer, 0, n2);
            this.buffer.flip();
        }
        return dBUSPacket;
    }

    public DBUSPacket expectDBUSPacket(DBUSDeviceCode dBUSDeviceCode, DBUSCommand dBUSCommand, int n, int n2) throws RtsOrSendTooBigException, DBUSException {
        int n3;
        DBUSPacket dBUSPacket = null;
        for (n3 = 0; !(n3 >= n || dBUSDeviceCode.equals((dBUSPacket = this.readDBUSPacket(n2)).getDeviceCode()) && dBUSCommand.equals(dBUSPacket.getCommand())); ++n3) {
            LOGGER.warning(this.name + ": Received unexpected packet: " + dBUSPacket);
        }
        if (dBUSCommand == DBUSCommand.EOR) {
            if (dBUSPacket.getPayload().length == 1) {
                n3 = ByteBuffer.wrap(dBUSPacket.getPayload()).get();
                DBUSException.throwException(n3);
            }
            throw new RtsOrSendTooBigException("Max unexpected packets received.");
        }
        return dBUSPacket;
    }

    private DBUSPacket parseBuffer() {
        DBUSDeviceHandler dBUSDeviceHandler;
        while (true) {
            if (this.buffer.remaining() < 4) {
                return null;
            }
            byte by = this.buffer.get(this.buffer.position());
            dBUSDeviceHandler = DBUSDeviceRegistry.getDeviceHandler(by);
            if (dBUSDeviceHandler != null) break;
            LOGGER.log(Level.INFO, this.name + ": Unknown or unsupported unit code " + Integer.toHexString(by & 0xFF) + " flushing byte");
            this.buffer.get();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        DBUSPacket dBUSPacket = dBUSDeviceHandler.parsePacket(this.buffer);
        if (LOGGER.isLoggable(Level.FINE)) {
            if (dBUSPacket != null) {
                LOGGER.finest(this.name + ": DBUSDeviceHandler returned a " + dBUSPacket.getCommand() + " packet");
            } else {
                LOGGER.fine(this.name + ": DBUSDeviceHandler returned null");
            }
        }
        return dBUSPacket;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

