/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.dbus;

import com.ti.eps.calc.dbus.DBUSCommand;
import com.ti.eps.calc.dbus.DBUSController;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.DBUSDeviceHandler;
import com.ti.eps.calc.dbus.DBUSDeviceRegistry;
import com.ti.eps.calc.dbus.DBUSException;
import com.ti.eps.calc.dbus.DBUSPacket;
import com.ti.eps.calc.dbus.DBUSPacketStreamReader;
import com.ti.eps.calc.dbus.DBUSPacketStreamWriter;
import com.ti.eps.calc.dbus.exceptions.RtsOrSendTooBigException;
import com.ti.eps.calc.dbus.exceptions.TimeoutException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DBUSPacketIOStream {
    private DBUSPacketStreamReader reader;
    private DBUSPacketStreamWriter writer;
    private String name;

    public DBUSPacketIOStream(String string, InputStream inputStream, OutputStream outputStream) {
        this.name = string;
        this.reader = new DBUSPacketStreamReader(string, inputStream);
        this.writer = new DBUSPacketStreamWriter(string, outputStream);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public DBUSController connect() throws TimeoutException, IOException {
        this.write(DBUSPacket.RDC_PACKET);
        DBUSPacket dBUSPacket = this.reader.readDBUSPacket(10000);
        DBUSDeviceHandler dBUSDeviceHandler = DBUSDeviceRegistry.getDeviceHandler(dBUSPacket.getDeviceCode().getValue());
        if (dBUSDeviceHandler != null) {
            return dBUSDeviceHandler.getDBUSController(this);
        }
        return null;
    }

    public DBUSPacket read(int n) throws TimeoutException {
        return this.reader.readDBUSPacket(n);
    }

    public DBUSPacket expect(DBUSDeviceCode dBUSDeviceCode, DBUSCommand dBUSCommand, int n) throws RtsOrSendTooBigException, DBUSException {
        return this.reader.expectDBUSPacket(dBUSDeviceCode, dBUSCommand, 1, n);
    }

    public DBUSPacket expect(DBUSDeviceCode dBUSDeviceCode, DBUSCommand dBUSCommand, int n, int n2) throws RtsOrSendTooBigException, DBUSException {
        return this.reader.expectDBUSPacket(dBUSDeviceCode, dBUSCommand, n, n2);
    }

    public void write(DBUSPacket dBUSPacket) throws IOException {
        this.writer.writeDBUSPacket(dBUSPacket);
    }

    public void close() throws IOException {
        try {
            this.reader.close();
        }
        finally {
            this.writer.close();
        }
    }
}

