/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.dbus;

import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.DBUSDeviceHandler;
import com.ti.eps.calc.nspire.TiNspireCasDeviceHandler;
import com.ti.eps.calc.nspire.TiNspireDeviceHandler;
import com.ti.eps.calc.ti73.Ti73DBUSDeviceHandler;
import com.ti.eps.calc.ti83.Ti83DBUSDeviceHandler;
import com.ti.eps.calc.ti83Plus.Ti83PlusDBUSDeviceHandler;
import com.ti.eps.calc.ti83Plus.Ti83PlusPCHostDBUSDeviceHandler;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class DBUSDeviceRegistry {
    private static final Logger LOGGER = Logger.getLogger("DBUSDeviceRegistry");
    private static final DBUSDeviceHandler[] handlers = new DBUSDeviceHandler[255];

    public static void init() {
        LOGGER.info("Initialized");
    }

    public static DBUSDeviceHandler getDeviceHandler(byte by) {
        return handlers[by & 0xFF];
    }

    public static DBUSDeviceHandler findDeviceFileHandler(ByteBuffer byteBuffer) {
        for (DBUSDeviceHandler dBUSDeviceHandler : handlers) {
            DBUSDeviceHandler dBUSDeviceHandler2 = dBUSDeviceHandler;
            if (dBUSDeviceHandler2 == null || !dBUSDeviceHandler2.isValidHeader(byteBuffer)) continue;
            return dBUSDeviceHandler2;
        }
        return null;
    }

    static {
        DBUSDeviceRegistry.handlers[0] = new Ti83PlusPCHostDBUSDeviceHandler();
        DBUSDeviceRegistry.handlers[131] = new Ti83DBUSDeviceHandler();
        DBUSDeviceRegistry.handlers[115] = new Ti83PlusDBUSDeviceHandler();
        DBUSDeviceRegistry.handlers[35] = new Ti83PlusPCHostDBUSDeviceHandler();
        DBUSDeviceRegistry.handlers[116] = new Ti73DBUSDeviceHandler();
        DBUSDeviceRegistry.handlers[DBUSDeviceCode.UNIT_NSPIRE_CAS.getValue() & 0xFF] = new TiNspireCasDeviceHandler();
        DBUSDeviceRegistry.handlers[DBUSDeviceCode.UNIT_NSPIRE.getValue() & 0xFF] = new TiNspireDeviceHandler();
    }
}

