/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.dbus;

import com.ti.eps.calc.TiCalc;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.TokenString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DBUSDataType {
    public static final String REAL_NUMBER = "Real Number";
    public static final String REAL_LIST = "Real List";
    public static final String REAL_MATRIX = "Real Matrix";
    public static final String EQUATION = "Equation";
    public static final String CONSTANT = "Constant";
    public static final String STRING = "String";
    public static final String PROGRAM = "Program";
    public static final String PROTECT_PROGRAM = "Protect Program";
    public static final String PICTURE = "Picture";
    public static final String GRAPH_DATABASE = "Graph Database";
    public static final String SMART_GRAPH_EQUATION = "Smart Graph Equation";
    public static final String COMPLEX_NUMBER = "Complex Number";
    public static final String COMPLEX_LIST = "Complex List";
    public static final String WINDOW_RANGE = "Window Range";
    public static final String USER_ZOOM_WINDOW = "User Zoom Window";
    public static final String TABLE_SETUP = "Table Setup";
    public static final String BACKUP_IMAGE = "Backup Image";
    public static final String APPLICATION_VARIABLE = "Application Variable";
    public static final String TEMPORARY_PROGRAM = "Temporary Program";
    public static final String GROUP_OBJECT = "Group Object";
    public static final String DIRECTORY_LISTING = "Directory Listing";
    public static final String SEND_ID = "Send ID";
    public static final String BASE_CODE = "Base Code";
    public static final String FLASH_APPLICATION = "Flash Application";
    public static final String FLASH_APPLICATION_INTERNAL = "AppObject";
    public static final String CERTIFICATE = "Certificate";
    public static final String GET_ID = "Get ID";
    public static final String CERTIFICATES_MEMORY = "Certificates Memory";
    public static final String UNIT_CERTIFICATES = "Unit Certificates";
    public static final String STRING_LIST = "Categorical List";
    public static final String REDUCED_SIMPLE_FRACTION = "Reduced Simple Fraction";
    public static final String REDUCED_MIXED_FRACTION = "Reduced Mixed Fraction";
    public static final String UNREDUCED_SIMPLE_FRACTION = "Unreduced Simple Fraction";
    public static final String UNREDUCED_MIXED_FRACTION = "Unreduced Mixed Fraction";
    public static final String NSPIRE_DOCUMENT = "Nspire Document";
    public static final String IMAGE = "BackgroundImage";
    private static final HashMap<DBUSDeviceCode, DBUSDataType[]> codes = new HashMap();
    private static final HashMap<String, List<DBUSDataType>> exts = new HashMap();
    private static final HashMap<String, Map<DBUSDeviceCode, DBUSDataType>> names = new HashMap();
    private final DBUSDeviceCode deviceCode;
    private final byte value;
    private final String ext;
    private String name;
    private int numberBuiltInVariables = -1;

    private DBUSDataType(DBUSDeviceCode dBUSDeviceCode, byte by, String string, String string2) {
        this.deviceCode = dBUSDeviceCode;
        this.value = by;
        this.ext = string;
        this.name = string2;
    }

    private DBUSDataType(DBUSDeviceCode dBUSDeviceCode, byte by, String string, String string2, int n) {
        this(dBUSDeviceCode, by, string, string2);
        this.numberBuiltInVariables = n;
    }

    public DBUSDeviceCode getDeviceCode() {
        return this.deviceCode;
    }

    public byte getValue() {
        return this.value;
    }

    public String getExtension() {
        return this.ext;
    }

    public int getNumberBuiltinVariables() {
        return this.numberBuiltInVariables;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public static void registerType(DBUSDataType dBUSDataType) {
        List<DBUSDataType> list;
        String string;
        DBUSDataType[] dBUSDataTypeArray = codes.get(dBUSDataType.getDeviceCode());
        if (dBUSDataTypeArray == null) {
            dBUSDataTypeArray = new DBUSDataType[256];
            codes.put(dBUSDataType.getDeviceCode(), dBUSDataTypeArray);
        }
        if (dBUSDataTypeArray[dBUSDataType.getValue() & 0xFF] == null) {
            dBUSDataTypeArray[dBUSDataType.getValue() & 0xFF] = dBUSDataType;
        }
        if ((string = dBUSDataType.getExtension()) != null) {
            list = exts.get(string);
            if (list == null) {
                list = new ArrayList<DBUSDataType>(1);
                exts.put(string, list);
            }
            list.add(dBUSDataType);
        }
        if ((list = dBUSDataType.getName()) != null) {
            Map<DBUSDeviceCode, DBUSDataType> map = names.get(list);
            if (map == null) {
                map = new HashMap<DBUSDeviceCode, DBUSDataType>();
                names.put((String)((Object)list), map);
            }
            map.put(dBUSDataType.getDeviceCode(), dBUSDataType);
        }
    }

    public static DBUSDataType registerType(DBUSDeviceCode dBUSDeviceCode, byte by, String string, String string2) {
        if (string != null) {
            string = string.toLowerCase();
        }
        DBUSDataType dBUSDataType = new DBUSDataType(dBUSDeviceCode, by, string, string2);
        DBUSDataType.registerType(dBUSDataType);
        return dBUSDataType;
    }

    public static DBUSDataType registerType(DBUSDeviceCode dBUSDeviceCode, byte by, String string, String string2, int n) {
        if (string != null) {
            string = string.toLowerCase();
        }
        DBUSDataType dBUSDataType = new DBUSDataType(dBUSDeviceCode, by, string, string2, n);
        DBUSDataType.registerType(dBUSDataType);
        return dBUSDataType;
    }

    public static DBUSDataType find(DBUSDeviceCode dBUSDeviceCode, String string) {
        HashMap hashMap = (HashMap)names.get(string);
        if (hashMap != null) {
            return (DBUSDataType)hashMap.get(dBUSDeviceCode);
        }
        return null;
    }

    public static DBUSDataType find(DBUSDeviceCode dBUSDeviceCode, byte by) {
        DBUSDataType[] dBUSDataTypeArray = codes.get(dBUSDeviceCode);
        if (dBUSDataTypeArray == null) {
            dBUSDataTypeArray = new DBUSDataType[256];
        }
        return dBUSDataTypeArray[by & 0xFF];
    }

    public static DBUSDataType[] findByExtension(String string) {
        DBUSDataType[] dBUSDataTypeArray = null;
        List<DBUSDataType> list = exts.get(string.toLowerCase());
        if (list != null) {
            dBUSDataTypeArray = list.toArray(new DBUSDataType[list.size()]);
        }
        return dBUSDataTypeArray;
    }

    public static TokenString getDeviceString(String string, String string2) {
        int n = string2.lastIndexOf(".");
        String string3 = string2.substring(n + 1);
        DBUSDataType[] dBUSDataTypeArray = DBUSDataType.findByExtension(string3);
        TokenString tokenString = TiCalc.newTokenString(dBUSDataTypeArray[0].getDeviceCode(), string);
        return tokenString;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DBUSDataType)) {
            return false;
        }
        DBUSDataType dBUSDataType = (DBUSDataType)object;
        return this.deviceCode == dBUSDataType.deviceCode ? this.name.equals(dBUSDataType.name) : false;
    }
}

