/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.dbus;

import com.ti.eps.calc.dbus.DBUSController;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.DBUSDeviceHandler;
import com.ti.eps.calc.dbus.DBUSException;
import com.ti.eps.calc.dbus.DBUSPacketFactory;
import com.ti.eps.calc.dbus.DBUSPacketIOStream;
import com.ti.eps.calc.dbus.DBUSProgressEvent;
import com.ti.eps.calc.dbus.DBUSProgressListener;
import com.ti.eps.calc.dbus.DeviceConfiguration;
import com.ti.eps.calc.dbus.exceptions.RtsOrSendTooBigException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DBUSControllerImpl
implements DBUSController {
    private static final Logger LOGGER = Logger.getLogger("DBUSCommander");
    protected static final int THROTTLE_FACTOR = 0;
    protected static final int MIN_THROTTLE_VALUE = 4;
    protected static final int MIN_THROTTLE_TIME = 25;
    protected static int numConcurrentCalls = 0;
    protected static int numFailures = 0;
    protected static int qualityIndex = 0;
    protected static int lastSleepTime = 0;
    protected final DBUSDeviceCode unitCode;
    protected DBUSPacketIOStream io;
    protected DBUSPacketFactory packetFactory;

    public DBUSControllerImpl(DBUSPacketIOStream dBUSPacketIOStream, DBUSDeviceHandler dBUSDeviceHandler) {
        this.io = dBUSPacketIOStream;
        this.packetFactory = dBUSDeviceHandler.getPacketFactory();
        this.unitCode = dBUSDeviceHandler.getDeviceCode();
    }

    public static void resetThrottle() {
        numConcurrentCalls = 0;
        numFailures = 0;
        qualityIndex = 0;
        lastSleepTime = 0;
    }

    @Override
    public DeviceConfiguration requestDeviceConfiguration() throws IOException, RtsOrSendTooBigException, DBUSException {
        return this.requestDeviceConfiguration(null);
    }

    @Override
    public abstract DeviceConfiguration requestDeviceConfiguration(DBUSProgressListener var1) throws IOException, RtsOrSendTooBigException, DBUSException;

    @Override
    public DBUSDeviceCode getDeviceCode() throws IOException, RtsOrSendTooBigException, DBUSException {
        return this.getDeviceCode(null);
    }

    @Override
    public DBUSDeviceCode getDeviceCode(DBUSProgressListener dBUSProgressListener) throws IOException, RtsOrSendTooBigException, DBUSException {
        this.requestDeviceConfiguration(dBUSProgressListener);
        return this.unitCode;
    }

    protected static final DBUSProgressEvent fireEvent(DBUSProgressListener dBUSProgressListener, String string, float f, DBUSProgressEvent dBUSProgressEvent) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(string);
        }
        if (dBUSProgressListener != null) {
            if (dBUSProgressEvent == null) {
                dBUSProgressEvent = new DBUSProgressEvent(string, 0.0f, 1.0f, f);
            } else {
                dBUSProgressEvent.setDescription(string);
                dBUSProgressEvent.setMin(0.0f);
                dBUSProgressEvent.setMax(1.0f);
                dBUSProgressEvent.setValue(f);
            }
            dBUSProgressListener.dbusProgressChanged(dBUSProgressEvent);
        }
        return dBUSProgressEvent;
    }

    protected static final void throttle() {
        DBUSControllerImpl.throttle(0);
    }

    protected static final void throttle(int n) {
        int n2;
        lastSleepTime = n2 = 0;
    }

    public static final int getLastSleepTime() {
        return lastSleepTime;
    }

    public static final int getNumConcurrentCalls() {
        return numConcurrentCalls;
    }

    public static final int getNumFailures() {
        return numFailures;
    }

    public static int getQualityIndex() {
        return qualityIndex;
    }
}

