/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc;

import com.ti.eps.calc.dbus.DBUSController;
import com.ti.eps.calc.dbus.DBUSDataType;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.DBUSDeviceHandler;
import com.ti.eps.calc.dbus.DBUSDeviceRegistry;
import com.ti.eps.calc.dbus.DBUSPacketIOStream;
import com.ti.eps.calc.dbus.DeviceFile;
import com.ti.eps.calc.dbus.FontString;
import com.ti.eps.calc.dbus.TokenString;
import com.ti.eps.calc.dbus.exceptions.InvalidDeviceFileException;
import com.ti.eps.calc.dbus.exceptions.TimeoutException;
import com.ti.eps.calc.java.JavaDeviceHandler;
import com.ti.eps.calc.math.MathContext;
import com.ti.eps.calc.math.MathNumber;
import com.ti.eps.calc.math.equation.EquationHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;

public class TiCalc {
    private static final DBUSDeviceHandler javaDeviceHandler = new JavaDeviceHandler();

    public static DBUSController connect(String string, InputStream inputStream, OutputStream outputStream) throws TimeoutException, IOException {
        DBUSPacketIOStream dBUSPacketIOStream = new DBUSPacketIOStream(string, inputStream, outputStream);
        return dBUSPacketIOStream.connect();
    }

    public static DBUSDeviceHandler getDeviceHandler(DBUSDeviceCode dBUSDeviceCode) {
        if (dBUSDeviceCode.equals(DBUSDeviceCode.JAVA)) {
            return javaDeviceHandler;
        }
        return TiCalc.getDeviceHandler(dBUSDeviceCode.getValue());
    }

    public static DBUSDeviceHandler getDeviceHandler(byte by) {
        return DBUSDeviceRegistry.getDeviceHandler(by);
    }

    public static DeviceFile newDeviceFile(DBUSDataType dBUSDataType) {
        return TiCalc.getDeviceHandler(dBUSDataType.getDeviceCode()).newDeviceFile(dBUSDataType);
    }

    public static DBUSDataType findDataType(DBUSDeviceCode dBUSDeviceCode, String string) {
        return TiCalc.getDeviceHandler(dBUSDeviceCode).findDataType(string);
    }

    public static byte[] removeLeadingTrailingSpaceTokens(DBUSDeviceCode dBUSDeviceCode, byte[] byArray) {
        return TiCalc.getDeviceHandler(dBUSDeviceCode).removeLeadingTrailingSpaceTokens(byArray);
    }

    public static DeviceFile parseDeviceFile(File file) throws IOException, InvalidDeviceFileException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        DBUSDeviceHandler dBUSDeviceHandler = TiCalc.getDeviceFileHandler(bufferedInputStream);
        ((InputStream)bufferedInputStream).close();
        if (dBUSDeviceHandler != null) {
            return dBUSDeviceHandler.parseDeviceFile(file);
        }
        return null;
    }

    public static DeviceFile parseDeviceFile(InputStream inputStream) throws IOException, InvalidDeviceFileException {
        DBUSDeviceHandler dBUSDeviceHandler;
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if ((dBUSDeviceHandler = TiCalc.getDeviceFileHandler(inputStream)) != null) {
            return dBUSDeviceHandler.parseDeviceFile(inputStream);
        }
        return null;
    }

    private static final DBUSDeviceHandler getDeviceFileHandler(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[10];
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("fileInput must support mark operation");
        }
        inputStream.mark(11);
        inputStream.read(byArray);
        inputStream.reset();
        return DBUSDeviceRegistry.findDeviceFileHandler(ByteBuffer.wrap(byArray));
    }

    public static final TokenString newTokenString(DBUSDeviceCode dBUSDeviceCode, byte[] byArray) {
        return TiCalc.getDeviceHandler(dBUSDeviceCode).newTokenString(byArray);
    }

    public static final TokenString newTokenString(DBUSDeviceCode dBUSDeviceCode, String string) {
        return TiCalc.getDeviceHandler(dBUSDeviceCode).newTokenString(string);
    }

    public static final TokenString newTokenString(DBUSDeviceCode dBUSDeviceCode, DBUSDataType dBUSDataType, String string) {
        return TiCalc.getDeviceHandler(dBUSDeviceCode).newTokenString(dBUSDataType, string);
    }

    public static final FontString newFontString(DBUSDeviceCode dBUSDeviceCode, String string) {
        return TiCalc.getDeviceHandler(dBUSDeviceCode).newFontString(string);
    }

    public static final FontString newFontString(DBUSDeviceCode dBUSDeviceCode, byte[] byArray) {
        return TiCalc.getDeviceHandler(dBUSDeviceCode).newFontString(byArray);
    }

    public static final EquationHandler newEquationHandler(DBUSDeviceCode dBUSDeviceCode, Reader reader) {
        return TiCalc.getDeviceHandler(dBUSDeviceCode).newEquationHandler(reader);
    }

    public static final EquationHandler newEquationHandler(DBUSDeviceCode dBUSDeviceCode, InputStream inputStream) {
        return TiCalc.getDeviceHandler(dBUSDeviceCode).newEquationHandler(inputStream);
    }

    public static final MathNumber newMathNumber(DBUSDeviceCode dBUSDeviceCode, double d) {
        return TiCalc.getDeviceHandler(dBUSDeviceCode).newMathNumber(d);
    }

    public static final MathNumber newMathNumber(DBUSDeviceCode dBUSDeviceCode, String string) {
        return TiCalc.getDeviceHandler(dBUSDeviceCode).newMathNumber(string);
    }

    public static final MathContext getMathContext(DBUSDeviceCode dBUSDeviceCode) {
        return TiCalc.getDeviceHandler(dBUSDeviceCode).getMathContext();
    }
}

