/*
 * Decompiled with CFR 0.152.
 */
package com.ti.et.smartview.jsemulator;

import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.BrowserContext;
import com.teamdev.jxbrowser.chromium.BrowserContextParams;
import com.teamdev.jxbrowser.chromium.BrowserType;
import com.teamdev.jxbrowser.chromium.JSBoolean;
import com.teamdev.jxbrowser.chromium.JSFunction;
import com.teamdev.jxbrowser.chromium.JSNumber;
import com.teamdev.jxbrowser.chromium.JSObject;
import com.teamdev.jxbrowser.chromium.JSString;
import com.teamdev.jxbrowser.chromium.JSUndefined;
import com.teamdev.jxbrowser.chromium.JSValue;
import com.teamdev.jxbrowser.chromium.events.FailLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.FinishLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.FrameLoadEvent;
import com.teamdev.jxbrowser.chromium.events.LoadEvent;
import com.teamdev.jxbrowser.chromium.events.LoadListener;
import com.teamdev.jxbrowser.chromium.events.NetError;
import com.teamdev.jxbrowser.chromium.events.ProvisionalLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.ScriptContextAdapter;
import com.teamdev.jxbrowser.chromium.events.ScriptContextEvent;
import com.teamdev.jxbrowser.chromium.events.ScriptContextListener;
import com.teamdev.jxbrowser.chromium.events.StartLoadingEvent;
import com.teamdev.jxbrowser.chromium.javafx.BrowserView;
import com.ti.et.goioComm.goioCommManager.GoIOCommManager;
import com.ti.et.pythonComm.PythonCommManager;
import com.ti.et.smartview.exports.IMetadata;
import com.ti.et.smartview.exports.IPluginListener;
import com.ti.et.smartview.exports.ITIImage;
import com.ti.et.smartview.exports.ITIMultiviewItem;
import com.ti.et.smartview.exports.ITIStateFile;
import com.ti.et.smartview.exports.SDA.EmulatorLoader;
import com.ti.et.smartview.exports.SDA.EmulatorMap;
import com.ti.et.smartview.jsemulator.DisplaySettings;
import com.ti.et.smartview.jsemulator.EmulatorResourceExtractor;
import com.ti.et.smartview.jsemulator.JSEmulator;
import com.ti.et.smartview.jsemulator.JSEmulatorState;
import com.ti.et.smartview.jsemulator.JSLargeScreenView;
import com.ti.et.smartview.jsemulator.JSMultiviewItem;
import com.ti.et.smartview.jsemulator.keymapping.JSKeyManager;
import com.ti.et.smartview.jsemulator.skins.JSSkinManager;
import com.ti.et.smartview.jsemulator.virtuastream.VirtualStreamInterface;
import com.ti.et.smartview.jsemulator.virtuastream.impl.JavaPluginVirtualStream;
import com.ti.et.smartview.jsemulator.virtuastream.impl.JavaPluginVirtualStreamChannel;
import com.ti.et.smartview.jsemulator.virtuastream.impl.TCPClientVirtualStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Pipe;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;

public class EmulatorView
extends BorderPane {
    protected BrowserView webView;
    protected Browser webEngine;
    private Node a;
    protected JSEmulator emulator = null;
    private static Logger b = Logger.getLogger(EmulatorView.class.getSimpleName());
    protected JSKeyManager keyManager = null;
    private JSSkinManager c = null;
    protected JSLargeScreenView largeScreenView = null;
    private ITIStateFile d = null;
    private boolean e = false;
    public String screenContents;
    public AtomicBoolean screenCaptureAvailable = new AtomicBoolean(false);
    private LoadListener f;
    private String g;
    private boolean h;
    private boolean i = false;
    protected boolean forceReinitFlag = false;
    private VirtualStreamInterface j;
    private static int k = 2;
    private boolean l = false;
    private EventHandler<DragEvent> m;
    private EventHandler<MouseEvent> n;
    private EventHandler<MouseEvent> o;
    private boolean p = false;
    protected boolean isView3Refreshing = false;
    protected JavaApp javaApp;
    private List<IPluginListener> q = new ArrayList<IPluginListener>();
    private Path r = null;
    private ScriptContextAdapter s = null;
    private List<KeyCode> t = Stream.of(KeyCode.UP, KeyCode.DOWN, KeyCode.RIGHT, KeyCode.LEFT).collect(Collectors.toList());
    private EventHandler<KeyEvent> u = new EventHandler<KeyEvent>(this){
        private /* synthetic */ EmulatorView a;
        {
            void var1_1;
            this.a = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void handle(KeyEvent event) {
            void var1_1;
            KeyEvent keyEvent = (KeyEvent)event.clone();
            event.consume();
            if (!(event.isControlDown() && event.isMetaDown() || EmulatorView.a(event) && event.isMetaDown() || EmulatorView.a(event) && event.isShiftDown() || this.a.t.contains(event.getCode()))) {
                this.a.getParent().fireEvent((Event)keyEvent);
                keyEvent.consume();
            }
            this.a.emulator.keyPressed((KeyEvent)var1_1);
        }
    };
    private EventHandler<KeyEvent> v = new EventHandler<KeyEvent>(this){
        private /* synthetic */ EmulatorView a;
        {
            void var1_1;
            this.a = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void handle(KeyEvent event) {
            void var1_1;
            KeyEvent keyEvent = (KeyEvent)event.clone();
            event.consume();
            if (!(event.isControlDown() && event.isMetaDown() || EmulatorView.a(event) && event.isMetaDown() || EmulatorView.a(event) && event.isShiftDown() || this.a.t.contains(event.getCode()))) {
                this.a.getParent().fireEvent((Event)keyEvent);
                keyEvent.consume();
            }
            this.a.emulator.keyReleased((KeyEvent)var1_1);
        }
    };
    private ExecuteScriptCallable w = new ExecuteScriptCallable(this);
    private KeyCode x = null;
    private IOProxy y = null;
    private boolean z = false;
    private Runnable A = new Runnable(this){
        private /* synthetic */ EmulatorView a;
        {
            void var1_1;
            this.a = var1_1;
        }

        @Override
        public void run() {
            if (this.a.webEngine != null || this.a.i) {
                b.log(Level.FINEST, "About to finalize the webView");
                if (this.a.webEngine != null && !this.a.webEngine.isDisposed()) {
                    this.a.webEngine.dispose();
                    this.a.q.stream().forEach(iPluginListener -> iPluginListener.onPluginDisposed());
                    this.a.webEngine.removeScriptContextListener((ScriptContextListener)this.a.s);
                    this.a.q.clear();
                    this.a.cleanBrowserContextFolders();
                }
                this.a.webEngine = null;
                this.a.webView = null;
                this.a.z = false;
                if (this.a.forceReinitFlag) {
                    b.log(Level.INFO, "Will reinitialize");
                    this.a.emulator.forcedInitEmulatorView();
                    this.a.forceReinitFlag = false;
                    return;
                }
            } else {
                b.log(Level.FINEST, "Couldn't finalize the webView");
                this.a.eliminateReferences();
            }
        }
    };
    private EventHandler<MouseEvent> B;
    private boolean C = false;

    /*
     * WARNING - void declaration
     */
    public void init(JSEmulator emulator, JSKeyManager svKeyManager, JSLargeScreenView largeScreenView, JSSkinManager skinManager, ITIStateFile currentState, String currentFaceplate, boolean noDisplay) {
        void var3_3;
        void var2_2;
        Object object;
        this.a = this;
        this.paintBGColor("#7E8080");
        this.webEngine = new Browser(BrowserType.LIGHTWEIGHT, this.createBrowserContext());
        b.log(Level.INFO, "Setting up context folder in " + this.webEngine.getContext().getDataDir());
        this.webView = new BrowserView(this.webEngine);
        this.emulator = object;
        this.keyManager = var2_2;
        this.c = skinManager;
        this.largeScreenView = var3_3;
        this.d = currentState;
        this.g = currentFaceplate;
        this.h = noDisplay;
        this.largeScreenView.setNoRefresh(noDisplay);
        this.webView.setId("webviewEmulator");
        if (!this.webView.getStyleClass().contains((Object)"paneEmulatorView")) {
            this.webView.getStyleClass().add((Object)"paneEmulatorView");
        }
        if (!this.getStyleClass().contains((Object)"paneEmulatorView")) {
            this.getStyleClass().add((Object)"paneEmulatorView");
        }
        object = this;
        object.addEventFilter(KeyEvent.KEY_PRESSED, ((EmulatorView)((Object)object)).u);
        object.addEventFilter(KeyEvent.KEY_RELEASED, ((EmulatorView)((Object)object)).v);
        this.m = new EventHandler<DragEvent>(this){

            public void handle(DragEvent evt) {
                evt.consume();
            }
        };
        this.B = new EventHandler<MouseEvent>(this){

            public void handle(MouseEvent evt) {
                evt.consume();
            }
        };
        this.n = new EventHandler<MouseEvent>(this){
            private /* synthetic */ EmulatorView a;
            {
                void var1_1;
                this.a = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public void handle(MouseEvent evt) {
                void var1_1;
                if (this.a.e) {
                    Dragboard dragboard = this.a.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
                    dragboard.clear();
                    ClipboardContent clipboardContent = new ClipboardContent();
                    ArrayList<File> arrayList = new ArrayList<File>();
                    b.log(Level.FINEST, "It's Windows, attempting to drag image");
                    Image image = this.a.largeScreenView.getDraggableImage();
                    if (image != null) {
                        clipboardContent.put((Object)DataFormat.IMAGE, (Object)image);
                        arrayList.add(this.a.largeScreenView.getDraggableFile());
                        clipboardContent.putFiles(arrayList);
                        clipboardContent.put((Object)this.a.largeScreenView.getTIImageDataFormat(), (Object)this.a.largeScreenView.getLastARGBDataAsString());
                        dragboard.setContent((Map)clipboardContent);
                    }
                }
                this.a.e = false;
                var1_1.consume();
            }
        };
        this.o = new EventHandler<MouseEvent>(this){
            private /* synthetic */ EmulatorView a;
            {
                void var1_1;
                this.a = var1_1;
            }

            public void handle(MouseEvent arg0) {
                this.a.executeScript("calc_instance.relSVGKey()");
            }
        };
        this.initBrowser();
        object = System.getProperty("os.name").toLowerCase();
        this.p = ((String)object).indexOf("win") >= 0;
    }

    private void a() {
        this.addEventFilter(MouseEvent.MOUSE_DRAGGED, this.B);
        this.addEventFilter(MouseEvent.DRAG_DETECTED, this.n);
        this.webView.addEventFilter(DragEvent.DRAG_OVER, this.m);
        this.webView.addEventFilter(DragEvent.DRAG_ENTERED, this.m);
        this.webView.addEventFilter(DragEvent.DRAG_ENTERED_TARGET, this.m);
        this.webView.addEventFilter(DragEvent.DRAG_DONE, this.m);
        this.webView.addEventFilter(DragEvent.DRAG_DROPPED, this.m);
        this.webView.addEventFilter(DragEvent.DRAG_EXITED, this.m);
        this.webView.addEventFilter(DragEvent.DRAG_EXITED_TARGET, this.m);
        this.webView.addEventFilter(MouseEvent.MOUSE_EXITED, this.o);
    }

    private static boolean a(KeyEvent keyEvent) {
        KeyCode keyCode = keyEvent.getCode();
        boolean bl = keyCode == KeyCode.ALT || keyCode == KeyCode.ALT_GRAPH || keyEvent.isAltDown();
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void paintBGColor(String bgColor) {
        void var1_1;
        b.log(Level.FINE, "bgColor: " + bgColor);
        this.setStyle("-fx-padding: 20 15 20 15;" + MessageFormat.format("-fx-background-color:{0};", var1_1));
    }

    public void initBrowser() {
        boolean bl;
        EmulatorView emulatorView;
        block4: {
            block5: {
                emulatorView = this;
                b.log(Level.INFO, "Extract Emulator...");
                bl = false;
                if (!EmulatorResourceExtractor.getInstance().extractEmulatorContent()) break block4;
                if (EmulatorMap.getInstance().isEmulatorLoaded(emulatorView.emulator.getCalculatorModelName())) break block5;
                String string = EmulatorLoader.loadEmulatorN((String)EmulatorResourceExtractor.getInstance().getEmulatorMinFilePath(), (String)System.getProperty("APP_NAME", ""));
                if (string == null) break block4;
                EmulatorMap.getInstance().addEmulatorCode(emulatorView.emulator.getCalculatorModelName(), string);
            }
            bl = true;
        }
        if (bl) {
            emulatorView = this;
            this.s = new ScriptContextAdapter(emulatorView){
                private /* synthetic */ EmulatorView a;
                {
                    void var1_1;
                    this.a = var1_1;
                }

                public void onScriptContextCreated(ScriptContextEvent evt) {
                    Browser browser;
                    b.log(Level.INFO, "Load emulator code.");
                    browser = browser.getBrowser();
                    String string = this.a.emulator.getCalculatorModelName();
                    String string2 = EmulatorMap.getInstance().getEmulatorCode(string);
                    if (string2 == null) {
                        b.log(Level.SEVERE, "Error while getting Emulator code.");
                        Platform.exit();
                        return;
                    }
                    b.log(Level.FINEST, "emuModelName=" + string + ",jsEmuCodeLen=" + string2.length());
                    browser = browser.executeJavaScriptAndReturnValue(string2);
                    if (browser.isNull()) {
                        b.log(Level.SEVERE, "Error while loading emulator");
                        Platform.exit();
                    }
                    b.log(Level.INFO, "Emulator code is ready.");
                }
            };
            emulatorView.webEngine.addScriptContextListener((ScriptContextListener)emulatorView.s);
            EmulatorView emulatorView2 = this;
            this.f = new EmulatorViewWebListener(emulatorView2, emulatorView2.c, this.g, this.h, this.largeScreenView);
            this.webEngine.addLoadListener(this.f);
            this.webEngine.loadURL("file://" + EmulatorResourceExtractor.getInstance().getEmulatorHTML());
            EmulatorView emulatorView3 = this;
            emulatorView3.setCenter((Node)emulatorView3.webView);
            return;
        }
        b.log(Level.SEVERE, "Failed to load Emulator");
    }

    /*
     * WARNING - void declaration
     */
    public String sendDebugCommand(String command) {
        void var1_1;
        return (String)this.executeScript("calc_instance.sendDebugCommand('" + (String)var1_1 + "')");
    }

    public int restoreDefaultState() {
        boolean bl = (Boolean)this.executeScript("calc_instance.resetSVEmulator()");
        if (bl && this.emulator.supportsUserStatefiles()) {
            this.emulator.getHostApplication().getMetadata().storeMetadata(this.getCurrentMetadata());
        }
        if (bl) {
            return 1;
        }
        return 0;
    }

    public boolean clearHighlightedKey() {
        return (Boolean)this.executeScript("calc_instance.clearHighlightedKey()");
    }

    /*
     * WARNING - void declaration
     */
    public void setMetadataInfo(String infoStr) {
        void var1_1;
        this.executeScript("calc_instance.setMetadataInfo('" + (String)var1_1 + "')");
    }

    /*
     * WARNING - void declaration
     */
    public Map<IMetadata.Info, String> verifyChecksumAndGetMetaInfo(String stateFileData) {
        void var1_1;
        return this.a("calc_instance.verifyChecksumAndGetMetaInfo(" + (String)var1_1 + ")");
    }

    public Map<IMetadata.Info, String> getCurrentMetadata() {
        return this.a("calc_instance.getCurrentMetaInfo()");
    }

    public String getFactoryDefaultOSVersion() {
        String string = null;
        Object object = this.executeScript("calc_instance.getFactoryDefaultOSVersion()");
        if (object != null && object instanceof JSString && (string = ((JSString)object).getStringValue()).equals("undefined")) {
            string = null;
        }
        return string;
    }

    private Map<IMetadata.Info, String> a(String string) {
        int n = 5;
        Map<IMetadata.Info, String> map = null;
        while (n > 0 && (map == null || map.isEmpty())) {
            Object object = this.executeScript(string);
            if (object != null && object instanceof JSValue && ((JSValue)object).isObject()) {
                b.log(Level.INFO, "Got response, now try to parse the info.");
                map = EmulatorView.a(((JSValue)object).asObject());
            } else {
                b.log(Level.INFO, "Could not parse info, not the expected format.");
            }
            --n;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (map == null || map.isEmpty()) {
            b.log(Level.SEVERE, "Failed to retrive Metadata from emulator.");
        } else {
            b.log(Level.INFO, "Metadata retrieved successfully.");
        }
        return map;
    }

    private static Map<IMetadata.Info, String> a(JSObject jSObject) {
        HashMap<IMetadata.Info, JSValue> hashMap = null;
        if (jSObject != null) {
            hashMap = new HashMap<IMetadata.Info, JSValue>();
            try {
                b.log(Level.INFO, "Parsing info...");
                for (IMetadata.Info info : IMetadata.Info.values()) {
                    Object object = jSObject.getProperty(info.getKey());
                    if (object.isString()) {
                        object = object.getStringValue();
                    } else {
                        if (!object.isNumber()) {
                            hashMap = null;
                            b.log(Level.WARNING, "Failed to parse field: " + info.getKey() + ", either the property was not found in the object or the value is not a String or Number.");
                            break;
                        }
                        object = String.valueOf((int)object.getNumberValue());
                    }
                    hashMap.put(info, (JSValue)object);
                }
            }
            catch (IllegalArgumentException | IllegalStateException runtimeException) {
                hashMap = null;
                b.log(Level.SEVERE, "Failed to parse metadata info: " + runtimeException.getMessage());
            }
        }
        return hashMap;
    }

    public ITIStateFile getCurrentState() {
        JSValue jSValue;
        JSEmulatorState jSEmulatorState = new JSEmulatorState();
        this.executeScript("calc_instance.getStateData(true)");
        do {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                b.log(Level.WARNING, "Thread was interrupted.", interruptedException.getMessage());
            }
        } while ((jSValue = (JSValue)this.executeScript("calc_instance.getStateData(false)")) instanceof JSUndefined);
        jSEmulatorState.setData(jSValue.getStringValue());
        return jSEmulatorState;
    }

    /*
     * WARNING - void declaration
     */
    public boolean setStateFile(ITIStateFile state) {
        boolean bl = false;
        if (state != null) {
            void var1_1;
            bl = (Boolean)this.executeScript("calc_instance.setStateData('" + var1_1.getData() + "')");
        }
        return bl;
    }

    protected Object executeScript(String scriptCode) {
        Object object;
        Object object2 = null;
        if (this.webEngine == null || this.emulator == null) {
            b.log(Level.SEVERE, "Skipping script execution due to null web engine or emulator");
            return null;
        }
        try {
            this.w.setScriptCode(scriptCode);
            if (!this.emulator.isEmulatorFinishLoading()) {
                object = scriptCode.length() > 100 ? scriptCode.substring(0, 100) : object;
                b.log(Level.INFO, "Executing script when emulator not fully initialized yet (not necessarily an issue) " + (String)object);
            }
            object2 = this.emulator.getHostApplication().getConcurrencyManager().runOnApplicationThread((Callable)this.w);
        }
        catch (Exception exception) {
            object = exception;
            object = exception.getMessage();
            if (object == null) {
                object = "UNKNOWN";
            }
            b.log(Level.SEVERE, "JSException: Script execution failed: " + (String)object);
        }
        if (object2 != null && object2 instanceof JSBoolean) {
            object2 = ((JSBoolean)object2).getBooleanValue();
        }
        return object2;
    }

    public OutputStream getDataOut() {
        b.log(Level.INFO, "getDataOut");
        return this.j.getDataOut();
    }

    /*
     * WARNING - void declaration
     */
    public void setDataIn(OutputStream os) {
        void var1_1;
        this.j.setDataIn((OutputStream)var1_1);
    }

    public Pipe getPipe() {
        if (k == 2) {
            b.log(Level.INFO, "getPipe");
            return ((JavaPluginVirtualStreamChannel)this.j).getPipe();
        }
        return null;
    }

    public ITIImage getScreenCapture() {
        byte[] byArray = this.largeScreenView.getLastImageDataArray();
        TIImageImpl tIImageImpl = null;
        if (byArray.length > 0) {
            tIImageImpl = new TIImageImpl(this.largeScreenView.getDisplaySettings().getPixelsWide(), this.largeScreenView.getDisplaySettings().getPixelsHeight());
            tIImageImpl.setImageData(byArray);
        }
        return tIImageImpl;
    }

    /*
     * WARNING - void declaration
     */
    public boolean keyPressed(KeyEvent event) {
        Object object = Boolean.FALSE;
        String string = this.keyManager.getCodeFromEvent(event);
        b.log(Level.FINE, event.getCode().name() + " calc_instance.sendSVGKey('" + string + "')");
        if (string != null && !this.isView3Refreshing) {
            void var1_1;
            object = this.executeScript("calc_instance.sendSVGKey('" + string + "')");
            object = (Boolean)object;
            this.x = var1_1.getCode();
            b.log(Level.FINE, "Send key result: " + (Boolean)object);
        }
        if (object == null) {
            return false;
        }
        return (Boolean)object;
    }

    public boolean keyReleased(KeyEvent keyEvent) {
        Object object;
        Boolean bl = Boolean.FALSE;
        b.log(Level.FINE, "keyReleased" + keyEvent.getCode().name());
        if (this.x != null && this.x.equals((Object)object.getCode()) && !this.isView3Refreshing) {
            object = this.executeScript("calc_instance.relSVGKey()");
            bl = (Boolean)object;
            b.log(Level.FINE, "Key released: " + bl);
        }
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public DisplaySettings getDisplaySettings() {
        this.executeScript("calc_instance.getDisplaySettings()");
        return this.javaApp.getDisplaySettings();
    }

    public String[] getSkinIds() {
        return this.c.geSkinIds();
    }

    /*
     * WARNING - void declaration
     */
    public boolean setSkin(String id, boolean noDisplay) {
        void var2_3;
        void var1_1;
        this.h = noDisplay;
        this.forceRepaintEmulatorDisplay_ELG();
        this.largeScreenView.setNoRefresh(noDisplay);
        String string = this.c.getBGColor(id, noDisplay);
        this.paintBGColor(string);
        EmulatorView emulatorView = this;
        boolean bl = (Boolean)emulatorView.executeScript(emulatorView.c.generateSwitchFaceplateScript((String)var1_1, (boolean)var2_3));
        return bl;
    }

    protected void forceRepaintEmulatorDisplay_ELG() {
        if (!this.p && !this.h && this.emulator.isELGEmulator()) {
            b.log(Level.FINE, "Calling setForceRepaint");
            this.executeScript("calc_instance.setForceRepaint()");
        }
    }

    public Node getRootNode() {
        return this.a;
    }

    public boolean getIsSafeToClose() {
        Boolean bl = (Boolean)this.executeScript("calc_instance.isSafeToClose()");
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void registerBrowserListener(IPluginListener listener) {
        if (listener != null) {
            void var1_1;
            this.q.add((IPluginListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void unregisterBrowserListener(IPluginListener listener) {
        if (listener != null) {
            void var1_1;
            this.q.remove(var1_1);
        }
    }

    public void shutDown() {
        b.log(Level.INFO, "Shutting down Emulator");
        this.z = true;
        if (this.y != null) {
            this.y.closeIOStream();
        }
        if (this.webEngine == null) {
            b.log(Level.INFO, "No webEngine found.");
            return;
        }
        if (this.f != null) {
            this.webEngine.removeLoadListener(this.f);
        }
        if (this.m != null) {
            this.webView.removeEventFilter(DragEvent.DRAG_OVER, this.m);
            this.webView.removeEventFilter(DragEvent.DRAG_ENTERED, this.m);
            this.webView.removeEventFilter(DragEvent.DRAG_ENTERED_TARGET, this.m);
            this.webView.removeEventFilter(DragEvent.DRAG_DONE, this.m);
            this.webView.removeEventFilter(DragEvent.DRAG_DROPPED, this.m);
            this.webView.removeEventFilter(DragEvent.DRAG_EXITED, this.m);
            this.webView.removeEventFilter(DragEvent.DRAG_EXITED_TARGET, this.m);
        }
        if (this.o != null) {
            this.webView.removeEventFilter(MouseEvent.MOUSE_EXITED, this.o);
        }
        if (this.n != null) {
            this.removeEventFilter(MouseEvent.DRAG_DETECTED, this.n);
        }
        if (this.B != null) {
            this.removeEventFilter(MouseEvent.MOUSE_DRAGGED, this.B);
        }
        if (this.u != null) {
            this.removeEventFilter(KeyEvent.KEY_PRESSED, this.u);
        }
        if (this.u != null) {
            this.removeEventFilter(KeyEvent.KEY_RELEASED, this.u);
        }
        this.i = !this.p && this.emulator.getHostApplication().getCanCloseProperty().get();
        this.eliminateReferences();
    }

    protected void eliminateReferences() {
        Platform.runLater((Runnable)this.A);
    }

    public boolean isEmuBusy() {
        b.log(Level.INFO, "Calling isBusy() - still outside of Callable");
        Object object = new Callable<Boolean>(this){
            private /* synthetic */ EmulatorView a;
            {
                void var1_1;
                this.a = var1_1;
            }

            @Override
            public Boolean call() {
                boolean bl;
                try {
                    bl = (Boolean)this.a.executeScript("calc_instance.isBusy()");
                }
                catch (NullPointerException nullPointerException) {
                    bl = true;
                }
                return bl;
            }
        };
        Object object2 = new Callable<Boolean>(this){
            private /* synthetic */ EmulatorView a;
            {
                void var1_1;
                this.a = var1_1;
            }

            @Override
            public Boolean call() {
                boolean bl;
                try {
                    bl = (Boolean)this.a.executeScript("calc_instance.isInitializing()");
                }
                catch (Exception exception) {
                    bl = true;
                }
                return bl;
            }
        };
        if (this.z || this.C && this.j == null) {
            return true;
        }
        object = new FutureTask<Boolean>((Callable<Boolean>)object);
        object2 = new FutureTask<Boolean>((Callable<Boolean>)object2);
        if (Platform.isFxApplicationThread()) {
            ((FutureTask)object).run();
            ((FutureTask)object2).run();
        } else {
            Platform.runLater((Runnable)object);
            Platform.runLater((Runnable)object2);
        }
        try {
            object = (Boolean)((FutureTask)object).get();
            object2 = (Boolean)((FutureTask)object2).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            b.log(Level.WARNING, "Thread was interrupted or execution exception.", exception.getMessage());
            return true;
        }
        return ((Boolean)object).booleanValue() || ((Boolean)object2).booleanValue();
    }

    public int commStart() {
        FutureTask<Comparable<Boolean>> futureTask;
        Boolean bl;
        b.log(Level.INFO, "Calling commStart() - still outside of Callable");
        Callable<Boolean> callable = new Callable<Boolean>(this){
            private /* synthetic */ EmulatorView a;
            {
                void var1_1;
                this.a = var1_1;
            }

            @Override
            public Boolean call() {
                boolean bl;
                b.log(Level.INFO, "Calling isBusy()- inside of Callable");
                try {
                    bl = (Boolean)this.a.executeScript("calc_instance.isBusy()");
                }
                catch (NullPointerException nullPointerException) {
                    bl = true;
                }
                return bl;
            }
        };
        Callable<Boolean> callable2 = new Callable<Boolean>(this){
            private /* synthetic */ EmulatorView a;
            {
                void var1_1;
                this.a = var1_1;
            }

            @Override
            public Boolean call() {
                boolean bl;
                try {
                    bl = (Boolean)this.a.executeScript("calc_instance.isInitializing()");
                }
                catch (Exception exception) {
                    bl = true;
                }
                return bl;
            }
        };
        Callable<Integer> callable3 = new Callable<Integer>(this){
            private /* synthetic */ EmulatorView a;
            {
                void var1_1;
                this.a = var1_1;
            }

            @Override
            public Integer call() {
                b.log(Level.INFO, "Calling commStart() - inside of Callable");
                this.a.executeScript("calc_instance.commStart()");
                return 0;
            }
        };
        do {
            if ((bl = Boolean.valueOf(this.j != null)).booleanValue()) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                b.log(Level.WARNING, "Thread was interrupted.", interruptedException.getMessage());
            }
        } while (!bl.booleanValue() && !this.z);
        if (this.z) {
            return 0;
        }
        Boolean bl2 = null;
        bl = null;
        do {
            futureTask = new FutureTask<Boolean>(callable);
            FutureTask<Boolean> futureTask2 = new FutureTask<Boolean>(callable2);
            if (Platform.isFxApplicationThread()) {
                futureTask.run();
                futureTask2.run();
            } else {
                Platform.runLater(futureTask);
                Platform.runLater(futureTask2);
            }
            try {
                bl2 = futureTask.get();
                bl = futureTask2.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                b.log(Level.SEVERE, "Error getting isBusy/isInitializing", exception.getMessage());
            }
            if (!bl2.booleanValue() && !bl.booleanValue()) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                b.log(Level.SEVERE, "Thread was interrupted. " + interruptedException.getMessage());
            }
        } while ((bl2.booleanValue() || bl.booleanValue()) && !this.z && !PythonCommManager.getInstance().isPythonScriptRunning());
        if (this.z) {
            return 0;
        }
        futureTask = new FutureTask<Integer>(callable3);
        if (Platform.isFxApplicationThread()) {
            futureTask.run();
        } else {
            Platform.runLater(futureTask);
        }
        return 0;
    }

    public int commEnd() {
        b.log(Level.INFO, "Calling commEnd() - still outside of Callable");
        try {
            Callable<Boolean> callable = new Callable<Boolean>(this){
                private /* synthetic */ EmulatorView a;
                {
                    void var1_1;
                    this.a = var1_1;
                }

                @Override
                public Boolean call() {
                    boolean bl;
                    b.log(Level.INFO, "Calling isBusy()- inside of Callable");
                    try {
                        bl = (Boolean)this.a.executeScript("calc_instance.isBusy()");
                    }
                    catch (NullPointerException nullPointerException) {
                        bl = true;
                    }
                    return bl;
                }
            };
            FutureTask<Boolean> futureTask = new Callable<Integer>(this){
                private /* synthetic */ EmulatorView a;
                {
                    void var1_1;
                    this.a = var1_1;
                }

                @Override
                public Integer call() {
                    b.log(Level.INFO, "Calling commStart() - inside of Callable");
                    this.a.executeScript("calc_instance.commEnd()");
                    return 0;
                }
            };
            Callable<Boolean> callable2 = new Callable<Boolean>(this){
                private /* synthetic */ EmulatorView a;
                {
                    void var1_1;
                    this.a = var1_1;
                }

                @Override
                public Boolean call() {
                    boolean bl;
                    try {
                        bl = (Boolean)this.a.executeScript("calc_instance.isInitializing()");
                    }
                    catch (Exception exception) {
                        bl = true;
                    }
                    return bl;
                }
            };
            SimpleBooleanProperty simpleBooleanProperty = new SimpleBooleanProperty();
            SimpleBooleanProperty simpleBooleanProperty2 = new SimpleBooleanProperty();
            futureTask = new ChangeListener<Boolean>(this, (Callable)((Object)futureTask)){
                private /* synthetic */ Callable a;
                {
                    this.a = callable;
                }

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    FutureTask futureTask = new FutureTask(this.a);
                    if (Platform.isFxApplicationThread()) {
                        futureTask.run();
                        return;
                    }
                    Platform.runLater(futureTask);
                }
            };
            simpleBooleanProperty.addListener((ChangeListener)futureTask);
            simpleBooleanProperty2.addListener((ChangeListener)futureTask);
            do {
                futureTask = new FutureTask<Boolean>(callable);
                FutureTask<Boolean> futureTask2 = new FutureTask<Boolean>(callable2);
                if (Platform.isFxApplicationThread()) {
                    futureTask.run();
                    futureTask2.run();
                } else {
                    Platform.runLater(futureTask);
                    Platform.runLater(futureTask2);
                }
                try {
                    simpleBooleanProperty.setValue(futureTask.get());
                    simpleBooleanProperty2.setValue(futureTask2.get());
                }
                catch (InterruptedException | ExecutionException exception) {
                    b.severe("Error while querying emulator " + exception.getMessage());
                }
                if (!simpleBooleanProperty.get() && !simpleBooleanProperty2.get()) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    b.severe("Error while sleeping. Were waiting for emulator queries isBusyQuery & isInitializingQuery " + interruptedException.getMessage());
                }
            } while (simpleBooleanProperty.get() || simpleBooleanProperty2.get());
        }
        catch (Exception exception) {
            b.severe("Error while disconnecting. " + exception.getMessage());
        }
        return 0;
    }

    public boolean isInitialized() {
        boolean bl = false;
        try {
            Callable<Boolean> callable = new Callable<Boolean>(this){
                private /* synthetic */ EmulatorView a;
                {
                    void var1_1;
                    this.a = var1_1;
                }

                @Override
                public Boolean call() {
                    boolean bl;
                    b.log(Level.INFO, "Calling isInitialized()- inside of Callable");
                    try {
                        if (!this.a.emulator.isEmulatorFinishLoading()) {
                            return Boolean.FALSE;
                        }
                        bl = (Boolean)this.a.executeScript("calc_instance.isInitialized()");
                    }
                    catch (NullPointerException nullPointerException) {
                        bl = false;
                    }
                    return bl;
                }
            };
            bl = (Boolean)this.emulator.getHostApplication().getConcurrencyManager().runOnApplicationThread((Callable)callable);
            return bl;
        }
        catch (Exception exception) {
            b.severe("Error while querying Emulator - isInitialized");
            return bl;
        }
    }

    public boolean getMultiviewItems(String selected) {
        boolean bl;
        String string = "calc_instance.getViewCubedScreens('" + selected + "')";
        b.log(Level.INFO, "Calling " + string);
        this.isView3Refreshing = bl = ((Boolean)this.executeScript(string)).booleanValue();
        return bl;
    }

    public void cancelMultiviewRefresh() {
        String string = "calc_instance.cancelViewCubedAction()";
        b.log(Level.INFO, "Calling " + string);
        this.executeScript(string);
    }

    /*
     * WARNING - void declaration
     */
    public void setV3GraphSpeed(int speed) {
        void var1_1;
        b.log(Level.INFO, "Setting V3 Graph Speed to " + speed);
        this.executeScript("calc_instance.setView3GraphSpeed(" + (int)var1_1 + ")");
    }

    public String getV3GraphSpeed() {
        int n = ((JSNumber)this.executeScript("calc_instance.getView3GraphSpeed()")).getInteger();
        b.log(Level.INFO, "V3 Graph Speed set to " + n + " ms.");
        return Integer.toString(n);
    }

    /*
     * WARNING - void declaration
     */
    public void setEasyDataReadSpeed(int numInstructionsPerRead) {
        void var1_1;
        this.executeScript("calc_instance.setEasyDataReadSpeed(" + (int)var1_1 + ")");
    }

    public void setMultiviewShutdownSignal() {
        this.l = true;
        this.cancelMultiviewRefresh();
    }

    public boolean commTrnsStart() {
        b.log(Level.INFO, "Starting communication");
        return (Boolean)this.executeScript("calc_instance.commTrnsStart()");
    }

    public boolean commTrnsEnd() {
        b.log(Level.INFO, "Finishing communication.");
        return (Boolean)this.executeScript("calc_instance.commTrnsEnd()");
    }

    public boolean sendOnKey() {
        Object object = this.executeScript("calc_instance.sendOnKey()");
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    public boolean isShuttingDown() {
        return this.z;
    }

    /*
     * WARNING - void declaration
     */
    public boolean sendAndReleaseKeyJS(String keyName, long giveUpTime) {
        boolean bl = false;
        boolean bl2 = false;
        if (giveUpTime != -1L) {
            void var2_2;
            long l = System.currentTimeMillis() + var2_2;
            while (!this.isEmuReadyForKey()) {
                if (System.currentTimeMillis() >= l) {
                    bl2 = true;
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    b.log(Level.WARNING, "Thread was interrupted while waiting for emulator ready for key.", interruptedException.getMessage());
                }
            }
        }
        if (!bl2) {
            try {
                void var1_1;
                Object object = this.executeScript("calc_instance.sendAndReleaseSVGKey(\"".concat((String)var1_1).concat("\")"));
                if (object != null) {
                    bl = (Boolean)object;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isEmuReadyForKey() {
        boolean bl = false;
        try {
            Object object = this.executeScript("calc_instance.isReadyForKey()");
            if (object != null) {
                bl = (Boolean)object;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean isAlphaOn() {
        boolean bl;
        try {
            bl = (Boolean)this.executeScript("calc_instance.isAlphaOn()");
        }
        catch (NullPointerException nullPointerException) {
            bl = false;
        }
        return bl;
    }

    public boolean is2ndOn() {
        boolean bl;
        try {
            bl = (Boolean)this.executeScript("calc_instance.is2ndOn()");
        }
        catch (NullPointerException nullPointerException) {
            bl = false;
        }
        return bl;
    }

    public boolean isExecutingProgram() {
        boolean bl;
        try {
            bl = (Boolean)this.executeScript("calc_instance.isExecutingProgram()");
        }
        catch (NullPointerException nullPointerException) {
            bl = false;
        }
        return bl;
    }

    public boolean isEmuGraphing() {
        boolean bl;
        try {
            bl = (Boolean)this.executeScript("calc_instance.isEmuGraphing()");
        }
        catch (NullPointerException nullPointerException) {
            bl = false;
        }
        return bl;
    }

    public String getEmulatorSVGKeyPrefix() {
        String string = null;
        Object object = this.executeScript("calc_instance.getEmulatorSVGKeyPrefix()");
        if (object != null && object instanceof JSString) {
            string = ((JSString)object).getStringValue();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public void setCommunicationSupport(boolean supportsCommunication) {
        void var1_1;
        this.C = var1_1;
    }

    public BrowserContext createBrowserContext() {
        BrowserContext browserContext = null;
        try {
            this.r = Files.createTempDirectory("SVEmulatorContext", new FileAttribute[0]);
            browserContext = new BrowserContext(new BrowserContextParams(this.r.toString()));
            b.log(Level.FINE, "Browser context created on " + browserContext.getDataDir());
        }
        catch (IOException iOException) {
            b.log(Level.INFO, "Browser context cannot be created on a temp file");
        }
        return browserContext;
    }

    public void cleanBrowserContextFolders() {
        if (this.r != null) {
            b.log(Level.INFO, "Marking current Context folder as deleteOnExit...");
            EmulatorView emulatorView = this;
            emulatorView.a(emulatorView.r.toFile());
        }
    }

    private void a(File file) {
        if (file != null) {
            file.deleteOnExit();
            b.log(Level.FINEST, "Mark delete on exit, for file " + file.getName());
            if (file.isDirectory()) {
                try {
                    Files.list(file.toPath()).forEach(path -> this.a(path.toFile()));
                    return;
                }
                catch (IOException iOException) {
                    b.log(Level.SEVERE, "Something went wrong when trying to delete BrowserContext files: " + iOException.getMessage());
                }
            }
        }
    }

    public boolean appLevelResetEmulator() {
        boolean bl = false;
        if (this.emulator != null && this.emulator.isInitialized() && !this.emulator.isEmuBusy()) {
            bl = this.emulator.getHostApplication().appLevelResetEmulator();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<List<Integer>> ta_sendCommand(String buffer, int length) {
        void var2_2;
        void var1_1;
        return CompletableFuture.supplyAsync(() -> this.a((String)var1_1, (int)var2_2));
    }

    private /* synthetic */ List a(String object, int n) {
        JSObject jSObject = (JSObject)this.executeScript("calc_instance");
        object = new TACommand(this, (String)object, n);
        jSObject.removeProperty("taCommand");
        jSObject.setProperty("taCommand", object);
        JSFunction jSFunction = jSObject.getProperty("ta_sendCommand").asFunction();
        jSFunction.invoke(jSObject, new Object[0]);
        return ((TACommand)object).getResponse();
    }

    private class ExecuteScriptCallable
    implements Callable<Object> {
        private String a;
        private /* synthetic */ EmulatorView b;

        private ExecuteScriptCallable(EmulatorView emulatorView) {
            this.b = emulatorView;
        }

        /*
         * WARNING - void declaration
         */
        public void setScriptCode(String scriptCode) {
            void var1_1;
            this.a = var1_1;
        }

        @Override
        public Object call() throws Exception {
            String string = this.a.length() > 100 ? this.a.substring(0, 100) : this.a;
            b.log(Level.INFO, "Running " + string);
            return this.b.webEngine.executeJavaScriptAndReturnValue(this.a);
        }
    }

    class IOProxy {
        private VirtualStreamInterface a;
        private Thread b = null;
        private boolean c = false;
        private int d = -1;
        private int e = 0;
        private String f = null;
        private String g = null;

        /*
         * WARNING - void declaration
         */
        public IOProxy(EmulatorView this$0, VirtualStreamInterface virtualStream) {
            void var2_2;
            this.a = var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int openIOStream() {
            this.b = new Thread(this, "innerIOProxy"){
                private /* synthetic */ IOProxy a;
                {
                    void var2_2;
                    void var1_1;
                    this.a = var1_1;
                    super((String)var2_2);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    IOProxy iOProxy = this.a;
                    synchronized (iOProxy) {
                        this.a.d = this.a.a.openIOStream();
                        EmulatorView.b.log(Level.INFO, "IOProxy openIOStream and id is " + this.a.d);
                        this.a.notifyAll();
                    }
                    while (true) {
                        iOProxy = this.a;
                        synchronized (iOProxy) {
                            while (this.a.e == 0 && !this.a.c) {
                                try {
                                    this.a.wait(1000L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        if (this.a.c) break;
                        switch (this.a.e) {
                            case 1: {
                                this.a.f = this.a.a.readIOStream();
                                this.a.a();
                                break;
                            }
                            case 2: {
                                this.a.a.writeIOStream(this.a.g);
                                this.a.a();
                            }
                        }
                    }
                    this.a.a.closeIOStream();
                    EmulatorView.b.log(Level.INFO, "IOProxy closeIOStream");
                }
            };
            this.b.setDaemon(true);
            this.b.start();
            IOProxy iOProxy = this;
            synchronized (iOProxy) {
                while (this.d < 0 && !this.c) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            return this.d;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a() {
            IOProxy iOProxy = this;
            synchronized (iOProxy) {
                this.e = 0;
                this.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void b() {
            IOProxy iOProxy = this;
            synchronized (iOProxy) {
                while (this.e != 0 && !this.c) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String readIOStream() {
            IOProxy iOProxy = this;
            synchronized (iOProxy) {
                this.e = 1;
                this.notifyAll();
            }
            this.b();
            return this.f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void writeIOStream(String outBuffer) {
            IOProxy iOProxy = this;
            synchronized (iOProxy) {
                void var1_1;
                this.g = var1_1;
                this.e = 2;
                this.notifyAll();
            }
            this.b();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeIOStream() {
            IOProxy iOProxy = this;
            synchronized (iOProxy) {
                b.log(Level.INFO, "Closing IOStream");
                this.c = true;
                this.notifyAll();
                return;
            }
        }
    }

    protected class EmulatorViewWebListener
    implements LoadListener {
        private String a;
        private boolean b;
        private JSSkinManager c = null;
        private /* synthetic */ EmulatorView d;

        /*
         * WARNING - void declaration
         */
        public EmulatorViewWebListener(EmulatorView this$0, JSSkinManager skinManager, String currentFaceplate, boolean noDisplay, JSLargeScreenView largeScreenView) {
            void var2_2;
            void var3_3;
            void var1_1;
            this.d = var1_1;
            this.a = var3_3;
            this.b = noDisplay;
            this.c = var2_2;
            largeScreenView.setNoRefresh(noDisplay);
        }

        public void onFinishLoadingFrame(FinishLoadingEvent arg0) {
            b.log(Level.INFO, "Main Frame has finished loading.");
            JSValue jSValue = (JSValue)this.d.executeScript("window");
            if (this.d.C) {
                if (k == 0) {
                    this.d.j = new TCPClientVirtualStream();
                } else if (k == 1) {
                    b.log(Level.INFO, "JavaPluginVirtualStream() created");
                    this.d.j = new JavaPluginVirtualStream();
                } else {
                    b.log(Level.INFO, "JavaPluginVirtualStreamChannel() created");
                    this.d.j = new JavaPluginVirtualStreamChannel();
                }
            }
            if (jSValue != null) {
                jSValue.asObject().setProperty("app", (Object)this.d.new JavaApp(this.d.j));
            }
            Object object = this.c.getBGColor(this.a, this.b);
            this.d.paintBGColor((String)object);
            if (this.d.executeScript("var state_sv = " + (this.d.d != null ? this.d.d.getData() : null)) == null) {
                b.log(Level.SEVERE, "Error loading StateFile");
                b.log(Level.SEVERE, "Restoring to Default State");
                this.d.forceReinitFlag = true;
                this.d.i = true;
                this.d.shutDown();
                return;
            }
            b.log(Level.INFO, "Launch emulator...");
            object = "calc_instance.launchEmulator(state_sv, " + this.b + ", '" + (String)object + "', '" + this.c.getThemeName(this.a) + "')";
            this.d.executeScript((String)object);
            Platform.runLater(() -> this.d.largeScreenView.setDisplaySettings(this.d.getDisplaySettings()));
            this.d.emulator.notifyEmulatorFinishLoading(true);
            int n = 20;
            while (!this.d.isInitialized() && n > 0) {
                --n;
                b.log(Level.INFO, "Waiting for EMU to be initialized");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.d.a();
            if (this.d.emulator.supportsUserStatefiles()) {
                b.log(Level.INFO, "About to get metadata from javascript");
                jSValue.asObject().setProperty("metadata", (Object)this.d.emulator.getHostApplication().getMetadata());
                this.d.emulator.getHostApplication().getMetadata().storeMetadata(this.d.getCurrentMetadata());
            } else if (jSValue != null && jSValue.asObject().hasProperty("metadata")) {
                jSValue.asObject().removeProperty("metadata");
            }
            this.d.q.stream().forEach(iPluginListener -> iPluginListener.onPluginFinishLoading());
        }

        public void onStartLoadingFrame(StartLoadingEvent event) {
            if (event.isMainFrame()) {
                this.d.emulator.notifyEmulatorFinishLoading(false);
                b.log(Level.INFO, "Main frame has started loading");
                this.d.q.stream().forEach(iPluginListener -> iPluginListener.onPluginStartLoading());
            }
        }

        public void onProvisionalLoadingFrame(ProvisionalLoadingEvent event) {
            if (event.isMainFrame()) {
                b.log(Level.INFO, "Provisional load was committed for a frame");
            }
        }

        /*
         * WARNING - void declaration
         */
        public void onFailLoadingFrame(FailLoadingEvent event) {
            void var1_1;
            NetError netError = event.getErrorCode();
            if (var1_1.isMainFrame()) {
                b.log(Level.INFO, "Main frame has failed loading: " + netError);
                this.d.webEngine.loadHTML("<html><body></body></html>");
            }
        }

        public void onDocumentLoadedInFrame(FrameLoadEvent event) {
            b.log(Level.INFO, "Frame document is loaded.");
        }

        public void onDocumentLoadedInMainFrame(LoadEvent event) {
            b.log(Level.INFO, "Main frame document is loaded.");
        }
    }

    private static class TIImageImpl
    implements ITIImage {
        private static final long serialVersionUID = 1L;
        private byte[] a;
        private int b = 0;
        private int c = 0;

        /*
         * WARNING - void declaration
         */
        public TIImageImpl(int pixelsWide, int pixelsHeight) {
            void var2_2;
            void var1_1;
            this.b = var1_1;
            this.c = var2_2;
        }

        public int[] getImageDataAsARGB() {
            return new int[0];
        }

        public byte[] getImageData() {
            return this.a;
        }

        /*
         * WARNING - void declaration
         */
        public void setImageData(byte[] imageData) {
            void var1_1;
            this.a = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setPixelsWide(short pixelsWide) {
            void var1_1;
            this.b = var1_1;
        }

        public int getPixelsWide() {
            return this.b;
        }

        /*
         * WARNING - void declaration
         */
        public void setPixelsHeight(short pixelsHeight) {
            void var1_1;
            this.c = var1_1;
        }

        public int getPixelsHeight() {
            return this.c;
        }
    }

    public class JavaApp {
        private DisplaySettings b = null;
        private VirtualStreamInterface c;
        private boolean d = false;
        private int[][] e = null;
        private JSMultiviewItem[] f = new JSMultiviewItem[6];
        private LargeScreenDrawRunnable g = new LargeScreenDrawRunnable(this);
        private SetMultiviewScreenRunnable h = new SetMultiviewScreenRunnable(this);

        /*
         * WARNING - void declaration
         */
        public JavaApp(VirtualStreamInterface virtualStream) {
            void var2_2;
            b.log(Level.INFO, "JavaApp()");
            this.c = var2_2;
            var1_1.javaApp = this;
        }

        public void exit() {
            Platform.exit();
        }

        public DisplaySettings getDisplaySettings() {
            return this.b;
        }

        /*
         * WARNING - void declaration
         */
        public void setScreenCaptureData(String data) {
            void var1_1;
            EmulatorView.this.screenCaptureAvailable.set(true);
            EmulatorView.this.screenContents = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void keyPressed(String key, double timePressed) {
            if (EmulatorView.this.emulator.getHostApplication() != null) {
                void var2_2;
                void var1_1;
                EmulatorView.this.emulator.getHostApplication().keyPressed((String)var1_1, Math.round((double)var2_2));
            }
        }

        /*
         * WARNING - void declaration
         */
        public void notifyIsOnExtAppOrTransApp(boolean isOnExtAppOrTransApp) {
            void var1_1;
            b.log(Level.FINEST, "Is on External app or Transformation app: " + isOnExtAppOrTransApp);
            Platform.runLater(() -> this.a((boolean)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public DisplaySettings createDisplaySettings(int rows, int cols, int pixelsPerProcessor, String bgColor, String fgColor, int bitMode) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.b = new DisplaySettings((int)var1_1, (int)var2_2, (int)var3_3, bgColor, fgColor, bitMode);
            return this.b;
        }

        /*
         * WARNING - void declaration
         */
        public void setScreenUnidimentionalDataStrComp(String s) {
            void var1_1;
            this.g.setString((String)var1_1);
            Platform.runLater((Runnable)this.g);
        }

        private int[][] a(String string, boolean bl) {
            if (this.b != null) {
                int n = this.b.getRows();
                int n2 = this.b.getColumns();
                if (this.e == null) {
                    this.e = new int[n][n2];
                }
                try {
                    int n3 = 0;
                    ++n3;
                    int n4 = JavaApp.a(string.charAt(0));
                    if (!bl) {
                        ++n3;
                        n4 |= JavaApp.a(string.charAt(1)) << 8;
                    }
                    int n5 = 1;
                    if (string.charAt(n3) == '\u0101') {
                        n5 = Integer.parseInt(string.substring(++n3, string.indexOf(257, n3)));
                        n3 = string.indexOf(257, n3) + 1;
                    }
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            if (n5 <= 0) {
                                n4 = JavaApp.a(string.charAt(n3++));
                                if (!bl) {
                                    n4 |= JavaApp.a(string.charAt(n3++)) << 8;
                                }
                                if (n3 >= string.length()) {
                                    this.e[j][i] = n4;
                                    continue;
                                }
                                if (string.charAt(n3) == '\u0101') {
                                    n5 = Integer.parseInt(string.substring(++n3, string.indexOf(257, n3)));
                                    n3 = string.indexOf(257, n3) + 1;
                                }
                            }
                            this.e[j][i] = n4;
                            --n5;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    b.log(Level.INFO, "NumberFormatException " + string, numberFormatException);
                }
            }
            return this.e;
        }

        private static int a(char c) {
            if (c == '\u0100') {
                return 0;
            }
            return c;
        }

        /*
         * WARNING - void declaration
         */
        public void setMultiviewScreen(int imgId, String s) {
            void var2_2;
            void var1_1;
            this.h.setImgId((int)var1_1);
            this.h.setString((String)var2_2);
            this.h.run();
        }

        private ITIMultiviewItem a(int n, String string) {
            boolean bl;
            String string2 = EmulatorView.this.emulator.getCalculatorModelName();
            boolean bl2 = bl = string2.equals("TI84") || string2.equals("TI83");
            if (this.f[n] == null) {
                this.f[n] = new JSMultiviewItem(n, this.a(string, bl), this.b);
            } else {
                this.f[n].setPixels(this.a(string, bl));
            }
            return this.f[n];
        }

        public void multiviewProcessComplete() {
            b.log(Level.INFO, "View3 Completed");
            EmulatorView.this.isView3Refreshing = false;
            Platform.runLater(() -> EmulatorView.this.emulator.getHostApplication().setMultiviewProgress(6));
        }

        public boolean checkShutdownCallback() {
            if (EmulatorView.this.l) {
                b.log(Level.INFO, "View3 was cancelled at Shutdown");
            } else {
                b.log(Level.FINEST, "View3 was cancelled but not at Shutdown");
            }
            return EmulatorView.this.l;
        }

        /*
         * WARNING - void declaration
         */
        public void logFromJS(String level, String message) {
            void var2_2;
            Level level2 = Level.parse(level);
            b.log(level2, (String)var2_2);
        }

        public void LCDClickEvent() {
            EmulatorView.this.e = true;
        }

        public void resetCommLayer() {
            EmulatorView.this.emulator.getHostApplication().resetCommLayer();
        }

        public int goIOStartSession() {
            b.log(Level.INFO, "Starting GoIO Session");
            EmulatorView.this.emulator.setHasDCStarted(true);
            return GoIOCommManager.getInstance().startSession();
        }

        public boolean goIOEndSession() {
            EmulatorView.this.emulator.setHasDCStarted(false);
            return true;
        }

        public boolean goIOStartInputStream() {
            return GoIOCommManager.getInstance().startInputStream();
        }

        public boolean goIOStopInputStream() {
            return GoIOCommManager.getInstance().stopInputStream();
        }

        /*
         * WARNING - void declaration
         */
        public boolean goIOSendCommand(String commandBuffer) {
            void var1_1;
            return GoIOCommManager.getInstance().sendCommand((String)var1_1);
        }

        public String goIOGetResponse() {
            return GoIOCommManager.getInstance().getResponse();
        }

        public boolean isCurrentSensorStillConnected() {
            return GoIOCommManager.getInstance().isCurrentSensorStillConnected();
        }

        public int pythonStart() {
            b.log(Level.INFO, "Python Start");
            return PythonCommManager.getInstance().pythonStart();
        }

        public int pythonState() {
            return PythonCommManager.getInstance().pythonState();
        }

        public int pythonCheckLinkState() {
            return PythonCommManager.getInstance().pythonCheckLinkState();
        }

        public void pythonFinish() {
            b.log(Level.INFO, "Python Finish");
            PythonCommManager.getInstance().pythonFinish(true);
        }

        /*
         * WARNING - void declaration
         */
        public int pythonSend(String bytesAsHexStr) {
            void var1_1;
            return PythonCommManager.getInstance().pythonSend((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public String pythonGet(int maxLength) {
            void var1_1;
            return PythonCommManager.getInstance().pythonGet((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public int msGetMaxLUN(int maxLUN) {
            void var1_1;
            return PythonCommManager.getInstance().msGetMaxLUN((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void msResetInterface(int op) {
            void var1_1;
            PythonCommManager.getInstance().msResetInterface((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public String msInquiry(int lunIdx) {
            void var1_1;
            return PythonCommManager.getInstance().msInquiry((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public String msReadBlock(int lunIdx, int numBlocks, int blockAddress, int blockSize) {
            void var3_3;
            void var2_2;
            void var1_1;
            return PythonCommManager.getInstance().msReadBlock((int)var1_1, (int)var2_2, (int)var3_3, blockSize);
        }

        /*
         * WARNING - void declaration
         */
        public int msWriteBlock(int lunIdx, int numBlocks, int blockAddress, int blockSize, String bytesAsHexStr) {
            void var3_3;
            void var2_2;
            void var1_1;
            return PythonCommManager.getInstance().msWriteBlock((int)var1_1, (int)var2_2, (int)var3_3, blockSize, bytesAsHexStr);
        }

        public int openIOStream() {
            this.d = false;
            if (EmulatorView.this.y != null) {
                EmulatorView.this.y.closeIOStream();
            }
            EmulatorView.this.y = new IOProxy(EmulatorView.this, this.c);
            return EmulatorView.this.y.openIOStream();
        }

        public String readIOStream() {
            if (!this.d) {
                b.log(Level.INFO, "readIOStream setupComm");
                this.d = true;
                EmulatorView.this.emulator.getHostApplication().setupComm();
            }
            String string = "";
            if (EmulatorView.this.y != null) {
                string = EmulatorView.this.y.readIOStream();
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        public void writeIOStream(String outBuffer) {
            if (EmulatorView.this.y != null) {
                void var1_1;
                EmulatorView.this.y.writeIOStream((String)var1_1);
            }
        }

        public void closeIOStream() {
            if (EmulatorView.this.y != null) {
                b.log(Level.INFO, "Calling ioProxy.closeIOStream");
                EmulatorView.this.y.closeIOStream();
                EmulatorView.this.y = null;
            }
        }

        private /* synthetic */ void a(boolean bl) {
            EmulatorView.this.emulator.getHostApplication().disableV3ForExtApp(bl);
        }

        private final class LargeScreenDrawRunnable
        implements Runnable {
            private String a;
            private /* synthetic */ JavaApp b;

            private LargeScreenDrawRunnable(JavaApp javaApp) {
                this.b = javaApp;
            }

            /*
             * WARNING - void declaration
             */
            public final void setString(String s) {
                void var1_1;
                this.a = var1_1;
            }

            @Override
            public final void run() {
                if (!this.b.EmulatorView.this.emulator.getHostApplication().onExplorerWS()) {
                    String string = this.b.EmulatorView.this.emulator.getCalculatorModelName();
                    if (string.equals("TI84") || string.equals("TI83") || string.equals("TI30MV") || string.equals("TI34MV") || string.equals("TI30XPRO") || string.equals("TI30XPLUS")) {
                        this.b.EmulatorView.this.largeScreenView.drawScreen(this.b.a(this.a, true));
                        return;
                    }
                    this.b.EmulatorView.this.largeScreenView.drawScreen(this.b.a(this.a, false));
                }
            }
        }

        private final class SetMultiviewScreenRunnable
        implements Runnable {
            private String a;
            private int b;
            private /* synthetic */ JavaApp c;

            private SetMultiviewScreenRunnable(JavaApp javaApp) {
                this.c = javaApp;
            }

            /*
             * WARNING - void declaration
             */
            public final void setString(String s) {
                void var1_1;
                this.a = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public final void setImgId(int i) {
                void var1_1;
                this.b = var1_1;
            }

            @Override
            public final void run() {
                EmulatorView.b.log(Level.INFO, "Setting image with Id: " + this.b);
                ITIMultiviewItem iTIMultiviewItem = this.c.a(this.b, this.a);
                Platform.runLater(() -> this.c.EmulatorView.this.emulator.getHostApplication().setMultiviewItem(iTIMultiviewItem));
            }
        }
    }

    public class TACommand {
        private String a;
        private int b;
        private List<Integer> c;
        private boolean d;

        /*
         * WARNING - void declaration
         */
        public TACommand(EmulatorView this$0, String taBuffer, int lengthDesignation) {
            void var3_3;
            void var2_2;
            this.setTABuffer((String)var2_2);
            this.setLengthDesignation((int)var3_3);
            this.d = false;
        }

        public String getTABuffer() {
            return this.a;
        }

        /*
         * WARNING - void declaration
         */
        public void setTABuffer(String taBuffer) {
            void var1_1;
            this.a = var1_1.trim().replace(" ", "");
        }

        public int getLengthDesignation() {
            return this.b;
        }

        /*
         * WARNING - void declaration
         */
        public void setLengthDesignation(int lengthDesignation) {
            void var1_1;
            this.b = var1_1;
        }

        public boolean isResolved() {
            return this.d;
        }

        /*
         * WARNING - void declaration
         */
        public void setResolved(boolean resolved) {
            void var1_1;
            this.d = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void setResponse(JSObject jsResponse) {
            if (jsResponse != null) {
                void var1_1;
                this.c = new ArrayList<Integer>();
                b.log(Level.INFO, "Got response from Emulator.");
                jsResponse.getPropertyNames().forEach(arg_0 -> this.a((JSObject)var1_1, arg_0));
            } else {
                b.log(Level.INFO, "No response!");
            }
            this.setResolved(true);
        }

        public List<Integer> getResponse() {
            long l = System.currentTimeMillis() + 120000L;
            while (!this.isResolved() && System.currentTimeMillis() < l) {
                b.log(Level.FINE, "Waiting for a response...");
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    b.log(Level.INFO, "Failed to set response: " + interruptedException.getMessage());
                }
            }
            return this.c;
        }

        private /* synthetic */ void a(JSObject jSObject, String string) {
            int n = jSObject.getProperty(string).asNumber().getInteger();
            this.c.add(n);
        }
    }
}

