/*
 * Decompiled with CFR 0.152.
 */
package com.ti.et.goioComm.viaHID;

import com.sun.jna.Platform;
import com.ti.et.elg.utils.ByteHexStringUtils;
import com.ti.et.goioComm.exports.GoIOComm;
import com.ti.et.goioComm.exports.GoIOSensor;
import com.ti.et.goioComm.viaHID.Hid4JavaSensor;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hid4java.HidDevice;
import org.hid4java.HidException;
import org.hid4java.HidManager;
import org.hid4java.HidServices;
import org.hid4java.HidServicesListener;
import org.hid4java.event.HidServicesEvent;

public class Hid4JavaComm
implements GoIOComm,
HidServicesListener {
    private HidServices a = null;
    private List<HidDevice> b;
    private static Logger c = Logger.getLogger(Hid4JavaComm.class.getSimpleName());
    private int d;

    @Override
    public boolean init() {
        try {
            this.a = HidManager.getHidServices(2295, 0);
        }
        catch (HidException hidException) {
            c.log(Level.SEVERE, hidException.getMessage(), hidException);
            return false;
        }
        if (this.a == null) {
            c.log(Level.SEVERE, "Error couldn't acquire HidServices!");
            return false;
        }
        this.b = this.a.getAttachedHidDevices();
        this.a.addHidServicesListener(this);
        return true;
    }

    @Override
    public boolean unInit() {
        return false;
    }

    @Override
    public synchronized GoIOSensor getFirstSensor() {
        if (this.b != null && !this.b.isEmpty()) {
            this.d = 1;
            Hid4JavaSensor hid4JavaSensor = new Hid4JavaSensor(this.b.get(0));
            return hid4JavaSensor;
        }
        return null;
    }

    @Override
    public synchronized GoIOSensor getNextSensor() {
        Hid4JavaSensor hid4JavaSensor = null;
        if (this.b != null && !this.b.isEmpty()) {
            if (this.d < this.b.size()) {
                hid4JavaSensor = new Hid4JavaSensor(this.b.get(this.d++));
            } else {
                this.d = 1;
            }
        }
        return hid4JavaSensor;
    }

    @Override
    public synchronized boolean openSensor(GoIOSensor sensor) {
        boolean bl = false;
        if (sensor != null) {
            if (!((Hid4JavaSensor)sensor).getInnerSensor().isOpen()) {
                bl = ((Hid4JavaSensor)sensor).getInnerSensor().open();
                if (bl) {
                    Hid4JavaComm hid4JavaComm;
                    void var2_3 = hid4JavaComm;
                    hid4JavaComm = this;
                    boolean bl2 = false;
                    if (var2_3 != null && (bl2 = hid4JavaComm.a((GoIOSensor)var2_3, (byte)26)) && var2_3.getSensorType() == 3 && (bl2 = hid4JavaComm.a((GoIOSensor)var2_3, (byte)40))) {
                        bl2 = hid4JavaComm.a((GoIOSensor)var2_3, (byte)41);
                        if (((Hid4JavaSensor)var2_3).getSensorId() < 20) {
                            ((Hid4JavaSensor)var2_3).setLongName(GoIOSensor.sensorID2sensorLongName.get(((Hid4JavaSensor)var2_3).getSensorId()));
                            c.log(Level.FINEST, "initSensor::longNameStr=" + ((Hid4JavaSensor)var2_3).getLongName());
                            ((Hid4JavaSensor)var2_3).setShortName(GoIOSensor.sensorID2sensorShortName.get(((Hid4JavaSensor)var2_3).getSensorId()));
                            c.log(Level.FINEST, "initSensor::shortNameStr=" + ((Hid4JavaSensor)var2_3).getShortName());
                        } else {
                            hid4JavaComm.a((GoIOSensor)var2_3, (byte)39, (byte)48, 56);
                        }
                    }
                    bl = bl2;
                } else {
                    c.log(Level.FINEST, "openSensor: Failed to open sensor!");
                }
            } else {
                c.log(Level.FINEST, "openSensor: Sensor to open is already opened!");
            }
        } else {
            c.log(Level.SEVERE, "openSensor: Sensor to open was null!");
        }
        return bl;
    }

    private boolean a(GoIOSensor goIOSensor, byte by, byte by2, int n) {
        byte[] byArray;
        boolean bl = false;
        if (goIOSensor != null && (bl = this.sendCommandPacket(goIOSensor, byArray = new byte[]{by, 0, by2, 0, 0, 0, 0, 0}))) {
            int n2;
            boolean bl2 = n > 8;
            byte[] byArray2 = new byte[n];
            int n3 = 0;
            byte[] byArray3 = new byte[8];
            int n4 = n % 8 > 0 ? n / 8 + 1 : n / 8;
            do {
                int n5 = 20;
                while ((n2 = this.getCommandResponsePacket(goIOSensor, byArray3, 50)) <= 0 && n5-- > 0 || !bl2 && n2 > 0 && byArray3[1] != by && n5-- > 0) {
                }
                if (n2 <= 0 || !bl2) continue;
                System.arraycopy(byArray3, 0, byArray2, n3, 8);
                n3 += 8;
            } while (bl2 && n3 < n && n4-- > 0);
            if (n2 > 0) {
                if (byArray3[1] == 40) {
                    c.log(Level.FINEST, "sendCmdAndGetResponse::setSensorId=" + byArray3[2] + "[0x" + Integer.toHexString(byArray3[2]) + "]");
                    ((Hid4JavaSensor)goIOSensor).setSensorId(byArray3[2]);
                }
                if (byArray2[1] == 39) {
                    byte[] byArray4 = new byte[20];
                    System.arraycopy(byArray2, 11, byArray4, 0, 5);
                    System.arraycopy(byArray2, 17, byArray4, 5, 7);
                    System.arraycopy(byArray2, 25, byArray4, 12, 7);
                    byArray4[19] = byArray2[33];
                    try {
                        ((Hid4JavaSensor)goIOSensor).setLongName(new String(byArray4, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        c.log(Level.SEVERE, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                    }
                    c.log(Level.FINEST, "sendCmdAndGetResponse::longNameStr=" + ((Hid4JavaSensor)goIOSensor).getLongName());
                    byte[] byArray5 = new byte[12];
                    System.arraycopy(byArray2, 34, byArray5, 0, 6);
                    System.arraycopy(byArray2, 41, byArray5, 5, 6);
                    try {
                        ((Hid4JavaSensor)goIOSensor).setShortName(new String(byArray5, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        c.log(Level.SEVERE, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                    }
                    c.log(Level.FINEST, "sendCmdAndGetResponse::shortNameStr=" + ((Hid4JavaSensor)goIOSensor).getShortName());
                }
            } else {
                c.log(Level.SEVERE, "sendCmdAndGetResponse::response NOT acquired!!");
                bl = false;
            }
        }
        return bl;
    }

    private boolean a(GoIOSensor goIOSensor, byte by) {
        return this.a(goIOSensor, by, (byte)0, 8);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void closeSensor(GoIOSensor sensor) {
        if (sensor != null) {
            if (((Hid4JavaSensor)sensor).getInnerSensor().isOpen()) {
                void var1_1;
                this.a(sensor, (byte)25);
                ((Hid4JavaSensor)var1_1).getInnerSensor().close();
                return;
            }
            c.log(Level.SEVERE, "closeSensor: Sensor to close was already closed!");
            return;
        }
        c.log(Level.SEVERE, "closeSensor: Sensor to close was null");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean sendCommandPacket(GoIOSensor sensor, byte[] commandPacket) {
        boolean bl = false;
        if (sensor != null) {
            if (((Hid4JavaSensor)sensor).getInnerSensor().isOpen()) {
                int n;
                if (Platform.isWindows()) {
                    byte[] byArray = new byte[9];
                    System.arraycopy(commandPacket, 0, byArray, 1, commandPacket.length);
                    n = ((Hid4JavaSensor)sensor).getInnerSensor().write(byArray, 9, (byte)0);
                } else {
                    n = ((Hid4JavaSensor)sensor).getInnerSensor().write(commandPacket, commandPacket.length, (byte)0);
                }
                if (n <= 0) {
                    void var1_1;
                    c.log(Level.SEVERE, "sendCommandPacket error: " + ((Hid4JavaSensor)var1_1).getInnerSensor().getLastErrorMessage());
                } else {
                    if (c.isLoggable(Level.FINEST)) {
                        void var2_2;
                        c.log(Level.FINEST, "sendCommandPacket: " + ByteHexStringUtils.byteArrayToHexString((byte[])var2_2));
                    }
                    bl = true;
                }
            } else {
                c.log(Level.SEVERE, "sendCommandPacket Sensor is closed!");
            }
        } else {
            c.log(Level.SEVERE, "sendCommandPacket Sensor is null!");
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized int getCommandResponsePacket(GoIOSensor sensor, byte[] responsePacket, int timeoutMs) {
        if (sensor != null && responsePacket.length == 8 && ((Hid4JavaSensor)sensor).getInnerSensor().isOpen()) {
            void var3_4;
            void var1_1;
            int n = ((Hid4JavaSensor)var1_1).getInnerSensor().read(responsePacket, (int)var3_4);
            if (n > 0 && c.isLoggable(Level.FINEST)) {
                void var2_3;
                c.log(Level.FINEST, "getCommandResponsePacket: " + ByteHexStringUtils.byteArrayToHexString((byte[])var2_3));
            }
            return n;
        }
        c.log(Level.SEVERE, "getCommandResponsePacket: Sensor is already closed!");
        return -1;
    }

    @Override
    public void clearIO(GoIOSensor sensor) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void hidDeviceAttached(HidServicesEvent arg0) {
        if (!this.b.contains(arg0.getHidDevice())) {
            void var1_1;
            c.log(Level.INFO, "hidDeviceAttached - Adding device to list:\n\t" + arg0.getHidDevice());
            this.b.add(var1_1.getHidDevice());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void hidDeviceDetached(HidServicesEvent arg0) {
        if (this.b.contains(arg0.getHidDevice())) {
            void var1_1;
            c.log(Level.INFO, "hidDeviceDetached - Removing device to list:\n\t" + arg0.getHidDevice());
            this.b.remove(var1_1.getHidDevice());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void hidFailure(HidServicesEvent arg0) {
        void var1_1;
        c.log(Level.SEVERE, "HID failure: " + arg0 != null ? (arg0.getHidDevice() != null ? var1_1.getHidDevice().getProduct() : "No device info") : "No hidService info");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized int getMeasurementResponsePacket(GoIOSensor sensor, byte[] responsePacket, int timeoutMs) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getCommandResponsePacket((GoIOSensor)var1_1, (byte[])var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean isStillConnected(GoIOSensor sensor) {
        void var1_1;
        boolean bl = false;
        int n = ((Hid4JavaSensor)var1_1).getInnerSensor().hashCode();
        if (this.a != null) {
            for (HidDevice hidDevice : this.b) {
                if (hidDevice.hashCode() != n) continue;
                bl = true;
                break;
            }
            if (!bl) {
                c.log(Level.SEVERE, "Device wasn't found!");
            }
        } else {
            c.log(Level.SEVERE, "Error couldn't acquire HidServices! - hidServices is Null");
        }
        return bl;
    }
}

