/*
 * Decompiled with CFR 0.152.
 */
package com.ti.et.goioComm.goioCommManager;

import com.ti.et.elg.utils.ByteHexStringUtils;
import com.ti.et.goioComm.exports.GoIOComm;
import com.ti.et.goioComm.exports.GoIOSensor;
import com.ti.et.goioComm.factory.GoIOCommFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;

public class GoIOCommManager {
    private static GoIOCommManager a = new GoIOCommManager();
    private static Logger b = Logger.getLogger(GoIOCommManager.class.getSimpleName());
    private GoIOComm c = null;
    private GoIOSensor d = null;
    private String e = null;
    private byte[] f = null;
    private boolean g = false;
    private boolean h = false;

    private GoIOCommManager() {
    }

    private void a() {
        this.e = null;
        this.f = null;
        this.g = false;
        this.h = false;
    }

    public static GoIOCommManager getInstance() {
        return a;
    }

    public static void releaseAndCreateNewInstance() {
        a = new GoIOCommManager();
    }

    public GoIOSensor getCurrentSensor() {
        if (this.isCurrentSensorStillConnected()) {
            return this.d;
        }
        return null;
    }

    public boolean isCollectingData() {
        return this.g;
    }

    public int startSession() {
        if (this.c == null) {
            this.c = GoIOCommFactory.getGoIOComm();
            if (!this.c.init()) {
                b.log(Level.SEVERE, "goIOComm.init() failed");
                return 0;
            }
        }
        if (this.d != null) {
            this.c.closeSensor(this.d);
        } else {
            this.d = this.c.getFirstSensor();
        }
        if (this.d != null) {
            boolean bl = this.c.openSensor(this.d);
            if (!bl) {
                b.log(Level.INFO, "Can't open sensor, so indicate failure");
                this.d = null;
                return 0;
            }
        } else {
            b.log(Level.WARNING, "Sensor not found!");
            return 0;
        }
        b.log(Level.INFO, "Found goio sensor: " + this.d);
        this.a();
        return this.d.getSensorType();
    }

    public List<GoIOSensor> getConnectedSensors() {
        ArrayList<GoIOSensor> arrayList = new ArrayList<GoIOSensor>();
        if (this.c == null) {
            this.c = GoIOCommFactory.getGoIOComm();
            if (!this.c.init()) {
                b.log(Level.SEVERE, "goIOComm.init() failed");
            }
        }
        GoIOSensor goIOSensor = this.c.getFirstSensor();
        while (goIOSensor != null) {
            boolean bl = this.c.openSensor(goIOSensor);
            if (bl) {
                arrayList.add(goIOSensor);
                this.c.closeSensor(goIOSensor);
            } else if (this.d != null && this.d.equals(goIOSensor)) {
                arrayList.add(this.d);
            }
            goIOSensor = this.c.getNextSensor();
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public void pickDifferentSensor(GoIOSensor newSensor) {
        if (newSensor != null && !newSensor.equals(this.d)) {
            void var1_1;
            if (this.d != null) {
                this.c.closeSensor(this.d);
                this.d = null;
            }
            boolean bl = Platform.isFxApplicationThread();
            new Thread("PickSensor Thread", bl, (GoIOSensor)var1_1){
                private /* synthetic */ boolean c;
                final /* synthetic */ GoIOSensor a;
                {
                    this.c = bl;
                    this.a = goIOSensor;
                    super(string);
                }

                @Override
                public final void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    GoIOCommManager.a(this.c, new Runnable(this){
                        private /* synthetic */ 1 a;
                        {
                            this.a = var1_1;
                        }

                        @Override
                        public final void run() {
                            this.a.GoIOCommManager.this.d = this.a.a;
                            boolean bl = this.a.GoIOCommManager.this.c.openSensor(this.a.GoIOCommManager.this.d);
                            if (bl) {
                                GoIOCommManager.b.log(Level.INFO, "User switched to new goio sensor: " + this.a.GoIOCommManager.this.d);
                                return;
                            }
                            GoIOCommManager.b.log(Level.INFO, "Can't open sensor, so indicate that no sensor is currently active");
                            this.a.GoIOCommManager.this.d = null;
                        }
                    });
                }
            }.start();
        }
    }

    private static void a(boolean bl, Runnable runnable) {
        if (bl) {
            Platform.runLater((Runnable)runnable);
            return;
        }
        runnable.run();
    }

    public boolean endSession() {
        if (this.d != null) {
            this.c.closeSensor(this.d);
            this.d = null;
        }
        this.a();
        return true;
    }

    public boolean startInputStream() {
        this.a();
        return true;
    }

    public boolean stopInputStream() {
        this.a();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean sendCommand(String commandBuffer) {
        void var1_1;
        if (this.c == null) {
            b.log(Level.WARNING, "sendCommand but goIOComm is null (perhaps emu state was restored from previous EasyData session).");
            return false;
        }
        if (this.d == null) {
            b.log(Level.WARNING, "sendCommand called and sensor is null");
            return false;
        }
        this.e = var1_1;
        this.f = ByteHexStringUtils.hexStringToByteArray(this.e);
        boolean bl = this.f[0];
        if (bl || bl || bl) {
            boolean bl2 = this.g = bl;
            if (bl) {
                this.c.clearIO(this.d);
            }
        }
        boolean bl3 = this.c.sendCommandPacket(this.d, this.f);
        bl = bl3;
        if (bl3) {
            this.h = true;
        }
        return bl;
    }

    protected String processSingleResponse() {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        if (this.e != null) {
            int n = this.c.getCommandResponsePacket(this.d, byArray, 2000);
            if (n == 0) {
                b.log(Level.WARNING, "getCommandResponsePacket TIMED OUT");
                this.h = false;
                return null;
            }
            if (n < 0) {
                b.log(Level.WARNING, "getCommandResponsePacket FAILURE");
                this.h = false;
                return null;
            }
            if ((byArray[0] & 0x10) == 16) {
                this.h = false;
            }
            return ByteHexStringUtils.byteArrayToHexString(byArray);
        }
        this.h = false;
        return null;
    }

    protected String processMeasurementResponse() {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        int n = this.c.getMeasurementResponsePacket(this.d, byArray, 1);
        if (n == 0) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        n = this.c.getMeasurementResponsePacket(this.d, byArray2, 1);
        if (n > 0) {
            return ByteHexStringUtils.byteArrayToHexString(byArray) + ByteHexStringUtils.byteArrayToHexString(byArray2);
        }
        return ByteHexStringUtils.byteArrayToHexString(byArray);
    }

    public String getResponse() {
        String string = this.d == null ? "" : (this.h ? this.processSingleResponse() : (this.g ? this.processMeasurementResponse() : null));
        if (string == null && !this.isCurrentSensorStillConnected()) {
            string = "";
        }
        return string;
    }

    public boolean isCurrentSensorStillConnected() {
        if (this.d == null) {
            return false;
        }
        return this.c.isStillConnected(this.d);
    }
}

