/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.swing.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.ReflectionUtil;
import com.teamdev.jxbrowser.chromium.swing.internal.Native;
import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class NativeMac
extends Native {
    private static final Logger a = LoggerProvider.getBrowserLogger();

    @Override
    public long getWindowHandle(Component component) {
        Object object = SwingUtilities.getWindowAncestor(component);
        if (object != null) {
            if (Environment.isJRE6()) {
                object = NativeMac.a((Window)object);
                return (Long)ReflectionUtil.invokeMethod(object, "getViewPtr");
            }
            object = NativeMac.a((Window)object);
            object = ReflectionUtil.invokeMethod(object, "getPlatformWindow");
            String string = object.getClass().getName();
            a.info("Get native window handle from " + string);
            if (string.endsWith("CPlatformWindow")) {
                object = ReflectionUtil.invokeMethod(object, "getContentView");
                return (Long)ReflectionUtil.invokeMethod(object, "getAWTView");
            }
            if (string.endsWith("CViewPlatformEmbeddedFrame")) {
                return (Long)ReflectionUtil.invokeMethod(object, "getNSViewPtr");
            }
            a.warning("Failed to get native window handle. Unsupported container: " + string);
        }
        return 0L;
    }

    private static Object a(Window object) {
        try {
            object = object.getClass().getMethod("getPeer", new Class[0]).invoke(object, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        return object;
    }
}

