/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.javafx.internal;

import com.sun.javafx.stage.EmbeddedWindow;
import com.teamdev.jxbrowser.chromium.BrowserKeyEvent;
import com.teamdev.jxbrowser.chromium.internal.NativeKeyModifiers;
import com.teamdev.jxbrowser.chromium.internal.SharedMemoryLibrary;
import com.teamdev.jxbrowser.chromium.javafx.internal.MouseEventType;
import com.teamdev.jxbrowser.chromium.javafx.internal.Native;
import com.teamdev.jxbrowser.chromium.swing.internal.SwingUtil;
import java.awt.Point;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.paint.Color;
import javafx.stage.Window;

public class FXUtil {
    private static final Map<EventType<MouseEvent>, MouseEventType> a = new HashMap<EventType<MouseEvent>, MouseEventType>();
    private static final Map<EventType<KeyEvent>, BrowserKeyEvent.KeyEventType> b = new HashMap<EventType<KeyEvent>, BrowserKeyEvent.KeyEventType>();

    public static int getNativeEventType(MouseEvent event) {
        Object object = event.getEventType();
        if ((object = a.get(object)) != null) {
            return ((MouseEventType)((Object)object)).getValue();
        }
        return 0;
    }

    public static BrowserKeyEvent.KeyEventType getBrowserKeyEventType(KeyEvent event) {
        KeyEvent keyEvent;
        return b.get(keyEvent.getEventType());
    }

    public static EventType<KeyEvent> getJavaEventType(int nativeEventType) {
        int n2;
        for (Map.Entry<EventType<KeyEvent>, BrowserKeyEvent.KeyEventType> entry : b.entrySet()) {
            if (entry.getValue().getValue() != nativeEventType) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Unsupported event type: " + n2);
    }

    public static int getModifiers(KeyEvent event) {
        KeyEvent keyEvent;
        int n2 = 0;
        if (event.isShiftDown()) {
            n2 = 0 | NativeKeyModifiers.SHIFT_DOWN_MASK.getValue();
        }
        if (event.isControlDown()) {
            n2 |= NativeKeyModifiers.CTRL_DOWN_MASK.getValue();
        }
        if (event.isAltDown()) {
            n2 |= NativeKeyModifiers.ALT_DOWN_MASK.getValue();
        }
        if (keyEvent.isMetaDown()) {
            n2 |= NativeKeyModifiers.META_DOWN_MASK.getValue();
        }
        return n2;
    }

    public static int getModifiers(ScrollEvent event) {
        ScrollEvent scrollEvent;
        int n2 = 0;
        if (event.isShiftDown()) {
            n2 = 0 | NativeKeyModifiers.SHIFT_DOWN_MASK.getValue();
        }
        if (event.isControlDown()) {
            n2 |= NativeKeyModifiers.CTRL_DOWN_MASK.getValue();
        }
        if (event.isAltDown()) {
            n2 |= NativeKeyModifiers.ALT_DOWN_MASK.getValue();
        }
        if (scrollEvent.isMetaDown()) {
            n2 |= NativeKeyModifiers.META_DOWN_MASK.getValue();
        }
        return n2;
    }

    public static int getNativeModifiers(MouseEvent event) {
        MouseEvent mouseEvent;
        int n2 = 0;
        if (event.isShiftDown()) {
            n2 = 0 | NativeKeyModifiers.SHIFT_DOWN_MASK.getValue();
        }
        if (event.isControlDown()) {
            n2 |= NativeKeyModifiers.CTRL_DOWN_MASK.getValue();
        }
        if (event.isAltDown()) {
            n2 |= NativeKeyModifiers.ALT_DOWN_MASK.getValue();
        }
        if (event.isMetaDown()) {
            n2 |= NativeKeyModifiers.META_DOWN_MASK.getValue();
        }
        if (event.isPrimaryButtonDown()) {
            n2 |= NativeKeyModifiers.LEFT_BUTTON_MASK.getValue();
        }
        if (event.isMiddleButtonDown()) {
            n2 |= NativeKeyModifiers.MIDDLE_BUTTON_MASK.getValue();
        }
        if (mouseEvent.isSecondaryButtonDown()) {
            n2 |= NativeKeyModifiers.RIGHT_BUTTON_MASK.getValue();
        }
        return n2;
    }

    public static Window getWindowForNode(Node node) {
        Node node2;
        if (node != null && (node2 = node2.getScene()) != null) {
            return node2.getWindow();
        }
        return null;
    }

    public static BrowserKeyEvent.KeyModifiers getBrowserKeyModifiers(KeyEvent event) {
        KeyEvent keyEvent;
        BrowserKeyEvent.KeyModifiersBuilder keyModifiersBuilder = new BrowserKeyEvent.KeyModifiersBuilder();
        if (event.isShiftDown()) {
            keyModifiersBuilder.shiftDown();
        }
        if (event.isControlDown()) {
            keyModifiersBuilder.ctrlDown();
        }
        if (event.isAltDown()) {
            keyModifiersBuilder.altDown();
        }
        if (keyEvent.isMetaDown()) {
            keyModifiersBuilder.metaDown();
        }
        return keyModifiersBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isDpiAware(Window window, double scaleFactor) {
        void var1_2;
        boolean bl = window instanceof EmbeddedWindow;
        if (bl) {
            return SwingUtil.isDpiAware();
        }
        return FXUtil.isDpiAware((double)var1_2);
    }

    public static boolean isDpiAware(double scaleFactor) {
        double d2;
        return Native.getInstance().isDpiAware(d2);
    }

    public static Color convertToFXColor(java.awt.Color color) {
        java.awt.Color color2;
        double d2 = (double)color.getAlpha() / 255.0;
        return Color.rgb((int)color.getRed(), (int)color.getGreen(), (int)color2.getBlue(), (double)d2);
    }

    public static java.awt.Color convertToAWTColor(Color color) {
        Color color2;
        int n2 = color.getRed() == 0.0 ? 0 : (int)(255.0 * color.getRed());
        int n3 = color.getGreen() == 0.0 ? 0 : (int)(255.0 * color.getGreen());
        int n4 = color.getBlue() == 0.0 ? 0 : (int)(255.0 * color.getBlue());
        int n5 = color.getOpacity() == 0.0 ? 0 : (int)(255.0 * color2.getOpacity());
        return new java.awt.Color(n2, n3, n4, n5);
    }

    public static void invokeInUiThreadAndWait(Runnable runnable) {
        FutureTask<Object> futureTask;
        if (runnable == null) {
            return;
        }
        if (Platform.isFxApplicationThread()) {
            runnable.run();
            return;
        }
        futureTask = new FutureTask<Object>(futureTask, null);
        Platform.runLater(futureTask);
        try {
            futureTask.get();
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException(executionException);
        }
    }

    public static Point getDpiAwareCoordinatesForWindow(Point location, Window window) {
        String string;
        Point point;
        point = new Point(point);
        long l2 = Native.getInstance().getWindowHandle((Window)string);
        string = SharedMemoryLibrary.getInstance().getDisplayIdForWindow(l2);
        double d2 = SharedMemoryLibrary.getInstance().getScaleFactorForDisplay(string);
        if (!FXUtil.isDpiAware(d2)) {
            point.x = (int)Math.round((double)point.x * d2);
            point.y = (int)Math.round((double)point.y * d2);
        }
        return point;
    }

    public static JFXPanel getJFXPanel(Window window) {
        Object object = FXUtil.getEmbeddedOuter(window);
        if (object instanceof JFXPanel) {
            return (JFXPanel)object;
        }
        return null;
    }

    public static Object getEmbeddedOuter(Window window) {
        try {
            Object object = window.impl_getPeer();
            Class<?> clazz = Class.forName("com.sun.javafx.tk.quantum.EmbeddedStage");
            if (clazz.isInstance(object)) {
                Object object2;
                object = clazz.getDeclaredField("host");
                ((Field)object).setAccessible(true);
                object2 = ((Field)object).get(object2.impl_getPeer());
                object = object2.getClass().getDeclaredField("this$0");
                ((Field)object).setAccessible(true);
                return ((Field)object).get(object2);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    static {
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_CLICKED, MouseEventType.MOUSE_CLICKED);
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_PRESSED, MouseEventType.MOUSE_PRESSED);
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_RELEASED, MouseEventType.MOUSE_RELEASED);
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_MOVED, MouseEventType.MOUSE_MOVED);
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_ENTERED, MouseEventType.MOUSE_ENTERED);
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_EXITED, MouseEventType.MOUSE_EXITED);
        a.put((EventType<MouseEvent>)MouseEvent.MOUSE_DRAGGED, MouseEventType.MOUSE_DRAGGED);
        b.put((EventType<KeyEvent>)KeyEvent.KEY_PRESSED, BrowserKeyEvent.KeyEventType.PRESSED);
        b.put((EventType<KeyEvent>)KeyEvent.KEY_RELEASED, BrowserKeyEvent.KeyEventType.RELEASED);
        b.put((EventType<KeyEvent>)KeyEvent.KEY_TYPED, BrowserKeyEvent.KeyEventType.TYPED);
    }
}

