/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.ipc.ChromiumProcess;
import com.teamdev.jxbrowser.chromium.internal.ipc.ExternalChromiumProcessLinux64;
import com.teamdev.jxbrowser.chromium.internal.ipc.ExternalChromiumProcessMac;
import com.teamdev.jxbrowser.chromium.internal.ipc.ExternalChromiumProcessWin;
import com.teamdev.jxbrowser.chromium.internal.ipc.InternalChromiumProcess;
import java.io.File;

public final class ChromiumProcessFactory {
    public static ChromiumProcess create(String chromiumDir) {
        if (Environment.isWindows()) {
            String string = "browsercore32.exe";
            if (!new File(chromiumDir, string).exists()) {
                string = "browsercore64.exe";
            }
            return new ExternalChromiumProcessWin(chromiumDir, string);
        }
        if (Environment.isMac()) {
            if (Boolean.getBoolean("jxbrowser.ipc.external")) {
                return new ExternalChromiumProcessMac(chromiumDir);
            }
            return new InternalChromiumProcess(chromiumDir);
        }
        if (Environment.isLinux() && Environment.is64Bit()) {
            String string;
            return new ExternalChromiumProcessLinux64(string);
        }
        throw new IllegalStateException("Unsupported operating system.");
    }
}

